/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractFilterChildren;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnVcs;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNStatusFileProvider;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SvnNestedTypeRechecker {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.SvnNestedTypeRechecker");
    private final MultiMap<VirtualFile, RootUrlInfo> myRoots;
    private Map<String, RootUrlInfo> mySourceItems;
    private Map<String, Map<String, File>> myTreeTravellingMap;
    private final Project myProject;

    public SvnNestedTypeRechecker(Project project, List<RootUrlInfo> roots) {
        this.myProject = project;
        NestedGatherer nestedGatherer = new NestedGatherer();
        nestedGatherer.doFilter(new ArrayList<RootUrlInfo>(roots));
        this.myRoots = nestedGatherer.getNested();
        this.mySourceItems = new HashMap<String, RootUrlInfo>();
        for (VirtualFile root : this.myRoots.keySet()) {
            Collection items = this.myRoots.get((Object)root);
            for (RootUrlInfo item : items) {
                this.mySourceItems.put(FileUtil.nameToCompare((String)item.getVirtualFile().getPath()), item);
            }
        }
    }

    private void initTravellingMap() {
        this.myTreeTravellingMap = new HashMap<String, Map<String, File>>();
        MultiMap tmpMap = new MultiMap();
        for (VirtualFile parent : this.myRoots.keySet()) {
            Collection children = this.myRoots.get((Object)parent);
            block1: for (RootUrlInfo child : children) {
                VirtualFile current = child.getVirtualFile();
                while (!current.equals(parent)) {
                    tmpMap.putValue((Object)current.getParent(), (Object)new File(current.getPath()));
                    if ((current = current.getParent()).getParent() != null) continue;
                    continue block1;
                }
            }
        }
        for (VirtualFile dir : tmpMap.keySet()) {
            HashMap<String, File> currMap = new HashMap<String, File>();
            Collection coll = tmpMap.get((Object)dir);
            for (File file : coll) {
                currMap.put(file.getAbsolutePath(), file);
            }
            this.myTreeTravellingMap.put(FileUtil.nameToCompare((String)dir.getPath()), currMap);
        }
    }

    public void run() {
        if (!this.myRoots.isEmpty()) {
            this.initTravellingMap();
            ISVNStatusFileProvider fileProvider = new ISVNStatusFileProvider(){

                public Map getChildrenFiles(File parent) {
                    Map children = (Map)SvnNestedTypeRechecker.this.myTreeTravellingMap.get(FileUtil.nameToCompare((String)parent.getAbsolutePath()));
                    return children == null ? Collections.emptyMap() : children;
                }
            };
            SvnVcs vcs = SvnVcs.getInstance(this.myProject);
            SVNStatusClient client = vcs.createStatusClient();
            client.setFilesProvider(fileProvider);
            for (VirtualFile parent : this.myRoots.keySet()) {
                try {
                    client.doStatus(new File(parent.getPath()), SVNRevision.WORKING, SVNDepth.INFINITY, false, true, true, false, new ISVNStatusHandler(){

                        public void handleStatus(SVNStatus status) throws SVNException {
                            RootUrlInfo urlInfo;
                            boolean switched = status.isSwitched();
                            boolean externals = SVNStatusType.STATUS_EXTERNAL.equals(status.getContentsStatus());
                            if ((switched || externals) && (urlInfo = (RootUrlInfo)SvnNestedTypeRechecker.this.mySourceItems.get(FileUtil.nameToCompare((String)status.getFile().getAbsolutePath()))) != null) {
                                if (switched) {
                                    urlInfo.setType(NestedCopyType.switched);
                                } else {
                                    urlInfo.setType(NestedCopyType.external);
                                }
                            }
                        }
                    }, null);
                }
                catch (SVNException e) {
                    LOG.debug((Throwable)e);
                }
            }
        }
    }

    private static class NestedGatherer
    extends AbstractFilterChildren<RootUrlInfo> {
        private final MultiMap<VirtualFile, RootUrlInfo> myNested = new MultiMap();

        private NestedGatherer() {
        }

        protected void sortAscending(List<RootUrlInfo> rootUrlInfos) {
            Collections.sort(rootUrlInfos, new Comparator<RootUrlInfo>(){

                @Override
                public int compare(RootUrlInfo r1, RootUrlInfo r2) {
                    return new Integer(r1.getVirtualFile().getPath().length()).compareTo(r2.getVirtualFile().getPath().length());
                }
            });
        }

        protected boolean isAncestor(RootUrlInfo parent, RootUrlInfo child) {
            boolean result = VfsUtil.isAncestor((VirtualFile)parent.getVirtualFile(), (VirtualFile)child.getVirtualFile(), (boolean)true);
            if (result) {
                this.myNested.putValue((Object)parent.getVirtualFile(), (Object)child);
            }
            return result;
        }

        public MultiMap<VirtualFile, RootUrlInfo> getNested() {
            return this.myNested;
        }
    }
}

