/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.idea.svn.RootUrlInfo;

public class SvnMapping {
    private final List<VirtualFile> myLonelyRoots;
    private final Map<String, RootUrlInfo> myFile2UrlMap = new HashMap<String, RootUrlInfo>();
    private final Map<String, RootUrlInfo> myUrl2FileMap = new HashMap<String, RootUrlInfo>();
    private boolean myRootsDifferFromSettings = false;
    private List<VirtualFile> myPreCalculatedUnderVcsRoots = null;

    public SvnMapping() {
        this.myLonelyRoots = new ArrayList<VirtualFile>();
    }

    public void copyFrom(SvnMapping other) {
        this.myFile2UrlMap.clear();
        this.myUrl2FileMap.clear();
        this.myLonelyRoots.clear();
        this.myFile2UrlMap.putAll(other.myFile2UrlMap);
        this.myUrl2FileMap.putAll(other.myUrl2FileMap);
        this.myLonelyRoots.addAll(other.myLonelyRoots);
        this.myRootsDifferFromSettings = other.myRootsDifferFromSettings;
        this.myPreCalculatedUnderVcsRoots = null;
    }

    public void addAll(Collection<RootUrlInfo> roots) {
        for (RootUrlInfo rootInfo : roots) {
            VirtualFile file = rootInfo.getVirtualFile();
            File ioFile = new File(file.getPath());
            this.myRootsDifferFromSettings |= !rootInfo.getRoot().getPath().equals(file.getPath());
            this.myFile2UrlMap.put(ioFile.getAbsolutePath(), rootInfo);
            this.myUrl2FileMap.put(rootInfo.getAbsoluteUrl(), rootInfo);
        }
    }

    public void add(RootUrlInfo rootInfo) {
        VirtualFile file = rootInfo.getVirtualFile();
        File ioFile = new File(file.getPath());
        this.myRootsDifferFromSettings |= !rootInfo.getRoot().getPath().equals(file.getPath());
        this.myFile2UrlMap.put(ioFile.getAbsolutePath(), rootInfo);
        this.myUrl2FileMap.put(rootInfo.getAbsoluteUrl(), rootInfo);
    }

    public List<VirtualFile> getUnderVcsRoots() {
        if (this.myPreCalculatedUnderVcsRoots == null) {
            this.myPreCalculatedUnderVcsRoots = new ArrayList<VirtualFile>();
            for (RootUrlInfo info : this.myFile2UrlMap.values()) {
                this.myPreCalculatedUnderVcsRoots.add(info.getVirtualFile());
            }
        }
        return this.myPreCalculatedUnderVcsRoots;
    }

    public List<RootUrlInfo> getAllCopies() {
        return new ArrayList<RootUrlInfo>(this.myFile2UrlMap.values());
    }

    public Collection<String> getFileRoots() {
        return this.myFile2UrlMap.keySet();
    }

    public Collection<String> getUrls() {
        return this.myUrl2FileMap.keySet();
    }

    public RootUrlInfo byFile(String path) {
        return this.myFile2UrlMap.get(path);
    }

    public RootUrlInfo byUrl(String url) {
        return this.myUrl2FileMap.get(url);
    }

    public boolean isEmpty() {
        return this.myUrl2FileMap.isEmpty();
    }

    public boolean isRootsDifferFromSettings() {
        return this.myRootsDifferFromSettings;
    }

    public void reportLonelyRoots(Collection<VirtualFile> roots) {
        this.myLonelyRoots.addAll(roots);
    }

    public List<VirtualFile> getLonelyRoots() {
        return this.myLonelyRoots;
    }
}

