/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNAdminUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNLog;

public class SVNMergeFileSet {
    private String myLocalFilePath;
    private String myBaseFilePath;
    private String myRepositoryFilePath;
    private String myWCFilePath;
    private String myMergeResultFilePath;
    private String myMimeType;
    private SVNAdminArea myAdminArea;
    private SVNLog myLog;
    private String myLocalLabel;
    private String myBaseLabel;
    private String myRepositoryLabel;
    private File myLocalFile;
    private File myBaseFile;
    private File myRepositoryFile;
    private File myMergeResultFile;
    private File myCopyFromFile;
    private Collection myTmpPaths = new ArrayList();

    public SVNMergeFileSet(SVNAdminArea adminArea, SVNLog log, File baseFile, File localFile, String wcPath, File reposFile, File resultFile, File copyFromFile, String mimeType) {
        this.myAdminArea = adminArea;
        this.myLog = log;
        this.myLocalFile = localFile;
        this.myBaseFile = baseFile;
        this.myRepositoryFile = reposFile;
        this.myWCFilePath = wcPath;
        this.myMergeResultFile = resultFile;
        this.myCopyFromFile = copyFromFile;
        this.myMimeType = mimeType;
        if (this.myBaseFile != null) {
            String string = this.myBaseFilePath = SVNPathUtil.isAncestor(this.myAdminArea.getAdminDirectory().getAbsolutePath(), this.myBaseFile.getAbsolutePath()) ? SVNFileUtil.getBasePath(this.myBaseFile) : null;
        }
        if (this.myLocalFile != null) {
            this.myLocalFilePath = SVNFileUtil.getBasePath(this.myLocalFile);
        }
        if (this.myRepositoryFile != null) {
            String string = this.myRepositoryFilePath = SVNPathUtil.isAncestor(this.myAdminArea.getAdminDirectory().getAbsolutePath(), this.myRepositoryFile.getAbsolutePath()) ? SVNFileUtil.getBasePath(this.myRepositoryFile) : null;
        }
        if (this.myMergeResultFile != null) {
            this.myMergeResultFilePath = SVNFileUtil.getBasePath(this.myMergeResultFile);
        }
    }

    public void setMergeLabels(String baseLabel, String localLabel, String repositoryLabel) {
        this.myLocalLabel = localLabel == null ? ".working" : localLabel;
        this.myBaseLabel = baseLabel == null ? ".old" : baseLabel;
        this.myRepositoryLabel = repositoryLabel == null ? ".new" : repositoryLabel;
    }

    public SVNLog getLog() {
        return this.myLog;
    }

    public String getBaseLabel() {
        return this.myBaseLabel;
    }

    public String getLocalLabel() {
        return this.myLocalLabel;
    }

    public String getRepositoryLabel() {
        return this.myRepositoryLabel;
    }

    public String getBasePath() throws SVNException {
        if (this.myBaseFilePath == null && this.myBaseFile != null) {
            File tmp = SVNAdminUtil.createTmpFile(this.myAdminArea);
            SVNFileUtil.copyFile(this.myBaseFile, tmp, false);
            this.myBaseFilePath = SVNFileUtil.getBasePath(tmp);
            this.myTmpPaths.add(this.myBaseFilePath);
        }
        return this.myBaseFilePath;
    }

    public String getLocalPath() {
        return this.myLocalFilePath;
    }

    public String getWCPath() {
        return this.myWCFilePath;
    }

    public String getRepositoryPath() throws SVNException {
        if (this.myRepositoryFilePath == null && this.myRepositoryFile != null) {
            File tmp = SVNAdminUtil.createTmpFile(this.myAdminArea);
            SVNFileUtil.copyFile(this.myRepositoryFile, tmp, false);
            this.myRepositoryFilePath = SVNFileUtil.getBasePath(tmp);
            this.myTmpPaths.add(this.myRepositoryFilePath);
        }
        return this.myRepositoryFilePath;
    }

    public String getResultPath() {
        return this.myMergeResultFilePath;
    }

    public File getBaseFile() {
        return this.myBaseFile;
    }

    public File getWCFile() {
        return this.myAdminArea.getFile(this.myWCFilePath);
    }

    public File getLocalFile() {
        return this.myLocalFile;
    }

    public File getRepositoryFile() {
        return this.myRepositoryFile;
    }

    public File getResultFile() {
        return this.myMergeResultFile;
    }

    public boolean isBinary() {
        return SVNProperty.isBinaryMimeType(this.myMimeType);
    }

    public String getMimeType() {
        return this.myMimeType;
    }

    public SVNAdminArea getAdminArea() {
        return this.myAdminArea;
    }

    public void dispose() throws SVNException {
        SVNProperties command = new SVNProperties();
        Iterator paths = this.myTmpPaths.iterator();
        while (paths.hasNext()) {
            String path = (String)paths.next();
            command.put("name", path);
            this.myLog.addCommand("rm", command, false);
            command.clear();
        }
    }

    public File getCopyFromFile() {
        return this.myCopyFromFile;
    }

    public String getCopyFromPath() {
        String root = this.myAdminArea.getRoot().getAbsolutePath().replace(File.separatorChar, '/');
        String copyFrom = this.getCopyFromFile().getAbsolutePath().replace(File.separatorChar, '/');
        String copyFromPath = copyFrom.substring(root.length());
        copyFromPath = copyFromPath.startsWith("/") ? copyFromPath.substring("/".length()) : copyFromPath;
        return copyFromPath;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{Merge File Set: ");
        buffer.append("admin area = ");
        buffer.append(this.myAdminArea);
        buffer.append("; local file path = ");
        buffer.append(this.myLocalFilePath);
        buffer.append("; base file path =");
        buffer.append(this.myBaseFilePath);
        buffer.append("; repository file path = ");
        buffer.append(this.myRepositoryFilePath);
        buffer.append("; WC file path = ");
        buffer.append(this.myWCFilePath);
        buffer.append("; merge result path = ");
        buffer.append(this.myMergeResultFilePath);
        buffer.append("; local file = ");
        buffer.append(this.myLocalFile);
        buffer.append("; base file = ");
        buffer.append(this.myBaseFile);
        buffer.append("; repository file = ");
        buffer.append(this.myRepositoryFile);
        buffer.append("; merge result file = ");
        buffer.append(this.myMergeResultFile);
        buffer.append('}');
        return buffer.toString();
    }
}

