/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.javaToGrovyRename;

import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public class RenameJavaFileToGroovyFileAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        final PsiFile file = (PsiFile)e.getData(DataKeys.PSI_FILE);
        assert (RenameJavaFileToGroovyFileAction.isEnabled(file));
        assert (file != null);
        VirtualFile virtualFile = file.getVirtualFile();
        assert (virtualFile != null);
        String newExt = file.getLanguage() == StdLanguages.JAVA ? "groovy" : StdFileTypes.JAVA.getDefaultExtension();
        final String newName = virtualFile.getNameWithoutExtension() + "." + newExt;
        final Project project = (Project)e.getData(DataKeys.PROJECT);
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            file.setName(newName);
                        }
                        catch (IncorrectOperationException e1) {
                            ApplicationManager.getApplication().invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    Messages.showErrorDialog((Project)project, (String)("Cannot rename java file" + e1.getMessage()), (String)"Canot Rename");
                                }
                            });
                        }
                    }
                });
            }
        }, "Rename File", null);
    }

    public void update(AnActionEvent e) {
        PsiFile file = (PsiFile)e.getData(DataKeys.PSI_FILE);
        Presentation presentation = e.getPresentation();
        boolean enabled = RenameJavaFileToGroovyFileAction.isEnabled(file);
        presentation.setEnabled(enabled);
        presentation.setVisible(enabled);
        if (enabled) {
            assert (file != null);
            presentation.setText(file.getLanguage() == StdLanguages.JAVA ? "Rename To Groovy" : "Rename To Java");
        }
    }

    private static boolean isEnabled(PsiFile file) {
        if (file == null) {
            return false;
        }
        Language language = file.getLanguage();
        if (language == GroovyFileType.GROOVY_LANGUAGE) {
            return true;
        }
        if (language != StdLanguages.JAVA) {
            return false;
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)file);
        return module != null && LibrariesUtil.hasGroovySdk(module);
    }
}

