/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduceVariable;

import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.PsiType;
import com.intellij.ui.EditorComboBoxRenderer;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.StringComboboxEditor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventListener;
import java.util.HashMap;
import javax.swing.Action;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.EventListenerList;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.refactoring.GroovyNamesUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;
import org.jetbrains.plugins.groovy.refactoring.introduceVariable.GroovyIntroduceVariableBase;
import org.jetbrains.plugins.groovy.refactoring.introduceVariable.GroovyIntroduceVariableSettings;
import org.jetbrains.plugins.groovy.settings.GroovyApplicationSettings;

public class GroovyIntroduceVariableDialog
extends DialogWrapper {
    private final Project myProject;
    private final GrExpression myExpression;
    private final PsiType myType;
    private final int myOccurrencesCount;
    private final GroovyIntroduceVariableBase.Validator myValidator;
    private HashMap<String, PsiType> myTypeMap = null;
    private final EventListenerList myListenerList;
    private static final String REFACTORING_NAME = GroovyRefactoringBundle.message("introduce.variable.title", new Object[0]);
    private JPanel contentPane;
    private ComboBox myNameComboBox;
    private JCheckBox myCbIsFinal;
    private JCheckBox myCbReplaceAllOccurences;
    private JCheckBox myCbTypeSpec;
    private JComboBox myTypeComboBox;
    private JLabel myTypeLabel;
    private JLabel myNameLabel;
    private JButton buttonOK;
    public String myEnteredName;

    public GroovyIntroduceVariableDialog(Project project, GrExpression expression, PsiType psiType, int occurrencesCount, GroovyIntroduceVariableBase.Validator validator, String[] possibleNames) {
        super(project, true);
        this.$$$setupUI$$$();
        this.myListenerList = new EventListenerList();
        this.myProject = project;
        this.myExpression = expression;
        this.myType = psiType;
        this.myOccurrencesCount = occurrencesCount;
        this.myValidator = validator;
        this.setUpNameComboBox(possibleNames);
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.setTitle(REFACTORING_NAME);
        this.init();
        this.setUpDialog();
        this.updateOkStatus();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.contentPane;
    }

    public JComponent getContentPane() {
        return this.contentPane;
    }

    @Nullable
    protected String getEnteredName() {
        if (this.myNameComboBox.getEditor().getItem() instanceof String && ((String)this.myNameComboBox.getEditor().getItem()).length() > 0) {
            return (String)this.myNameComboBox.getEditor().getItem();
        }
        return null;
    }

    protected boolean isReplaceAllOccurrences() {
        return this.myCbReplaceAllOccurences.isSelected();
    }

    private boolean isDeclareFinal() {
        return this.myCbIsFinal.isSelected();
    }

    private PsiType getSelectedType() {
        if (!this.myCbTypeSpec.isSelected() || !this.myCbTypeSpec.isEnabled()) {
            return null;
        }
        return this.myTypeMap.get(this.myTypeComboBox.getSelectedItem());
    }

    private void setUpDialog() {
        this.myCbReplaceAllOccurences.setMnemonic(65);
        this.myCbReplaceAllOccurences.setFocusable(false);
        this.myCbIsFinal.setMnemonic(70);
        this.myCbIsFinal.setFocusable(false);
        this.myCbTypeSpec.setMnemonic(84);
        this.myCbTypeSpec.setFocusable(false);
        this.myNameLabel.setLabelFor((Component)this.myNameComboBox);
        this.myTypeLabel.setLabelFor(this.myTypeComboBox);
        if (this.myType == null) {
            this.myCbTypeSpec.setSelected(false);
            this.myCbTypeSpec.setEnabled(false);
            this.myTypeComboBox.setEnabled(false);
        } else {
            boolean specifyVarTypeExplicitly = GroovyApplicationSettings.getInstance().SPECIFY_VAR_TYPE_EXPLICITLY;
            this.myCbTypeSpec.setSelected(specifyVarTypeExplicitly);
            this.myTypeComboBox.setEnabled(specifyVarTypeExplicitly);
            this.myTypeMap = GroovyRefactoringUtil.getCompatibleTypeNames(this.myType);
            for (String typeName : this.myTypeMap.keySet()) {
                this.myTypeComboBox.addItem(typeName);
            }
        }
        this.myCbIsFinal.setSelected(GroovyApplicationSettings.getInstance().INTRODUCE_LOCAL_CREATE_FINALS);
        this.myCbTypeSpec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                GroovyIntroduceVariableDialog.this.myTypeComboBox.setEnabled(GroovyIntroduceVariableDialog.this.myCbTypeSpec.isSelected());
            }
        });
        if (this.myOccurrencesCount > 1) {
            this.myCbReplaceAllOccurences.setSelected(false);
            this.myCbReplaceAllOccurences.setEnabled(true);
            this.myCbReplaceAllOccurences.setText(this.myCbReplaceAllOccurences.getText() + " (" + this.myOccurrencesCount + " occurrences)");
        } else {
            this.myCbReplaceAllOccurences.setSelected(false);
            this.myCbReplaceAllOccurences.setEnabled(false);
        }
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroovyIntroduceVariableDialog.this.myTypeComboBox.requestFocus();
            }
        }, KeyStroke.getKeyStroke(89, 8), 2);
    }

    private void setUpNameComboBox(String[] possibleNames) {
        StringComboboxEditor comboEditor = new StringComboboxEditor(this.myProject, (FileType)GroovyFileType.GROOVY_FILE_TYPE, this.myNameComboBox);
        this.myNameComboBox.setEditor((ComboBoxEditor)comboEditor);
        this.myNameComboBox.setRenderer((ListCellRenderer)new EditorComboBoxRenderer((ComboBoxEditor)comboEditor));
        this.myNameComboBox.setEditable(true);
        this.myNameComboBox.setMaximumRowCount(8);
        this.myListenerList.add(DataChangedListener.class, new DataChangedListener());
        this.myNameComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GroovyIntroduceVariableDialog.this.fireNameDataChanged();
            }
        });
        ((EditorTextField)this.myNameComboBox.getEditor().getEditorComponent()).addDocumentListener(new DocumentListener(){

            public void beforeDocumentChange(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                GroovyIntroduceVariableDialog.this.fireNameDataChanged();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroovyIntroduceVariableDialog.this.myNameComboBox.requestFocus();
            }
        }, KeyStroke.getKeyStroke(78, 8), 2);
        for (String possibleName : possibleNames) {
            this.myNameComboBox.addItem((Object)possibleName);
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameComboBox;
    }

    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
    }

    protected void doOKAction() {
        if (!this.myValidator.isOK(this)) {
            return;
        }
        if (this.myCbTypeSpec.isEnabled()) {
            GroovyApplicationSettings.getInstance().SPECIFY_VAR_TYPE_EXPLICITLY = this.myCbTypeSpec.isSelected();
        }
        if (this.myCbIsFinal.isEnabled()) {
            GroovyApplicationSettings.getInstance().INTRODUCE_LOCAL_CREATE_FINALS = this.myCbIsFinal.isSelected();
        }
        super.doOKAction();
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("refactoring.introduceVariable");
    }

    GrExpression getExpression() {
        return this.myExpression;
    }

    private void updateOkStatus() {
        String text = this.getEnteredName();
        this.setOKActionEnabled(GroovyNamesUtil.isIdentifier(text));
    }

    private void fireNameDataChanged() {
        Object[] list;
        for (Object aList : list = this.myListenerList.getListenerList()) {
            if (!(aList instanceof DataChangedListener)) continue;
            ((DataChangedListener)aList).dataChanged();
        }
    }

    public GroovyIntroduceVariableSettings getSettings() {
        return new MyGroovyIntroduceVariableSettings(this);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JComboBox jComboBox;
        JLabel jLabel;
        ComboBox comboBox;
        JLabel jLabel2;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JPanel jPanel;
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCbIsFinal = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Declare final");
        jCheckBox3.setMnemonic('F');
        jCheckBox3.setDisplayedMnemonicIndex(8);
        jPanel3.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbReplaceAllOccurences = jCheckBox2 = new JCheckBox();
        ((Component)jCheckBox2).setEnabled(false);
        jCheckBox2.setText("Replace all occurrences");
        jCheckBox2.setMnemonic('A');
        jCheckBox2.setDisplayedMnemonicIndex(8);
        jPanel3.add((Component)jCheckBox2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myTypeLabel = jLabel2 = new JLabel();
        jLabel2.setText("Variable of type:");
        jLabel2.setDisplayedMnemonic('Y');
        jLabel2.setDisplayedMnemonicIndex(13);
        jPanel4.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myNameComboBox = comboBox = new ComboBox();
        comboBox.setLightWeightPopupEnabled(true);
        comboBox.setEditable(true);
        jPanel4.add((Component)comboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myNameLabel = jLabel = new JLabel();
        jLabel.setText("Name:");
        jLabel.setDisplayedMnemonic('N');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTypeComboBox = jComboBox = new JComboBox();
        jPanel4.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCbTypeSpec = jCheckBox = new JCheckBox();
        jCheckBox.setText("Specify type explicitly");
        jPanel5.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private static class MyGroovyIntroduceVariableSettings
    implements GroovyIntroduceVariableSettings {
        String myEnteredName;
        boolean myIsReplaceAllOccurrences;
        boolean myIsDeclareFinal;
        PsiType mySelectedType;

        public MyGroovyIntroduceVariableSettings(GroovyIntroduceVariableDialog dialog) {
            this.myEnteredName = dialog.getEnteredName();
            this.myIsReplaceAllOccurrences = dialog.isReplaceAllOccurrences();
            this.myIsDeclareFinal = dialog.isDeclareFinal();
            this.mySelectedType = dialog.getSelectedType();
        }

        @Override
        public String getEnteredName() {
            return this.myEnteredName;
        }

        @Override
        public boolean isReplaceAllOccurrences() {
            return this.myIsReplaceAllOccurrences;
        }

        @Override
        public boolean isDeclareFinal() {
            return this.myIsDeclareFinal;
        }

        @Override
        public PsiType getSelectedType() {
            return this.mySelectedType;
        }
    }

    class DataChangedListener
    implements EventListener {
        DataChangedListener() {
        }

        void dataChanged() {
            GroovyIntroduceVariableDialog.this.updateOkStatus();
        }
    }
}

