/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs.elements;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrStubElementType;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.GrFieldImpl;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrFieldStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.impl.GrFieldStubImpl;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrAnnotatedMemberIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrFieldNameIndex;

public class GrFieldElementType
extends GrStubElementType<GrFieldStub, GrField> {
    public GrFieldElementType() {
        super("field");
    }

    @Override
    public PsiElement createElement(ASTNode node) {
        return new GrFieldImpl(node);
    }

    public GrField createPsi(GrFieldStub stub) {
        return new GrFieldImpl(stub);
    }

    public GrFieldStub createStub(GrField psi, StubElement parentStub) {
        String[] annNames;
        GrModifierList modifiers = psi.getModifierList();
        if (modifiers == null) {
            annNames = ArrayUtil.EMPTY_STRING_ARRAY;
        } else {
            Object[] annotations = modifiers.getAnnotations();
            annNames = (String[])ContainerUtil.map((Object[])annotations, (Function)new Function<GrAnnotation, String>(){

                @Nullable
                public String fun(GrAnnotation grAnnotation) {
                    GrCodeReferenceElement element = grAnnotation.getClassReference();
                    if (element == null) {
                        return null;
                    }
                    return element.getReferenceName();
                }
            }, (Object[])new String[annotations.length]);
        }
        Set[] namedParametersArray = new Set[]{};
        if (psi instanceof GrFieldImpl) {
            namedParametersArray = psi.getNamedParametersArray();
        }
        return new GrFieldStubImpl(parentStub, StringRef.fromString((String)psi.getName()), annNames, namedParametersArray, GroovyElementTypes.FIELD, GrFieldStubImpl.buildFlags(psi));
    }

    public void serialize(GrFieldStub stub, StubOutputStream dataStream) throws IOException {
        GrFieldElementType.serializeFieldStub(stub, dataStream);
    }

    public GrFieldStub deserialize(StubInputStream dataStream, StubElement parentStub) throws IOException {
        return GrFieldElementType.deserializeFieldStub(dataStream, parentStub);
    }

    @Override
    public void indexStub(GrFieldStub stub, IndexSink sink) {
        GrFieldElementType.indexFieldStub(stub, sink);
    }

    static void serializeFieldStub(GrFieldStub stub, StubOutputStream dataStream) throws IOException {
        dataStream.writeName(stub.getName());
        String[] annotations = stub.getAnnotations();
        dataStream.writeByte(annotations.length);
        for (String s : annotations) {
            dataStream.writeName(s);
        }
        Set<String>[] namedParameters = stub.getNamedParameters();
        dataStream.writeByte(namedParameters.length);
        for (Set<String> namedParameterSet : namedParameters) {
            dataStream.writeByte(namedParameterSet.size());
            for (String namepParameter : namedParameterSet) {
                dataStream.writeUTF(namepParameter);
            }
        }
        dataStream.writeByte((int)stub.getFlags());
    }

    static GrFieldStub deserializeFieldStub(StubInputStream dataStream, StubElement parentStub) throws IOException {
        StringRef ref = dataStream.readName();
        int b = dataStream.readByte();
        String[] annNames = new String[b];
        for (int i = 0; i < b; ++i) {
            annNames[i] = dataStream.readName().toString();
        }
        int namedParametersSetNumber = dataStream.readByte();
        ArrayList namedParametersSets = new ArrayList();
        for (int i = 0; i < namedParametersSetNumber; ++i) {
            int curNamedParameterSetSize = dataStream.readByte();
            String[] namedParameterSetArray = new String[curNamedParameterSetSize];
            for (int j = 0; j < curNamedParameterSetSize; ++j) {
                namedParameterSetArray[j] = dataStream.readUTF();
            }
            HashSet<String> curSet = new HashSet<String>();
            curSet.addAll(Arrays.asList(namedParameterSetArray));
            namedParametersSets.add(curSet);
        }
        byte flags = dataStream.readByte();
        return new GrFieldStubImpl(parentStub, ref, annNames, namedParametersSets.toArray(new HashSet[namedParametersSets.size()]), GrFieldStubImpl.isEnumConstant(flags) ? GroovyElementTypes.ENUM_CONSTANT : GroovyElementTypes.FIELD, flags);
    }

    static void indexFieldStub(GrFieldStub stub, IndexSink sink) {
        String name = stub.getName();
        if (name != null) {
            sink.occurrence(GrFieldNameIndex.KEY, (Object)name);
        }
        for (String annName : stub.getAnnotations()) {
            if (annName == null) continue;
            sink.occurrence(GrAnnotatedMemberIndex.KEY, (Object)annName);
        }
    }
}

