/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataCache;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.impl.FileManagerImpl;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.GroovyIcons;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptType;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTopLevelDefintion;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMembersDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.GrTopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyFileBaseImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrFileStub;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;

public class GroovyFileImpl
extends GroovyFileBaseImpl
implements GroovyFile {
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.lang.psi.impl.GroovyFileImpl");
    private static final Object lock = new Object();
    private volatile Boolean myScript;
    private GroovyScriptClass myScriptClass;
    private static final String SYNTHETIC_PARAMETER_NAME = "args";
    private GrParameter mySyntheticArgsParameter = null;
    private PsiElement myContext;
    private static final UserDataCache<CachedValue<GlobalSearchScope>, GroovyFile, GlobalSearchScope> RESOLVE_SCOPE_CACHE = new UserDataCache<CachedValue<GlobalSearchScope>, GroovyFile, GlobalSearchScope>("RESOLVE_SCOPE_CACHE"){

        protected CachedValue<GlobalSearchScope> compute(final GroovyFile file, final GlobalSearchScope baseScope) {
            return CachedValuesManager.getManager((Project)file.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<GlobalSearchScope>(){

                public CachedValueProvider.Result<GlobalSearchScope> compute() {
                    GlobalSearchScope scope = GroovyScriptType.getScriptType(file).patchResolveScope(file, baseScope);
                    return CachedValueProvider.Result.create((Object)scope, (Object[])new Object[]{file, ProjectRootManager.getInstance((Project)file.getProject())});
                }
            }, false);
        }
    };

    public GroovyFileImpl(FileViewProvider viewProvider) {
        super(viewProvider, GroovyFileType.GROOVY_FILE_TYPE.getLanguage());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public String getPackageName() {
        String string;
        StubElement stub = this.getStub();
        if (stub instanceof GrFileStub) {
            String string2 = ((GrFileStub)stub).getPackageName().toString();
            string = string2;
            if (string2 != null) return string;
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileImpl.getPackageName must not return null");
        }
        GrPackageDefinition packageDef = (GrPackageDefinition)this.findChildByClass(GrPackageDefinition.class);
        if (packageDef == null) return "";
        String string3 = packageDef.getPackageName();
        string = string3;
        if (string3 == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileImpl.getPackageName must not return null");
        return string;
    }

    @Override
    public GrPackageDefinition getPackageDefinition() {
        return (GrPackageDefinition)this.findChildByClass(GrPackageDefinition.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GrParameter getSyntheticArgsParameter() {
        if (this.mySyntheticArgsParameter == null) {
            GrParameter candidate = GroovyPsiElementFactory.getInstance(this.getProject()).createParameter(SYNTHETIC_PARAMETER_NAME, "java.lang.String[]", this);
            Object object = lock;
            synchronized (object) {
                if (this.mySyntheticArgsParameter == null) {
                    this.mySyntheticArgsParameter = candidate;
                }
            }
        }
        return this.mySyntheticArgsParameter;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        PsiPackage defaultPackage;
        Set<String> maybeImplicit;
        GrImportStatement[] imports;
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileImpl.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileImpl.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileImpl.processDeclarations must not be null");
        }
        GroovyScriptClass scriptClass = this.getScriptClass();
        if (scriptClass != null) {
            if (!scriptClass.processDeclarations(processor, state, lastParent, place)) {
                return false;
            }
            if (!ResolveUtil.processElement(processor, (PsiNamedElement)scriptClass)) {
                return false;
            }
        }
        for (GrTypeDefinition definition : this.getTypeDefinitions()) {
            if (ResolveUtil.processElement(processor, definition)) continue;
            return false;
        }
        if (lastParent != null && !(lastParent instanceof GrTypeDefinition) && scriptClass != null && !ResolveUtil.processElement(processor, this.getSyntheticArgsParameter())) {
            return false;
        }
        if (!GroovyFileImpl.processChildrenScopes(this, processor, state, lastParent, place)) {
            return false;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.getProject());
        for (GrImportStatement importStatement : imports = this.getImportStatements()) {
            if (!importStatement.isAliasedImport() || importStatement.processDeclarations(processor, state, lastParent, place)) continue;
            return false;
        }
        String className = GroovyFileImpl.getWantedClassName(processor, state);
        if (className != null && !(maybeImplicit = this.getImplicitlyImportableClasses(facade, className)).isEmpty() && GroovyFileImpl.isResolvableViaImplictImports(processor, state, lastParent, place, className, maybeImplicit, imports) && !this.processImplicitImports(processor, state, lastParent, place, facade)) {
            return false;
        }
        for (GrImportStatement importStatement : imports) {
            if (importStatement.isAliasedImport() || importStatement.processDeclarations(processor, state, lastParent, place)) continue;
            return false;
        }
        if (!this.processImplicitImports(processor, state, lastParent, place, facade)) {
            return false;
        }
        if (StringUtil.isNotEmpty((String)this.getPackageName()) && (defaultPackage = facade.findPackage("")) != null) {
            for (PsiPackage subpackage : defaultPackage.getSubPackages(this.getResolveScope())) {
                if (ResolveUtil.processElement(processor, (PsiNamedElement)subpackage)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isResolvableViaImplictImports(final PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place, final @NotNull String className, final Set<String> maybeImplicit, GrImportStatement[] imports) {
        if (className == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileImpl.isResolvableViaImplictImports must not be null");
        }
        boolean isImplicitlyImported = true;
        for (GrImportStatement importStatement : imports) {
            if (importStatement.processDeclarations((PsiScopeProcessor)new BaseScopeProcessor(){

                public boolean execute(PsiElement element, ResolveState state) {
                    PsiClass psiClass;
                    String qname;
                    return !(element instanceof PsiClass) || (qname = (psiClass = (PsiClass)element).getQualifiedName()) == null || !className.equals(psiClass.getName()) || maybeImplicit.contains(qname);
                }

                public <T> T getHint(Key<T> hintKey) {
                    return (T)processor.getHint(hintKey);
                }
            }, state, lastParent, place)) continue;
            isImplicitlyImported = false;
            break;
        }
        return isImplicitlyImported;
    }

    private Set<String> getImplicitlyImportableClasses(JavaPsiFacade facade, @NotNull String className) {
        String candidate;
        if (className == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileImpl.getImplicitlyImportableClasses must not be null");
        }
        THashSet maybeImplicit = new THashSet();
        String suffix = "." + className;
        for (String implicitlyImportedClass : IMPLICITLY_IMPORTED_CLASSES) {
            if (!implicitlyImportedClass.endsWith(suffix)) continue;
            maybeImplicit.add(implicitlyImportedClass);
        }
        for (String implicitlyImported : this.getImplicitlyImportedPackages()) {
            String candidate2 = implicitlyImported + suffix;
            if (facade.findClass(candidate2, this.getResolveScope()) == null) continue;
            maybeImplicit.add(candidate2);
        }
        String pkg = this.getPackageName();
        String string = candidate = StringUtil.isEmpty((String)pkg) ? className : pkg + suffix;
        if (facade.findClass(candidate, this.getResolveScope()) != null) {
            maybeImplicit.add(candidate);
        }
        return maybeImplicit;
    }

    private List<String> getImplicitlyImportedPackages() {
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(IMPLICITLY_IMPORTED_PACKAGES));
        if (this.isScript()) {
            result.addAll(GroovyScriptType.getScriptType(this).appendImplicitImports(this));
        }
        return result;
    }

    private boolean processImplicitImports(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place, JavaPsiFacade facade) {
        String currentPackageName = this.getPackageName();
        PsiPackage currentPackage = facade.findPackage(currentPackageName);
        if (currentPackage != null && !currentPackage.processDeclarations(processor, state, lastParent, place)) {
            return false;
        }
        for (String implicitlyImported : this.getImplicitlyImportedPackages()) {
            PsiPackage aPackage = facade.findPackage(implicitlyImported);
            if (aPackage == null || aPackage.processDeclarations(processor, state, lastParent, place)) continue;
            return false;
        }
        for (String implicitlyImportedClass : IMPLICITLY_IMPORTED_CLASSES) {
            PsiClass clazz = facade.findClass(implicitlyImportedClass, this.getResolveScope());
            if (clazz == null || ResolveUtil.processElement(processor, (PsiNamedElement)clazz)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static String getWantedClassName(PsiScopeProcessor processor, ResolveState state) {
        ClassHint hint = (ClassHint)processor.getHint(ClassHint.KEY);
        NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
        if (hint != null && hint.shouldProcess(ClassHint.ResolveKind.CLASS) && nameHint != null) {
            return nameHint.getName(state);
        }
        return null;
    }

    private static boolean processChildrenScopes(PsiElement element, PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        PsiElement run;
        PsiElement psiElement = run = lastParent == null ? element.getLastChild() : lastParent.getPrevSibling();
        while (run != null) {
            if (!(run instanceof GrTopLevelDefintion || run instanceof GrImportStatement || run.processDeclarations(processor, state, null, place))) {
                return false;
            }
            run = run.getPrevSibling();
        }
        return true;
    }

    @Override
    public GrImportStatement[] getImportStatements() {
        return (GrImportStatement[])this.findChildrenByClass(GrImportStatement.class);
    }

    @Nullable
    public Icon getIcon(int flags) {
        if (this.isScript()) {
            return GroovyScriptType.getScriptType(this).getScriptIcon();
        }
        return GroovyIcons.GROOVY_ICON_16x16;
    }

    @Override
    public GrImportStatement addImportForClass(PsiClass aClass) {
        try {
            Project project = aClass.getProject();
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
            GrImportStatement importStatement = factory.createImportStatementFromText(aClass.getQualifiedName(), false, false, null);
            PsiElement anchor = this.getAnchorToInsertImportAfter();
            return (GrImportStatement)this.addAfter(importStatement, anchor);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @Nullable
    private PsiElement getAnchorToInsertImportAfter() {
        GrImportStatement[] importStatements = this.getImportStatements();
        if (importStatements.length > 0) {
            return importStatements[importStatements.length - 1];
        }
        if (this.getPackageDefinition() != null) {
            return this.getPackageDefinition();
        }
        return null;
    }

    @Override
    public GrImportStatement addImport(GrImportStatement statement) throws IncorrectOperationException {
        ASTNode node;
        GrImportStatement importStatement;
        PsiElement next;
        PsiElement anchor = this.getAnchorToInsertImportAfter();
        PsiElement result = this.addAfter(statement, anchor);
        boolean isAliasedImport = false;
        if (anchor instanceof GrImportStatement) {
            boolean bl = isAliasedImport = !((GrImportStatement)anchor).isAliasedImport() && statement.isAliasedImport() || ((GrImportStatement)anchor).isAliasedImport() && !statement.isAliasedImport();
        }
        if (anchor != null) {
            PsiElement prev;
            int lineFeedCount = 0;
            if (!(anchor instanceof GrImportStatement) || isAliasedImport) {
                ++lineFeedCount;
            }
            if ((prev = result.getPrevSibling()) instanceof PsiWhiteSpace) {
                lineFeedCount += StringUtil.getOccurenceCount((String)prev.getText(), (char)'\n');
            }
            if (lineFeedCount > 0) {
                this.getNode().addLeaf(GroovyTokenTypes.mNLS, (CharSequence)StringUtil.repeatSymbol((char)'\n', (int)lineFeedCount), result.getNode());
            }
            if (prev instanceof PsiWhiteSpace) {
                prev.delete();
            }
        }
        if ((next = (importStatement = (GrImportStatement)result).getNextSibling()) != null && (node = next.getNode()) != null && GroovyTokenTypes.mNLS == node.getElementType()) {
            next.replace(GroovyPsiElementFactory.getInstance(statement.getProject()).createLineTerminator(2));
        }
        return importStatement;
    }

    @Override
    public boolean isScript() {
        StubElement stub = this.getStub();
        if (stub instanceof GrFileStub) {
            return ((GrFileStub)stub).isScript();
        }
        Boolean isScript = this.myScript;
        if (isScript == null) {
            isScript = Boolean.FALSE;
            for (GrTopStatement st : (GrTopStatement[])this.findChildrenByClass(GrTopStatement.class)) {
                if (st instanceof GrTypeDefinition || st instanceof GrImportStatement || st instanceof GrPackageDefinition) continue;
                isScript = Boolean.TRUE;
                break;
            }
            this.myScript = isScript;
        }
        return isScript;
    }

    public void subtreeChanged() {
        this.myScript = null;
        super.subtreeChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GroovyScriptClass getScriptClass() {
        if (this.isScript()) {
            if (this.myScriptClass == null) {
                GroovyScriptClass candidate = new GroovyScriptClass(this);
                Object object = lock;
                synchronized (object) {
                    if (this.myScriptClass == null) {
                        this.myScriptClass = candidate;
                    }
                }
            }
            return this.myScriptClass;
        }
        return null;
    }

    @Override
    public void setPackageName(String packageName) {
        ASTNode fileNode = this.getNode();
        assert (fileNode != null);
        GrPackageDefinition currentPackage = this.getPackageDefinition();
        if (packageName == null || packageName.length() == 0) {
            if (currentPackage != null) {
                ASTNode currNode = currentPackage.getNode();
                assert (currNode != null);
                fileNode.removeChild(currNode);
            }
            return;
        }
        GrTopStatement newPackage = GroovyPsiElementFactory.getInstance(this.getProject()).createTopElementFromText("package " + packageName);
        ASTNode newNode = newPackage.getNode();
        if (currentPackage != null) {
            ASTNode currNode = currentPackage.getNode();
            assert (currNode != null);
            fileNode.replaceChild(currNode, newNode);
        } else {
            ASTNode anchor = fileNode.getFirstChildNode();
            fileNode.addChild(newNode, anchor);
            fileNode.addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n", anchor);
        }
    }

    @Override
    public <T extends GrMembersDeclaration> T addMemberDeclaration(@NotNull T decl, PsiElement anchorBefore) throws IncorrectOperationException {
        if (decl == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileImpl.addMemberDeclaration must not be null");
        }
        GrMembersDeclaration result = (GrMembersDeclaration)this.addBefore(decl, anchorBefore);
        CodeStyleManager styleManager = this.getManager().getCodeStyleManager();
        PsiFile parent = result.getContainingFile();
        TextRange range = result.getTextRange();
        styleManager.reformatRange((PsiElement)parent, range.getEndOffset() - 1, range.getEndOffset() + 1);
        styleManager.reformatRange((PsiElement)parent, range.getStartOffset() - 1, range.getStartOffset() + 1);
        return (T)result;
    }

    @Override
    public void removeMemberDeclaration(GrMembersDeclaration decl) {
        try {
            this.deleteChildRange(decl, decl);
        }
        catch (IncorrectOperationException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCaches() {
        super.clearCaches();
        Object object = lock;
        synchronized (object) {
            this.mySyntheticArgsParameter = null;
        }
    }

    public PsiElement getContext() {
        if (this.myContext != null) {
            return this.myContext;
        }
        return super.getContext();
    }

    protected GroovyFileImpl clone() {
        GroovyFileImpl clone = (GroovyFileImpl)super.clone();
        clone.myContext = this.myContext;
        return clone;
    }

    public void setContext(PsiElement context) {
        if (context != null) {
            this.myContext = context;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiClass[] getClasses() {
        PsiClass[] psiClassArray;
        PsiClass[] declaredDefs = super.getClasses();
        if (!this.isScript()) {
            psiClassArray = declaredDefs;
            if (declaredDefs == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileImpl.getClasses must not return null");
            return psiClassArray;
        }
        GroovyScriptClass scriptClass = this.getScriptClass();
        PsiClass[] result = new PsiClass[declaredDefs.length + 1];
        result[0] = scriptClass;
        System.arraycopy(declaredDefs, 0, result, 1, declaredDefs.length);
        psiClassArray = result;
        if (result != null) return psiClassArray;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/GroovyFileImpl.getClasses must not return null");
    }

    public PsiElement getOriginalElement() {
        PsiElement originalElement;
        GroovyScriptClass scriptClass = this.getScriptClass();
        if (scriptClass != null && (originalElement = scriptClass.getOriginalElement()) != scriptClass) {
            return originalElement.getContainingFile();
        }
        return this;
    }

    public GlobalSearchScope getFileResolveScope() {
        VirtualFile vFile = this.getOriginalFile().getVirtualFile();
        if (vFile == null) {
            return GlobalSearchScope.allScope((Project)this.getProject());
        }
        GlobalSearchScope baseScope = ((FileManagerImpl)((PsiManagerEx)this.getManager()).getFileManager()).getDefaultResolveScope(vFile);
        if (this.isScript()) {
            return (GlobalSearchScope)((CachedValue)RESOLVE_SCOPE_CACHE.get((UserDataHolder)this, (Object)baseScope)).getValue();
        }
        return baseScope;
    }
}

