/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.groovydoc.lexer.GroovyDocTokenTypes;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocCommentOwner;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocParameterReference;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocTagValueToken;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GrDocCommentUtil;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GroovyDocPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameterListOwner;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;

public class GrDocParameterReferenceImpl
extends GroovyDocPsiElementImpl
implements GrDocParameterReference {
    public GrDocParameterReferenceImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/groovydoc/psi/impl/GrDocParameterReferenceImpl.<init> must not be null");
        }
        super(node);
    }

    public String toString() {
        return "GrDocParameterReference";
    }

    public PsiReference getReference() {
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ASTNode node;
        ResolveResult[] resolveResultArray;
        String name = this.getName();
        if (name == null) {
            resolveResultArray = ResolveResult.EMPTY_ARRAY;
            if (ResolveResult.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/groovydoc/psi/impl/GrDocParameterReferenceImpl.multiResolve must not return null");
            return resolveResultArray;
        }
        ArrayList<GroovyResolveResultImpl> candidates = new ArrayList<GroovyResolveResultImpl>();
        GrDocCommentOwner owner = GrDocCommentUtil.findDocOwner(this);
        if (owner instanceof GrMethod) {
            GrParameter[] parameters;
            GrMethod method = (GrMethod)owner;
            for (GrParameter parameter : parameters = method.getParameters()) {
                if (!name.equals(parameter.getName())) continue;
                candidates.add(new GroovyResolveResultImpl(parameter, true));
            }
            resolveResultArray = candidates.toArray(new ResolveResult[candidates.size()]);
            if (resolveResultArray == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/groovydoc/psi/impl/GrDocParameterReferenceImpl.multiResolve must not return null");
            return resolveResultArray;
        }
        PsiElement firstChild = this.getFirstChild();
        if (owner instanceof GrTypeParameterListOwner && firstChild != null && (node = firstChild.getNode()) != null && GroovyDocTokenTypes.mGDOC_TAG_VALUE_LT.equals(node.getElementType())) {
            PsiTypeParameter[] typeParameters;
            for (PsiTypeParameter typeParameter : typeParameters = ((PsiTypeParameterListOwner)owner).getTypeParameters()) {
                if (!name.equals(typeParameter.getName())) continue;
                candidates.add(new GroovyResolveResultImpl((PsiElement)typeParameter, true));
            }
        }
        resolveResultArray = ResolveResult.EMPTY_ARRAY;
        if (ResolveResult.EMPTY_ARRAY != null) return resolveResultArray;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/groovydoc/psi/impl/GrDocParameterReferenceImpl.multiResolve must not return null");
    }

    public PsiElement getElement() {
        return this;
    }

    public TextRange getRangeInElement() {
        return new TextRange(0, this.getTextLength());
    }

    public String getName() {
        return this.getReferenceNameElement().getText();
    }

    @Nullable
    public PsiElement resolve() {
        ResolveResult[] results = this.multiResolve(false);
        if (results.length != 1) {
            return null;
        }
        return results[0].getElement();
    }

    public String getCanonicalText() {
        return this.getName();
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        GrDocTagValueToken nameElement = this.getReferenceNameElement();
        ASTNode node = nameElement.getNode();
        ASTNode newNameNode = GroovyPsiElementFactory.getInstance(this.getProject()).createDocMemberReferenceNameFromText(newElementName).getNode();
        assert (newNameNode != null && node != null);
        node.getTreeParent().replaceChild(node, newNameNode);
        return this;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/groovydoc/psi/impl/GrDocParameterReferenceImpl.bindToElement must not be null");
        }
        if (this.isReferenceTo(element)) {
            return this;
        }
        return null;
    }

    public boolean isReferenceTo(PsiElement element) {
        if (!(element instanceof GrParameter) && !(element instanceof GrTypeParameter)) {
            return false;
        }
        return this.getManager().areElementsEquivalent(element, this.resolve());
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Object[] getVariants() {
        Object[] objectArray;
        ASTNode node;
        GrDocCommentOwner owner = GrDocCommentUtil.findDocOwner(this);
        PsiElement firstChild = this.getFirstChild();
        if (owner instanceof GrTypeParameterListOwner && firstChild != null && (node = firstChild.getNode()) != null && GroovyDocTokenTypes.mGDOC_TAG_VALUE_LT.equals(node.getElementType())) {
            objectArray = ((PsiTypeParameterListOwner)owner).getTypeParameters();
            if (objectArray == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/groovydoc/psi/impl/GrDocParameterReferenceImpl.getVariants must not return null");
            return objectArray;
        }
        if (owner instanceof PsiMethod) {
            objectArray = ((PsiMethod)owner).getParameterList().getParameters();
            if (objectArray == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/groovydoc/psi/impl/GrDocParameterReferenceImpl.getVariants must not return null");
            return objectArray;
        }
        objectArray = ArrayUtil.EMPTY_OBJECT_ARRAY;
        if (ArrayUtil.EMPTY_OBJECT_ARRAY != null) return objectArray;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/groovydoc/psi/impl/GrDocParameterReferenceImpl.getVariants must not return null");
    }

    public boolean isSoft() {
        return false;
    }

    @Override
    @NotNull
    public GrDocTagValueToken getReferenceNameElement() {
        GrDocTagValueToken token = (GrDocTagValueToken)this.findChildByClass(GrDocTagValueToken.class);
        assert (token != null);
        GrDocTagValueToken grDocTagValueToken = token;
        if (grDocTagValueToken == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/groovydoc/psi/impl/GrDocParameterReferenceImpl.getReferenceNameElement must not return null");
        }
        return grDocTagValueToken;
    }
}

