/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion.filters.toplevel;

import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.ElementFilter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionUtil;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public class ClassInterfaceEnumFilter
implements ElementFilter,
GroovyElementTypes {
    public boolean isAcceptable(Object element, PsiElement context) {
        if (context.getParent() != null && context.getParent() instanceof GrReferenceExpression && context.getParent().getParent() instanceof GroovyFile) {
            return true;
        }
        if (context.getParent() != null && context.getParent() instanceof GrReferenceExpression && (context.getParent().getParent() instanceof GrApplicationStatement || context.getParent().getParent() instanceof GrCall) && context.getParent().getParent().getParent() instanceof GroovyFile) {
            return true;
        }
        PsiElement leaf = GroovyCompletionUtil.getLeafByOffset(context.getTextRange().getStartOffset() - 1, context);
        if (leaf != null) {
            PsiElement prev = leaf;
            if ((prev = PsiImplUtil.realPrevious(prev)) instanceof GrModifierList && prev.getParent() != null && prev.getParent().getParent() instanceof GroovyFile) {
                return true;
            }
            PsiElement parent = leaf.getParent();
            if (parent instanceof GroovyFile) {
                return GroovyCompletionUtil.isNewStatement(context, false);
            }
        }
        return false;
    }

    public boolean isClassAcceptable(Class hintClass) {
        return true;
    }

    @NonNls
    public String toString() {
        return "'class', 'interface', 'enum' keywords filter";
    }
}

