/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gant;

import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.execution.Location;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.NonClasspathDirectoryScope;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptType;
import org.jetbrains.plugins.groovy.gant.GantIcons;
import org.jetbrains.plugins.groovy.gant.GantRunner;
import org.jetbrains.plugins.groovy.gant.GantSettings;
import org.jetbrains.plugins.groovy.gant.GantUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunConfiguration;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunner;

public class GantScriptType
extends GroovyScriptType {
    @NonNls
    public static final String DEFAULT_EXTENSION = "gant";

    @Override
    public boolean isSpecificScriptFile(GroovyFile file) {
        return GantUtils.isGantScriptFile(file);
    }

    @Override
    @NotNull
    public Icon getScriptIcon() {
        Icon icon = GantIcons.GANT_ICON_16x16;
        if (icon == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/gant/GantScriptType.getScriptIcon must not return null");
        }
        return icon;
    }

    @Override
    public GroovyScriptRunner getRunner() {
        return new GantRunner();
    }

    @Override
    public void tuneConfiguration(@NotNull GroovyFile file, @NotNull GroovyScriptRunConfiguration configuration, Location location) {
        CompileStepBeforeRun.MakeBeforeRunTask runTask;
        String target;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/gant/GantScriptType.tuneConfiguration must not be null");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/gant/GantScriptType.tuneConfiguration must not be null");
        }
        PsiElement element = location.getPsiElement();
        PsiElement pp = element.getParent();
        PsiElement parent = element;
        while (!(pp instanceof PsiFile) && pp != null) {
            pp = pp.getParent();
            parent = parent.getParent();
        }
        if (pp != null && parent instanceof GrMethodCallExpression && PsiUtil.isMethodCall((GrMethodCallExpression)parent, "target") && (target = GantScriptType.getFoundTargetName((GrMethodCallExpression)parent)) != null) {
            configuration.scriptParams = target;
            configuration.setName(configuration.getName() + "." + target);
        }
        if ((runTask = (CompileStepBeforeRun.MakeBeforeRunTask)RunManagerEx.getInstanceEx((Project)element.getProject()).getBeforeRunTask((RunConfiguration)configuration, CompileStepBeforeRun.ID)) != null) {
            runTask.setEnabled(false);
        }
    }

    @Nullable
    private static String getFoundTargetName(GrMethodCallExpression call) {
        GrArgumentLabel label;
        GrNamedArgument[] args = call.getNamedArguments();
        if (args.length == 1 && (label = args[0].getLabel()) != null && GantUtils.isPlainIdentifier(label)) {
            return label.getName();
        }
        return null;
    }

    @Override
    public GlobalSearchScope patchResolveScope(@NotNull GroovyFile file, @NotNull GlobalSearchScope baseScope) {
        String sdkHome;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/gant/GantScriptType.patchResolveScope must not be null");
        }
        if (baseScope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/gant/GantScriptType.patchResolveScope must not be null");
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)file);
        if (module != null && (sdkHome = GantUtils.getSdkHomeFromClasspath(module)) != null) {
            return baseScope;
        }
        GantSettings gantSettings = GantSettings.getInstance(file.getProject());
        VirtualFile home = gantSettings.getSdkHome();
        if (home == null) {
            return baseScope;
        }
        List<VirtualFile> files = gantSettings.getClassRoots();
        if (files.isEmpty()) {
            return baseScope;
        }
        GlobalSearchScope result = baseScope;
        for (VirtualFile root : files) {
            result = result.uniteWith((GlobalSearchScope)new NonClasspathDirectoryScope(root));
        }
        return result;
    }
}

