/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.formatter.processors;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.groovydoc.lexer.GroovyDocTokenTypes;
import org.jetbrains.plugins.groovy.lang.groovydoc.parser.GroovyDocElementTypes;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMemberReference;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;

public abstract class SpacingUtil {
    static TokenSet COMMENT_BIT_SET = GroovyTokenTypes.COMMENT_SET;

    static boolean isWhiteSpace(ASTNode treePrev) {
        return treePrev != null && (treePrev.getPsi() instanceof PsiWhiteSpace || treePrev.getTextLength() == 0);
    }

    static boolean canStickChildrenTogether(ASTNode child1, ASTNode child2) {
        if (child1 == null || child2 == null || SpacingUtil.isWhiteSpace(child1) || SpacingUtil.isWhiteSpace(child2)) {
            return true;
        }
        return child1 instanceof LeafPsiElement || child2 instanceof LeafPsiElement;
    }

    static boolean shouldKeepSpace(@NotNull PsiElement parent) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/formatter/processors/SpacingUtil.shouldKeepSpace must not be null");
        }
        ASTNode node = parent.getNode();
        if (node == null) {
            return true;
        }
        IElementType type = node.getElementType();
        if (type == GroovyDocTokenTypes.mGDOC_TAG_VALUE_TOKEN) {
            return PsiTreeUtil.getParentOfType((PsiElement)parent, GrDocMemberReference.class) != null;
        }
        return type == GroovyTokenTypes.GROOVY_DOC_COMMENT || type == GroovyDocElementTypes.GDOC_TAG || type == GroovyDocElementTypes.GDOC_INLINED_TAG;
    }

    static ASTNode getLeafNonSpaceBefore(ASTNode element) {
        if (element == null) {
            return null;
        }
        ASTNode treePrev = element.getTreePrev();
        if (treePrev != null) {
            ASTNode candidate = SpacingUtil.getLastChildOf(treePrev);
            if (candidate != null && !SpacingUtil.isWhiteSpace(candidate) && candidate.getTextLength() > 0) {
                return candidate;
            }
            return SpacingUtil.getLeafNonSpaceBefore(candidate);
        }
        ASTNode treeParent = element.getTreeParent();
        if (treeParent == null || treeParent.getTreeParent() == null) {
            return null;
        }
        return SpacingUtil.getLeafNonSpaceBefore(treeParent);
    }

    private static ASTNode getLastChildOf(ASTNode element) {
        if (element == null) {
            return null;
        }
        if (element instanceof LeafElement) {
            return element;
        }
        ASTNode lastChild = element.getLastChildNode();
        if (lastChild == null) {
            return element;
        }
        return SpacingUtil.getLastChildOf(lastChild);
    }

    static ASTNode getPrevElementType(ASTNode child) {
        return FormatterUtil.getLeafNonSpaceBefore((ASTNode)child);
    }
}

