/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config;

import com.intellij.ide.util.frameworkSupport.FrameworkSupportConfigurable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.AbstractGroovyLibraryManager;
import org.jetbrains.plugins.groovy.config.ui.GroovyFacetEditor;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public class GroovySupportConfigurable
extends FrameworkSupportConfigurable {
    private final GroovyFacetEditor facetEditor;

    public GroovySupportConfigurable(GroovyFacetEditor facetEditor) {
        this.facetEditor = facetEditor;
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.facetEditor.getComponent();
        if (jComponent == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/config/GroovySupportConfigurable.getComponent must not return null");
        }
        return jComponent;
    }

    public void addSupport(@NotNull Module module, @NotNull ModifiableRootModel rootModel, @Nullable Library library) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/config/GroovySupportConfigurable.addSupport must not be null");
        }
        if (rootModel == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/config/GroovySupportConfigurable.addSupport must not be null");
        }
        this.addGroovySupport(module, rootModel);
    }

    public void addGroovySupport(final Module module, ModifiableRootModel rootModel) {
        if (!this.facetEditor.addNewSdk()) {
            Library selectedLibrary = this.facetEditor.getSelectedLibrary();
            if (selectedLibrary != null) {
                LibrariesUtil.placeEntryToCorrectPlace(rootModel, rootModel.addLibraryEntry(selectedLibrary));
            }
            return;
        }
        final String path = this.facetEditor.getNewSdkPath();
        final AbstractGroovyLibraryManager libraryManager = this.facetEditor.getChosenManager();
        if (path != null && libraryManager != null) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (module.isDisposed()) {
                        return;
                    }
                    final Library lib = libraryManager.createLibrary(path, LibrariesContainerFactory.createContainer((Module)module), false);
                    if (lib != null) {
                        ApplicationManager.getApplication().runWriteAction(new Runnable(){

                            @Override
                            public void run() {
                                ModifiableRootModel rootModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
                                LibrariesUtil.placeEntryToCorrectPlace(rootModel, rootModel.addLibraryEntry(lib));
                                rootModel.commit();
                            }
                        });
                    }
                }
            });
        }
    }
}

