/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.compiler.generator;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.TimestampValidityState;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.compiler.options.ExcludedEntriesConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.HashSet;
import gnu.trove.THashSet;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.compiler.GroovyCompilerConfiguration;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnnotationTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrInterfaceDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrConstructor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMembersDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.GrTopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrSyntheticMethodImplementation;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.util.GroovyUtils;
import org.jetbrains.plugins.groovy.util.containers.CharTrie;

public class GroovyToJavaGenerator {
    private static final Map<String, String> typesToInitialValues = new HashMap<String, String>();
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.compiler.generator.GroovyToJavaGenerator");
    private static final String[] JAVA_MODIFIERS;
    private static final CharSequence PREFIX_SEPARATOR;
    private final CompileContext myContext;
    private final Project myProject;
    CharTrie myTrie = new CharTrie();

    public GroovyToJavaGenerator(Project project, CompileContext context) {
        this.myProject = project;
        this.myContext = context;
    }

    public GenerationItem[] getGenerationItems(CompileContext context) {
        if (GroovyCompilerConfiguration.getInstance(this.myProject).isUseGroovycStubs()) {
            return new GenerationItem[0];
        }
        ArrayList<GenerationItem> generationItems = new ArrayList<GenerationItem>();
        CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
        CompilerConfiguration compilerConfiguration = CompilerConfiguration.getInstance((Project)this.myProject);
        ExcludedEntriesConfiguration excluded = GroovyCompilerConfiguration.getExcludeConfiguration(this.myProject);
        for (VirtualFile file : this.getGroovyFilesToGenerate(context)) {
            GrTypeDefinition[] typeDefinitions;
            Module module;
            if (compilerManager.isExcludedFromCompilation(file) || excluded.isExcluded(file) || compilerConfiguration.isResourceFile(file) || !GroovyUtils.isSuitableModule(module = this.getModuleByFile(context, file))) continue;
            final GroovyFile psiFile = this.findPsiFile(file);
            GrTopStatement[] statements = GroovyToJavaGenerator.getTopStatementsInReadAction(psiFile);
            boolean needCreateTopLevelClass = !GroovyToJavaGenerator.needsCreateClassFromFileName(statements);
            String prefix = "";
            if (statements.length > 0 && statements[0] instanceof GrPackageDefinition) {
                prefix = GroovyToJavaGenerator.getJavaClassPackage((GrPackageDefinition)statements[0]);
            }
            if (needCreateTopLevelClass) {
                generationItems.add(new GenerationItem(prefix + file.getNameWithoutExtension() + "." + "java", module, (ValidityState)new TimestampValidityState(file.getTimeStamp()), file));
            }
            for (GrTypeDefinition typeDefinition : typeDefinitions = (GrTypeDefinition[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<GrTypeDefinition[]>(){

                public GrTypeDefinition[] compute() {
                    return psiFile.getTypeDefinitions();
                }
            })) {
                GenerationItem item = new GenerationItem(prefix + typeDefinition.getName() + "." + "java", module, (ValidityState)new TimestampValidityState(file.getTimeStamp()), file);
                generationItems.add(item);
            }
        }
        return generationItems.toArray(new GenerationItem[generationItems.size()]);
    }

    protected Module getModuleByFile(CompileContext context, VirtualFile file) {
        return context.getModuleByFile(file);
    }

    protected VirtualFile[] getGroovyFilesToGenerate(final CompileContext context) {
        final HashSet set = new HashSet();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                set.addAll(Arrays.asList(context.getProjectCompileScope().getFiles((FileType)GroovyFileType.GROOVY_FILE_TYPE, true)));
            }
        });
        return VfsUtil.toVirtualFileArray((Collection)set);
    }

    public GenerationItem[] generate(GenerationItem[] itemsToGenerate, VirtualFile outputRootDirectory) {
        ArrayList<GenerationItem> generatedItems = new ArrayList<GenerationItem>();
        HashMap<String, GenerationItem> pathsToItemsMap = new HashMap<String, GenerationItem>();
        for (GenerationItem item : itemsToGenerate) {
            pathsToItemsMap.put(item.getPath(), item);
        }
        HashSet vFiles = new HashSet();
        for (GenerationItem item : itemsToGenerate) {
            vFiles.add(item.getVFile());
        }
        for (VirtualFile vFile : vFiles) {
            List<String> generatedJavaFilesRelPaths = this.generateItems(vFile, outputRootDirectory);
            for (String relPath : generatedJavaFilesRelPaths) {
                GenerationItem generationItem = (GenerationItem)pathsToItemsMap.get(relPath);
                if (generationItem == null) continue;
                generatedItems.add(generationItem);
            }
        }
        return generatedItems.toArray(new GenerationItem[generatedItems.size()]);
    }

    private GroovyFile findPsiFile(final VirtualFile virtualFile) {
        final GroovyFile[] myFindPsiFile = new GroovyFile[1];
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                myFindPsiFile[0] = (GroovyFile)PsiManager.getInstance((Project)GroovyToJavaGenerator.this.myProject).findFile(virtualFile);
            }
        });
        assert (myFindPsiFile[0] != null);
        return myFindPsiFile[0];
    }

    public List<String> generateItems(VirtualFile item, final VirtualFile outputRootDirectory) {
        ProgressIndicator indicator = this.getProcessIndicator();
        if (indicator != null) {
            indicator.setText("Generating stubs for " + item.getName() + "...");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Generating stubs for " + item.getName() + "...");
        }
        final GroovyFile file = this.findPsiFile(item);
        List generatedJavaFilesRelPaths = (List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<String>>(){

            public List<String> compute() {
                return GroovyToJavaGenerator.this.generate(file, outputRootDirectory);
            }
        });
        assert (generatedJavaFilesRelPaths != null);
        return generatedJavaFilesRelPaths;
    }

    protected ProgressIndicator getProcessIndicator() {
        return this.myContext.getProgressIndicator();
    }

    private List<String> generate(GroovyFile file, VirtualFile outputRootDirectory) {
        ArrayList<String> generatedItemsRelativePaths = new ArrayList<String>();
        GrTopStatement[] statements = GroovyToJavaGenerator.getTopStatementsInReadAction(file);
        GrPackageDefinition packageDefinition = null;
        if (statements.length > 0 && statements[0] instanceof GrPackageDefinition) {
            packageDefinition = (GrPackageDefinition)statements[0];
        }
        THashSet classNames = new THashSet();
        for (GrTypeDefinition typeDefinition : file.getTypeDefinitions()) {
            classNames.add(typeDefinition.getName());
        }
        if (file.isScript()) {
            PsiClass scriptClass;
            VirtualFile virtualFile = file.getVirtualFile();
            assert (virtualFile != null);
            String fileDefinitionName = virtualFile.getNameWithoutExtension();
            if (!classNames.contains(StringUtil.capitalize((String)fileDefinitionName)) && !classNames.contains(StringUtil.decapitalize((String)fileDefinitionName)) && (scriptClass = file.getScriptClass()) != null) {
                generatedItemsRelativePaths.add(this.createJavaSourceFile(outputRootDirectory, scriptClass, packageDefinition));
            }
        }
        for (GrTypeDefinition typeDefinition : file.getTypeDefinitions()) {
            generatedItemsRelativePaths.add(this.createJavaSourceFile(outputRootDirectory, typeDefinition, packageDefinition));
        }
        return generatedItemsRelativePaths;
    }

    private static String getJavaClassPackage(@Nullable GrPackageDefinition packageDefinition) {
        if (packageDefinition == null) {
            return "";
        }
        String prefix = packageDefinition.getPackageName();
        prefix = prefix.replace(".", PREFIX_SEPARATOR);
        prefix = prefix + PREFIX_SEPARATOR;
        return prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createJavaSourceFile(VirtualFile outputRootDirectory, @NotNull PsiClass typeDefinition, GrPackageDefinition packageDefinition) {
        if (typeDefinition == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/compiler/generator/GroovyToJavaGenerator.createJavaSourceFile must not be null");
        }
        StringBuffer text = new StringBuffer();
        this.writeTypeDefinition(text, typeDefinition, packageDefinition, true);
        String prefix = GroovyToJavaGenerator.getJavaClassPackage(packageDefinition);
        String outputDir = outputRootDirectory.getPath();
        String fileName = typeDefinition.getName() + "." + "java";
        String prefixWithoutSeparator = prefix;
        if (!"".equals(prefix)) {
            prefixWithoutSeparator = prefix.substring(0, prefix.length() - PREFIX_SEPARATOR.length());
            new File(outputDir, prefixWithoutSeparator).mkdirs();
        }
        File myFile = !"".equals(prefix) ? new File(outputDir + File.separator + prefixWithoutSeparator, fileName) : new File(outputDir, fileName);
        BufferedWriter writer = null;
        try {
            FileWriter fileWriter = new FileWriter(myFile);
            writer = new BufferedWriter(fileWriter);
            writer.write(text.toString());
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        finally {
            try {
                assert (writer != null);
                writer.close();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        return prefix + fileName;
    }

    private static GrTopStatement[] getTopStatementsInReadAction(final GroovyFileBase myPsiFile) {
        if (myPsiFile == null) {
            return new GrTopStatement[0];
        }
        return (GrTopStatement[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<GrTopStatement[]>(){

            public GrTopStatement[] compute() {
                return myPsiFile.getTopStatements();
            }
        });
    }

    private static boolean needsCreateClassFromFileName(GrTopStatement[] statements) {
        boolean isOnlyInnerTypeDef = true;
        for (GrTopStatement statement : statements) {
            if (statement instanceof GrTypeDefinition || statement instanceof GrImportStatement || statement instanceof GrPackageDefinition) continue;
            isOnlyInnerTypeDef = false;
            break;
        }
        return isOnlyInnerTypeDef;
    }

    /*
     * WARNING - void declaration
     */
    private void writeTypeDefinition(StringBuffer text, @NotNull PsiClass typeDefinition, @Nullable GrPackageDefinition packageDefinition, boolean toplevel) {
        if (typeDefinition == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/compiler/generator/GroovyToJavaGenerator.writeTypeDefinition must not be null");
        }
        boolean isScript = typeDefinition instanceof GroovyScriptClass;
        GroovyToJavaGenerator.writePackageStatement(text, packageDefinition);
        GrMembersDeclaration[] membersDeclarations = typeDefinition instanceof GrTypeDefinition ? ((GrTypeDefinition)typeDefinition).getMemberDeclarations() : GrMembersDeclaration.EMPTY_ARRAY;
        boolean isClassDef = typeDefinition instanceof GrClassDefinition;
        boolean isInterface = typeDefinition instanceof GrInterfaceDefinition;
        boolean isEnum = typeDefinition instanceof GrEnumTypeDefinition;
        boolean isAtInterface = typeDefinition instanceof GrAnnotationTypeDefinition;
        GroovyToJavaGenerator.writeClassModifiers(text, typeDefinition.getModifierList(), typeDefinition.isInterface(), toplevel);
        if (isInterface) {
            text.append("interface");
        } else if (isEnum) {
            text.append("enum");
        } else if (isAtInterface) {
            text.append("@interface");
        } else {
            text.append("class");
        }
        text.append(" ").append(typeDefinition.getName());
        GroovyToJavaGenerator.appendTypeParameters(text, (PsiTypeParameterListOwner)typeDefinition);
        text.append(" ");
        if (isScript) {
            text.append("extends groovy.lang.Script ");
        } else if (!isEnum && !isAtInterface) {
            PsiClassType[] implementsTypes;
            PsiClassType[] extendsClassesTypes = typeDefinition.getExtendsListTypes();
            if (extendsClassesTypes.length > 0) {
                text.append("extends ").append(GroovyToJavaGenerator.getTypeText((PsiType)extendsClassesTypes[0], (PsiElement)typeDefinition, false)).append(" ");
            }
            if ((implementsTypes = typeDefinition.getImplementsListTypes()).length > 0) {
                text.append(isInterface ? "extends " : "implements ");
                for (int i = 0; i < implementsTypes.length; ++i) {
                    if (i > 0) {
                        text.append(", ");
                    }
                    text.append(GroovyToJavaGenerator.getTypeText((PsiType)implementsTypes[i], (PsiElement)typeDefinition, false)).append(" ");
                }
            }
        }
        text.append("{");
        if (isEnum) {
            GroovyToJavaGenerator.writeEnumConstants(text, (GrEnumTypeDefinition)typeDefinition);
        }
        HashSet methodSignatures = new HashSet();
        ArrayList<PsiMethod> methods = new ArrayList<PsiMethod>();
        methods.addAll(Arrays.asList(typeDefinition.getMethods()));
        if (isClassDef) {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory();
            methods.add(factory.createMethodFromText("public groovy.lang.MetaClass getMetaClass() {}", null));
            methods.add(factory.createMethodFromText("public void setMetaClass(groovy.lang.MetaClass mc) {}", null));
            methods.add(factory.createMethodFromText("public Object invokeMethod(String name, Object args) {}", null));
            methods.add(factory.createMethodFromText("public Object getProperty(String propertyName) {}", null));
            methods.add(factory.createMethodFromText("public void setProperty(String propertyName, Object newValue) {}", null));
        }
        block1: for (PsiMethod method : methods) {
            if (method instanceof GrSyntheticMethodImplementation) continue;
            if (method instanceof GrConstructor) {
                GroovyToJavaGenerator.writeConstructor(text, (GrConstructor)method, isEnum);
                continue;
            }
            PsiParameter[] parameters = method.getParameterList().getParameters();
            if (parameters.length > 0) {
                int i;
                PsiParameter[] psiParameterArray = new PsiParameter[parameters.length];
                Object[] parameterTypes = new PsiType[parameters.length];
                for (i = 0; i < parameterTypes.length; ++i) {
                    psiParameterArray[i] = parameters[i];
                    parameterTypes[i] = parameters[i].getType();
                }
                for (i = parameters.length - 1; i >= 0; --i) {
                    PsiParameter parameter;
                    void var16_22;
                    MethodSignature signature = MethodSignatureUtil.createMethodSignature((String)method.getName(), (PsiType[])parameterTypes, (PsiTypeParameter[])method.getTypeParameters(), (PsiSubstitutor)PsiSubstitutor.EMPTY);
                    if (methodSignatures.add(signature)) {
                        GroovyToJavaGenerator.writeMethod(text, method, (PsiParameter[])var16_22);
                    }
                    if (!((parameter = parameters[i]) instanceof GrParameter) || !((GrParameter)parameter).isOptional()) continue block1;
                    parameterTypes = (PsiType[])ArrayUtil.remove((Object[])parameterTypes, (int)(parameterTypes.length - 1));
                    PsiParameter[] psiParameterArray2 = (PsiParameter[])ArrayUtil.remove((Object[])var16_22, (int)(((void)var16_22).length - 1));
                }
                continue;
            }
            MethodSignature methodSignature = method.getSignature(PsiSubstitutor.EMPTY);
            if (!methodSignatures.add(methodSignature)) continue;
            GroovyToJavaGenerator.writeMethod(text, method, parameters);
        }
        for (GrMembersDeclaration grMembersDeclaration : membersDeclarations) {
            if (!(grMembersDeclaration instanceof GrVariableDeclaration)) continue;
            GroovyToJavaGenerator.writeVariableDeclarations(text, (GrVariableDeclaration)grMembersDeclaration);
        }
        for (GrMembersDeclaration grMembersDeclaration : typeDefinition.getInnerClasses()) {
            this.writeTypeDefinition(text, (PsiClass)grMembersDeclaration, null, false);
            text.append("\n");
        }
        text.append("}");
    }

    private static void appendTypeParameters(StringBuffer text, PsiTypeParameterListOwner typeParameterListOwner) {
        if (typeParameterListOwner.hasTypeParameters()) {
            text.append("<");
            PsiTypeParameter[] parameters = typeParameterListOwner.getTypeParameters();
            for (int i = 0; i < parameters.length; ++i) {
                if (i > 0) {
                    text.append(", ");
                }
                PsiTypeParameter parameter = parameters[i];
                text.append(parameter.getName());
                PsiClassType[] extendsListTypes = parameter.getExtendsListTypes();
                if (extendsListTypes.length <= 0) continue;
                text.append(" extends ");
                for (int j = 0; j < extendsListTypes.length; ++j) {
                    if (j > 0) {
                        text.append(" & ");
                    }
                    text.append(GroovyToJavaGenerator.getTypeText((PsiType)extendsListTypes[j], (PsiElement)typeParameterListOwner, false));
                }
            }
            text.append(">");
        }
    }

    private static void writeEnumConstants(StringBuffer text, GrEnumTypeDefinition enumDefinition) {
        text.append("\n  ");
        GrEnumConstant[] enumConstants = enumDefinition.getEnumConstants();
        for (int i = 0; i < enumConstants.length; ++i) {
            GrTypeDefinitionBody block;
            if (i > 0) {
                text.append(", ");
            }
            GrEnumConstant enumConstant = enumConstants[i];
            text.append(enumConstant.getName());
            PsiMethod constructor = enumConstant.resolveConstructor();
            if (constructor != null) {
                text.append("(");
                GroovyToJavaGenerator.writeStubConstructorInvocation(text, constructor, PsiSubstitutor.EMPTY);
                text.append(")");
            }
            if ((block = enumConstant.getAnonymousBlock()) == null) continue;
            text.append("{\n");
            for (PsiMethod method : block.getMethods()) {
                GroovyToJavaGenerator.writeMethod(text, method, method.getParameterList().getParameters());
            }
            text.append("}");
        }
        text.append(";");
    }

    private static void writeStubConstructorInvocation(StringBuffer text, PsiMethod constructor, PsiSubstitutor substitutor) {
        PsiParameter[] superParams = constructor.getParameterList().getParameters();
        for (int j = 0; j < superParams.length; ++j) {
            if (j > 0) {
                text.append(", ");
            }
            String typeText = GroovyToJavaGenerator.getTypeText(substitutor.substitute(superParams[j].getType()), null, false);
            text.append("(").append(typeText).append(")").append(GroovyToJavaGenerator.getDefaultValueText(typeText));
        }
    }

    private static void writePackageStatement(StringBuffer text, GrPackageDefinition packageDefinition) {
        if (packageDefinition != null) {
            text.append("package ");
            text.append(packageDefinition.getPackageName());
            text.append(";");
            text.append("\n");
            text.append("\n");
        }
    }

    private static void writeConstructor(StringBuffer text, GrConstructor constructor, boolean isEnum) {
        GroovyResolveResult resolveResult;
        text.append("\n");
        text.append("  ");
        if (!isEnum) {
            text.append("public ");
        }
        text.append(constructor.getName());
        GrParameter[] parameterList = constructor.getParameters();
        text.append("(");
        for (int i = 0; i < parameterList.length; ++i) {
            if (i > 0) {
                text.append(", ");
            }
            GrParameter parameter = parameterList[i];
            text.append(GroovyToJavaGenerator.getTypeText(parameter.getTypeElementGroovy())).append(" ").append(parameter.getName());
        }
        text.append(") ");
        Set<String> throwsTypes = GroovyToJavaGenerator.collectThrowsTypes(constructor, (Set<PsiMethod>)new THashSet());
        if (!throwsTypes.isEmpty()) {
            text.append("throws ").append(StringUtil.join(throwsTypes, (String)", ")).append(" ");
        }
        text.append("{\n");
        GrConstructorInvocation invocation = constructor.getChainingConstructorInvocation();
        if (invocation != null && (resolveResult = GroovyToJavaGenerator.resolveChainingConstructor(constructor)) != null) {
            text.append("    ");
            text.append(invocation.isSuperCall() ? "super(" : "this(");
            GroovyToJavaGenerator.writeStubConstructorInvocation(text, (PsiMethod)resolveResult.getElement(), resolveResult.getSubstitutor());
            text.append(");");
        }
        text.append("\n  }\n");
    }

    private static Set<String> collectThrowsTypes(GrConstructor constructor, Set<PsiMethod> visited) {
        GroovyResolveResult resolveResult = GroovyToJavaGenerator.resolveChainingConstructor(constructor);
        if (resolveResult == null) {
            return Collections.emptySet();
        }
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        PsiMethod chainedConstructor = (PsiMethod)resolveResult.getElement();
        assert (chainedConstructor != null);
        if (!visited.add(chainedConstructor)) {
            return Collections.emptySet();
        }
        Set result = CollectionFactory.newTroveSet((Object[])new Object[0]);
        for (PsiClassType type : chainedConstructor.getThrowsList().getReferencedTypes()) {
            result.add(GroovyToJavaGenerator.getTypeText(substitutor.substitute((PsiType)type), null, false));
        }
        if (chainedConstructor instanceof GrConstructor) {
            result.addAll(GroovyToJavaGenerator.collectThrowsTypes((GrConstructor)chainedConstructor, visited));
        }
        return result;
    }

    @Nullable
    private static GroovyResolveResult resolveChainingConstructor(GrConstructor constructor) {
        GrConstructorInvocation constructorInvocation = constructor.getChainingConstructorInvocation();
        if (constructorInvocation == null) {
            return null;
        }
        GroovyResolveResult resolveResult = constructorInvocation.resolveConstructorGenerics();
        if (resolveResult.getElement() != null) {
            return resolveResult;
        }
        GroovyResolveResult[] results = constructorInvocation.multiResolveConstructor();
        if (results.length > 0) {
            int i = 0;
            while (results.length > i + 1) {
                PsiMethod candidate = (PsiMethod)results[i].getElement();
                PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)constructor.getProject()).getResolveHelper();
                if (candidate != null && candidate != constructor && resolveHelper.isAccessible((PsiMember)candidate, (PsiElement)constructorInvocation, null)) break;
                ++i;
            }
            return results[i];
        }
        return null;
    }

    private static String getDefaultValueText(String typeCanonicalText) {
        String result = typesToInitialValues.get(typeCanonicalText);
        if (result == null) {
            return "null";
        }
        return result;
    }

    private static void writeVariableDeclarations(StringBuffer text, GrVariableDeclaration variableDeclaration) {
        String type = GroovyToJavaGenerator.getTypeText(variableDeclaration.getTypeElementGroovy());
        String initializer = GroovyToJavaGenerator.getDefaultValueText(type);
        GrModifierList modifierList = variableDeclaration.getModifierList();
        PsiNameHelper nameHelper = JavaPsiFacade.getInstance((Project)variableDeclaration.getProject()).getNameHelper();
        for (GrVariable variable : variableDeclaration.getVariables()) {
            String name = variable.getName();
            if (!nameHelper.isIdentifier(name)) continue;
            text.append("\n  ");
            GroovyToJavaGenerator.writeFieldModifiers(text, modifierList, JAVA_MODIFIERS);
            text.append(type).append(" ").append(name).append(" = ").append(initializer).append(";\n");
        }
    }

    private static void writeMethod(StringBuffer text, PsiMethod method, PsiParameter[] parameters) {
        PsiType retType;
        if (method == null) {
            return;
        }
        String name = method.getName();
        if (!JavaPsiFacade.getInstance((Project)method.getProject()).getNameHelper().isIdentifier(name)) {
            return;
        }
        boolean isAbstract = method.hasModifierProperty("abstract");
        PsiModifierList modifierList = method.getModifierList();
        text.append("\n");
        text.append("  ");
        GroovyToJavaGenerator.writeMethodModifiers(text, modifierList, JAVA_MODIFIERS);
        if (method.hasTypeParameters()) {
            GroovyToJavaGenerator.appendTypeParameters(text, (PsiTypeParameterListOwner)method);
            text.append(" ");
        }
        if (method instanceof GrMethod) {
            retType = ((GrMethod)method).getDeclaredReturnType();
            if (retType == null) {
                retType = TypesUtil.getJavaLangObject((PsiElement)method);
            }
        } else {
            retType = method.getReturnType();
        }
        text.append(GroovyToJavaGenerator.getTypeText(retType, (PsiElement)method, false));
        text.append(" ");
        text.append(name);
        text.append("(");
        int i = 0;
        while (i < parameters.length) {
            PsiParameter parameter = parameters[i];
            if (parameter == null) continue;
            if (i > 0) {
                text.append(", ");
            }
            text.append(GroovyToJavaGenerator.getTypeText(parameter.getType(), (PsiElement)parameter, i == parameters.length - 1));
            text.append(" ");
            text.append(parameter.getName());
            ++i;
        }
        text.append(")");
        text.append(" ");
        if (!isAbstract) {
            text.append("{\n");
            text.append("    return ");
            text.append(GroovyToJavaGenerator.getDefaultValueText(GroovyToJavaGenerator.getTypeText(retType, (PsiElement)method, false)));
            text.append(";");
            text.append("\n  }");
        } else {
            text.append(";");
        }
        text.append("\n");
    }

    private static boolean writeMethodModifiers(StringBuffer text, PsiModifierList modifierList, String[] modifiers) {
        boolean wasAddedModifiers = false;
        for (String modifierType : modifiers) {
            if (!modifierList.hasModifierProperty(modifierType)) continue;
            text.append(modifierType);
            text.append(" ");
            wasAddedModifiers = true;
        }
        return wasAddedModifiers;
    }

    private static void writeFieldModifiers(StringBuffer text, GrModifierList modifierList, String[] modifiers) {
        for (String modifierType : modifiers) {
            if (!modifierList.hasModifierProperty(modifierType)) continue;
            text.append(modifierType);
            text.append(" ");
        }
    }

    private static void writeClassModifiers(StringBuffer text, @Nullable PsiModifierList modifierList, boolean isInterface, boolean toplevel) {
        if (modifierList == null || modifierList.hasModifierProperty("public")) {
            text.append("public ");
        }
        if (modifierList != null) {
            ArrayList<String> allowedModifiers = new ArrayList<String>();
            allowedModifiers.add("final");
            if (!toplevel) {
                allowedModifiers.addAll(Arrays.asList("protected", "private", "static"));
            }
            if (!isInterface) {
                allowedModifiers.add("abstract");
            }
            for (String modifierType : allowedModifiers) {
                if (!modifierList.hasModifierProperty(modifierType)) continue;
                text.append(modifierType).append(" ");
            }
        }
    }

    private static String getTypeText(GrTypeElement typeElement) {
        if (typeElement == null) {
            return "java.lang.Object";
        }
        return GroovyToJavaGenerator.getTypeText(typeElement.getType(), typeElement, false);
    }

    private static String getTypeText(@Nullable PsiType type, @Nullable PsiElement context, boolean allowVarargs) {
        String accessible;
        if (context != null && type instanceof PsiClassType && (accessible = GroovyToJavaGenerator.findAccessibleSuperClass(context, ((PsiClassType)type).resolve())) != null) {
            return accessible;
        }
        if (type instanceof PsiArrayType) {
            String componentText = GroovyToJavaGenerator.getTypeText(((PsiArrayType)type).getComponentType(), context, false);
            if (allowVarargs && type instanceof PsiEllipsisType) {
                return componentText + "...";
            }
            return componentText + "[]";
        }
        if (type == null) {
            return "java.lang.Object";
        }
        String canonicalText = type.getCanonicalText();
        return canonicalText != null ? canonicalText : type.getPresentableText();
    }

    @Nullable
    private static String findAccessibleSuperClass(PsiElement context, @Nullable PsiClass initialClass) {
        String qname;
        PsiClass curClass;
        if (initialClass == null) {
            return null;
        }
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)context.getProject()).getResolveHelper();
        for (curClass = initialClass; curClass != null && !resolveHelper.isAccessible((PsiMember)curClass, context, null); curClass = curClass.getSuperClass()) {
        }
        if (curClass != null && !initialClass.isEquivalentTo((PsiElement)curClass) && (qname = curClass.getQualifiedName()) != null) {
            return qname;
        }
        return null;
    }

    static {
        typesToInitialValues.put("boolean", "false");
        typesToInitialValues.put("int", "0");
        typesToInitialValues.put("short", "0");
        typesToInitialValues.put("long", "0L");
        typesToInitialValues.put("byte", "0");
        typesToInitialValues.put("char", "'c'");
        typesToInitialValues.put("double", "0D");
        typesToInitialValues.put("float", "0F");
        typesToInitialValues.put("void", "");
        JAVA_MODIFIERS = new String[]{"public", "protected", "private", "packageLocal", "static", "abstract", "final", "native"};
        PREFIX_SEPARATOR = "/";
    }

    public class GenerationItem {
        ValidityState myState;
        final Module myModule;
        public int myHashCode;
        private final VirtualFile myVFile;

        public GenerationItem(String path, Module module, ValidityState state, VirtualFile vFile) {
            this.myVFile = vFile;
            this.myModule = module;
            this.myState = state;
            this.myHashCode = GroovyToJavaGenerator.this.myTrie.getHashCode(path);
        }

        public String getPath() {
            return GroovyToJavaGenerator.this.myTrie.getString(this.myHashCode);
        }

        public Module getModule() {
            return this.myModule;
        }

        public VirtualFile getVFile() {
            return this.myVFile;
        }
    }
}

