/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.compiler;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.compiler.impl.FileSetCompileScope;
import com.intellij.compiler.impl.javaCompiler.ModuleChunk;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.compiler.TranslatingCompiler;
import com.intellij.openapi.compiler.ex.CompileContextEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Chunk;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.groovy.compiler.rt.CompilerMessage;
import org.jetbrains.groovy.compiler.rt.GroovycRunner;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.compiler.GroovyCompilerConfiguration;
import org.jetbrains.plugins.groovy.compiler.GroovyCompilerExtension;
import org.jetbrains.plugins.groovy.compiler.GroovycOSProcessHandler;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptType;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.util.GroovyUtils;

public abstract class GroovyCompilerBase
implements TranslatingCompiler {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.compiler.GroovyCompilerBase");
    protected final Project myProject;

    public GroovyCompilerBase(Project project) {
        this.myProject = project;
    }

    protected void runGroovycCompiler(CompileContext compileContext, Module module, List<VirtualFile> toCompile, boolean forStubs, VirtualFile outputDir, TranslatingCompiler.OutputSink sink, boolean tests) {
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        assert (sdk != null);
        SdkType sdkType = sdk.getSdkType();
        assert (sdkType instanceof JavaSdkType);
        String exePath = ((JavaSdkType)sdkType).getVMExecutablePath(sdk);
        JavaParameters parameters = new JavaParameters();
        PathsList classPathBuilder = parameters.getClassPath();
        classPathBuilder.add(PathUtil.getJarPathForClass(GroovycRunner.class));
        ModuleChunk chunk = GroovyCompilerBase.createChunk(module, compileContext);
        Library[] libraries = GroovyConfigUtils.getInstance().getSDKLibrariesByModule(module);
        if (libraries.length > 0) {
            classPathBuilder.addVirtualFiles(Arrays.asList(libraries[0].getFiles(OrderRootType.COMPILATION_CLASSES)));
        }
        classPathBuilder.addVirtualFiles((List)chunk.getCompilationBootClasspathFiles());
        classPathBuilder.addVirtualFiles((List)chunk.getCompilationClasspathFiles());
        GroovyCompilerBase.appendOutputPath(module, classPathBuilder, false);
        if (tests) {
            GroovyCompilerBase.appendOutputPath(module, classPathBuilder, true);
        }
        SmartList patchers = new SmartList();
        for (GroovyCompilerExtension extension : (GroovyCompilerExtension[])GroovyCompilerExtension.EP_NAME.getExtensions()) {
            extension.enhanceCompilationClassPath(chunk, classPathBuilder);
            patchers.addAll(extension.getCompilationUnitPatchers(chunk));
        }
        boolean profileGroovyc = "true".equals(System.getProperty("profile.groovy.compiler"));
        if (profileGroovyc) {
            parameters.getVMParametersList().defineProperty("java.library.path", PathManager.getBinPath());
            parameters.getVMParametersList().defineProperty("profile.groovy.compiler", "true");
            parameters.getVMParametersList().add("-agentlib:yjpagent=disablej2ee,disablecounts,disablealloc,sessionname=GroovyCompiler");
            classPathBuilder.add(PathManager.findFileInLibDirectory((String)"yjp-controller-api-redist.jar").getAbsolutePath());
        }
        parameters.getVMParametersList().add("-Xmx" + GroovyCompilerConfiguration.getInstance(this.myProject).getHeapSize() + "m");
        if (profileGroovyc) {
            parameters.getVMParametersList().add("-XX:+HeapDumpOnOutOfMemoryError");
        }
        ArrayList list = new ArrayList();
        CompilerUtil.addLocaleOptions(list, (boolean)false);
        for (String s : list) {
            parameters.getVMParametersList().add(s);
        }
        parameters.setMainClass(GroovycRunner.class.getName());
        try {
            File fileWithParameters = File.createTempFile("toCompile", "");
            VirtualFile finalOutputDir = GroovyCompilerBase.getMainOutput(compileContext, module, tests);
            LOG.assertTrue(finalOutputDir != null, (Object)("No output directory for module " + module.getName() + (tests ? " tests" : " production")));
            this.fillFileWithGroovycParameters(toCompile, fileWithParameters, outputDir, (List<String>)patchers, finalOutputDir);
            parameters.getProgramParametersList().add(forStubs ? "stubs" : "groovyc");
            parameters.getProgramParametersList().add(fileWithParameters.getPath());
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        try {
            GeneralCommandLine commandLine = JdkUtil.setupJVMCommandLine((String)exePath, (SimpleJavaParameters)parameters, (boolean)true);
            GroovycOSProcessHandler processHandler = new GroovycOSProcessHandler(compileContext, commandLine.createProcess(), commandLine.getCommandLineString());
            processHandler.startNotify();
            processHandler.waitFor();
            ArrayList<VirtualFile> toRecompile = new ArrayList<VirtualFile>();
            Set<File> toRecompileFiles = processHandler.getToRecompileFiles();
            for (File toRecompileFile : toRecompileFiles) {
                VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(toRecompileFile);
                LOG.assertTrue(vFile != null);
                toRecompile.add(vFile);
            }
            List<CompilerMessage> messages = processHandler.getCompilerMessages();
            for (CompilerMessage compilerMessage : messages) {
                CompilerMessageCategory category = GroovyCompilerBase.getMessageCategory(compilerMessage);
                String url = compilerMessage.getUrl();
                compileContext.addMessage(category, compilerMessage.getMessage(), VfsUtil.pathToUrl((String)FileUtil.toSystemIndependentName((String)url)), compilerMessage.getLineNum(), compilerMessage.getColumnNum());
            }
            boolean hasMessages = !messages.isEmpty();
            StringBuffer unparsedBuffer = processHandler.getUnparsedOutput();
            if (unparsedBuffer.length() != 0) {
                compileContext.addMessage(CompilerMessageCategory.ERROR, unparsedBuffer.toString(), null, -1, -1);
                hasMessages = true;
            }
            int exitCode = processHandler.getProcess().exitValue();
            if (!hasMessages && exitCode != 0) {
                compileContext.addMessage(CompilerMessageCategory.ERROR, "Internal groovyc error: code " + exitCode, null, -1, -1);
            }
            List<Object> outputItems = processHandler.getSuccessfullyCompiled();
            if (forStubs) {
                ArrayList<String> outputPaths = new ArrayList<String>();
                for (TranslatingCompiler.OutputItem outputItem : outputItems) {
                    outputPaths.add(outputItem.getOutputPath());
                }
                GroovyCompilerBase.addStubsToCompileScope(outputPaths, compileContext, module);
                outputItems = Collections.emptyList();
            }
            sink.add(outputDir.getPath(), outputItems, VfsUtil.toVirtualFileArray(toRecompile));
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
        }
    }

    protected static void addStubsToCompileScope(List<String> outputPaths, CompileContext compileContext, Module module) {
        ArrayList stubFiles = new ArrayList();
        for (String outputPath : outputPaths) {
            File stub = new File(outputPath);
            CompilerUtil.refreshIOFile((File)stub);
            VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(stub);
            ContainerUtil.addIfNotNull((Object)file, stubFiles);
        }
        ((CompileContextEx)compileContext).addScope((CompileScope)new FileSetCompileScope(stubFiles, new Module[]{module}));
    }

    @Nullable
    protected static VirtualFile getMainOutput(CompileContext compileContext, Module module, boolean tests) {
        return tests ? compileContext.getModuleOutputDirectoryForTests(module) : compileContext.getModuleOutputDirectory(module);
    }

    private static CompilerMessageCategory getMessageCategory(CompilerMessage compilerMessage) {
        String category = compilerMessage.getCategory();
        if ("error".equals(category)) {
            return CompilerMessageCategory.ERROR;
        }
        if ("information".equals(category)) {
            return CompilerMessageCategory.INFORMATION;
        }
        if ("statistic".equals(category)) {
            return CompilerMessageCategory.STATISTICS;
        }
        if ("warning".equals(category)) {
            return CompilerMessageCategory.WARNING;
        }
        return CompilerMessageCategory.ERROR;
    }

    private void fillFileWithGroovycParameters(List<VirtualFile> virtualFiles, File f, VirtualFile outputDir, List<String> patchers, @NotNull VirtualFile finalOutputDir) {
        FileOutputStream stream;
        if (finalOutputDir == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of org/jetbrains/plugins/groovy/compiler/GroovyCompilerBase.fillFileWithGroovycParameters must not be null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Running groovyc on: " + virtualFiles.toString());
        }
        try {
            stream = new FileOutputStream(f);
        }
        catch (FileNotFoundException e) {
            LOG.error((Throwable)e);
            return;
        }
        final PrintStream printer = new PrintStream(stream);
        for (final VirtualFile item : virtualFiles) {
            printer.println("src_file");
            printer.println(item.getPath());
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    PsiFile file = PsiManager.getInstance((Project)GroovyCompilerBase.this.myProject).findFile(item);
                    if (file instanceof GroovyFileBase) {
                        for (PsiClass psiClass : ((GroovyFileBase)file).getClasses()) {
                            printer.println(psiClass.getQualifiedName());
                        }
                    }
                }
            });
            printer.println("end");
        }
        if (!patchers.isEmpty()) {
            printer.println("patchers");
            for (String patcher : patchers) {
                printer.println(patcher);
            }
            printer.println("end");
        }
        Charset ideCharset = EncodingProjectManager.getInstance((Project)this.myProject).getDefaultCharset();
        if (!Comparing.equal((Object)CharsetToolkit.getDefaultSystemCharset(), (Object)ideCharset)) {
            printer.println("encoding");
            printer.println(ideCharset.name());
        }
        printer.println("outputpath");
        printer.println(PathUtil.getLocalPath((VirtualFile)outputDir));
        printer.println("final_outputpath");
        printer.println(finalOutputDir.getPath());
        printer.close();
    }

    private static void appendOutputPath(Module module, PathsList compileClasspath, boolean forTestClasses) {
        String output = CompilerPaths.getModuleOutputPath((Module)module, (boolean)forTestClasses);
        if (output != null) {
            compileClasspath.add(FileUtil.toSystemDependentName((String)output));
        }
    }

    private static ModuleChunk createChunk(Module module, CompileContext context) {
        return new ModuleChunk((CompileContextEx)context, new Chunk((Object)module), Collections.emptyMap());
    }

    public void compile(CompileContext compileContext, Chunk<Module> moduleChunk, VirtualFile[] virtualFiles, TranslatingCompiler.OutputSink sink) {
        Map mapModulesToVirtualFiles = moduleChunk.getNodes().size() == 1 ? Collections.singletonMap(moduleChunk.getNodes().iterator().next(), Arrays.asList(virtualFiles)) : CompilerUtil.buildModuleToFilesMap((CompileContext)compileContext, (VirtualFile[])virtualFiles);
        for (Module module : moduleChunk.getNodes()) {
            List<VirtualFile> moduleFiles = mapModulesToVirtualFiles.get(module);
            if (moduleFiles == null) continue;
            ModuleFileIndex index = ModuleRootManager.getInstance((Module)module).getFileIndex();
            ArrayList<VirtualFile> toCompile = new ArrayList<VirtualFile>();
            ArrayList<VirtualFile> toCompileTests = new ArrayList<VirtualFile>();
            CompilerConfiguration configuration = CompilerConfiguration.getInstance((Project)this.myProject);
            PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
            if (GroovyUtils.isAcceptableModuleType(module.getModuleType())) {
                for (VirtualFile file : moduleFiles) {
                    if (!GroovyCompilerBase.shouldCompile(file, configuration, psiManager)) continue;
                    (index.isInTestSourceContent(file) ? toCompileTests : toCompile).add(file);
                }
            }
            if (!toCompile.isEmpty()) {
                this.compileFiles(compileContext, module, toCompile, sink, false);
            }
            if (toCompileTests.isEmpty()) continue;
            this.compileFiles(compileContext, module, toCompileTests, sink, true);
        }
    }

    private static boolean shouldCompile(final VirtualFile file, CompilerConfiguration configuration, final PsiManager manager) {
        if (configuration.isResourceFile(file)) {
            return false;
        }
        FileType fileType = file.getFileType();
        if (fileType == GroovyFileType.GROOVY_FILE_TYPE) {
            return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    PsiFile psiFile = manager.findFile(file);
                    if (psiFile instanceof GroovyFile && ((GroovyFile)psiFile).isScript()) {
                        GroovyScriptType scriptType = GroovyScriptType.getScriptType((GroovyFile)psiFile);
                        return scriptType.shouldBeCompiled((GroovyFile)psiFile);
                    }
                    return true;
                }
            });
        }
        return fileType == StdFileTypes.JAVA;
    }

    protected abstract void compileFiles(CompileContext var1, Module var2, List<VirtualFile> var3, TranslatingCompiler.OutputSink var4, boolean var5);

    public boolean isCompilableFile(VirtualFile file, CompileContext context) {
        boolean result = ((Object)((Object)GroovyFileType.GROOVY_FILE_TYPE)).equals(file.getFileType());
        if (result && LOG.isDebugEnabled()) {
            LOG.debug("compilable file: " + file.getPath());
        }
        return result;
    }
}

