/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.utils.EquivalenceChecker;
import org.jetbrains.plugins.groovy.codeInspection.utils.SideEffectChecker;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class GroovyConditionalCanBeConditionalCallInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        if ("Conditional expression can be conditional call" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/control/GroovyConditionalCanBeConditionalCallInspection.getDisplayName must not return null");
        }
        return "Conditional expression can be conditional call";
    }

    @NotNull
    public String getGroupDisplayName() {
        if ("Control Flow" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/control/GroovyConditionalCanBeConditionalCallInspection.getGroupDisplayName must not return null");
        }
        return "Control Flow";
    }

    @Override
    public String buildErrorString(Object ... args) {
        return "Conditional expression can be call #loc";
    }

    @Override
    public GroovyFix buildFix(PsiElement location) {
        return new CollapseConditionalFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static boolean isEquality(GrBinaryExpression binaryCondition) {
        IElementType tokenType = binaryCondition.getOperationTokenType();
        return GroovyTokenTypes.mEQUAL == tokenType;
    }

    private static boolean isInequality(GrBinaryExpression binaryCondition) {
        IElementType tokenType = binaryCondition.getOperationTokenType();
        return GroovyTokenTypes.mNOT_EQUAL == tokenType;
    }

    private static GrExpression deparenthesizeExpression(GrExpression expression) {
        GrExpression expressionToTest = expression;
        while (expressionToTest instanceof GrParenthesizedExpression) {
            expressionToTest = ((GrParenthesizedExpression)expressionToTest).getOperand();
        }
        return expressionToTest;
    }

    private static boolean isNull(GrExpression expression) {
        return "null".equals(expression.getText());
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitConditionalExpression(GrConditionalExpression expression) {
            super.visitConditionalExpression(expression);
            GrExpression condition = expression.getCondition();
            GrExpression thenBranch = expression.getThenBranch();
            GrExpression elseBranch = expression.getElseBranch();
            if (condition == null || thenBranch == null || elseBranch == null) {
                return;
            }
            if (SideEffectChecker.mayHaveSideEffects(condition)) {
                return;
            }
            if (!((condition = GroovyConditionalCanBeConditionalCallInspection.deparenthesizeExpression(condition)) instanceof GrBinaryExpression)) {
                return;
            }
            GrBinaryExpression binaryCondition = (GrBinaryExpression)condition;
            GrExpression lhs = binaryCondition.getLeftOperand();
            GrExpression rhs = binaryCondition.getRightOperand();
            if (GroovyConditionalCanBeConditionalCallInspection.isInequality(binaryCondition) && GroovyConditionalCanBeConditionalCallInspection.isNull(elseBranch) && (GroovyConditionalCanBeConditionalCallInspection.isNull(lhs) && Visitor.isCallTargeting(thenBranch, rhs) || GroovyConditionalCanBeConditionalCallInspection.isNull(rhs) && Visitor.isCallTargeting(thenBranch, lhs))) {
                this.registerError(expression);
            }
            if (GroovyConditionalCanBeConditionalCallInspection.isEquality(binaryCondition) && GroovyConditionalCanBeConditionalCallInspection.isNull(thenBranch) && (GroovyConditionalCanBeConditionalCallInspection.isNull(lhs) && Visitor.isCallTargeting(elseBranch, rhs) || GroovyConditionalCanBeConditionalCallInspection.isNull(rhs) && Visitor.isCallTargeting(elseBranch, lhs))) {
                this.registerError(expression);
            }
        }

        private static boolean isCallTargeting(GrExpression call, GrExpression expression) {
            if (!(call instanceof GrMethodCallExpression)) {
                return false;
            }
            GrMethodCallExpression callExpression = (GrMethodCallExpression)call;
            GrExpression methodExpression = callExpression.getInvokedExpression();
            if (!(methodExpression instanceof GrReferenceExpression)) {
                return false;
            }
            GrReferenceExpression referenceExpression = (GrReferenceExpression)methodExpression;
            if (!GroovyTokenTypes.mDOT.equals(referenceExpression.getDotTokenType())) {
                return false;
            }
            return EquivalenceChecker.expressionsAreEquivalent(expression, referenceExpression.getQualifierExpression());
        }
    }

    private static class CollapseConditionalFix
    extends GroovyFix {
        private CollapseConditionalFix() {
        }

        @NotNull
        public String getName() {
            if ("Replace with conditional call" == null) {
                throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/control/GroovyConditionalCanBeConditionalCallInspection$CollapseConditionalFix.getName must not return null");
            }
            return "Replace with conditional call";
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            GrConditionalExpression expression = (GrConditionalExpression)descriptor.getPsiElement();
            GrBinaryExpression binaryCondition = (GrBinaryExpression)GroovyConditionalCanBeConditionalCallInspection.deparenthesizeExpression(expression.getCondition());
            GrMethodCallExpression call = GroovyConditionalCanBeConditionalCallInspection.isInequality(binaryCondition) ? (GrMethodCallExpression)expression.getThenBranch() : (GrMethodCallExpression)expression.getElseBranch();
            GrReferenceExpression methodExpression = (GrReferenceExpression)call.getInvokedExpression();
            GrExpression qualifier = methodExpression.getQualifierExpression();
            String methodName = methodExpression.getReferenceName();
            GrArgumentList argumentList = call.getArgumentList();
            if (argumentList == null) {
                return;
            }
            CollapseConditionalFix.replaceExpression(expression, qualifier.getText() + "?." + methodName + argumentList.getText());
        }
    }
}

