/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocCommentOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameter;

public class SuppressForMemberFix
extends SuppressIntentionAction {
    private final String myID;
    private String myKey;
    private final boolean myForClass;

    public SuppressForMemberFix(HighlightDisplayKey key, boolean forClass) {
        this.myID = key.getID();
        this.myForClass = forClass;
    }

    @Nullable
    protected GrDocCommentOwner getContainer(PsiElement context) {
        if (context == null || context instanceof PsiFile) {
            return null;
        }
        GrDocCommentOwner container = (GrDocCommentOwner)PsiTreeUtil.getParentOfType((PsiElement)context, GrDocCommentOwner.class);
        while (container instanceof GrAnonymousClassDefinition || container instanceof GrTypeParameter) {
            if ((container = (GrDocCommentOwner)PsiTreeUtil.getParentOfType((PsiElement)container, GrDocCommentOwner.class)) != null) continue;
            return null;
        }
        if (this.myForClass) {
            while (container != null) {
                GrTypeDefinition parentClass = (GrTypeDefinition)PsiTreeUtil.getParentOfType((PsiElement)container, GrTypeDefinition.class);
                if (parentClass == null && container instanceof GrTypeDefinition) {
                    return container;
                }
                container = parentClass;
            }
        }
        return container;
    }

    @NotNull
    public String getText() {
        String string = this.myKey != null ? InspectionsBundle.message((String)this.myKey, (Object[])new Object[0]) : "Suppress for member";
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/SuppressForMemberFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = InspectionsBundle.message((String)"suppress.inspection.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/SuppressForMemberFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @Nullable PsiElement context) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/SuppressForMemberFix.isAvailable must not be null");
        }
        GrDocCommentOwner container = this.getContainer(context);
        this.myKey = container instanceof PsiClass ? "suppress.inspection.class" : (container instanceof PsiMethod ? "suppress.inspection.method" : "suppress.inspection.field");
        return container != null && context != null && context.getManager().isInProject(context);
    }

    public void invoke(Project project, Editor editor, PsiElement element) throws IncorrectOperationException {
        GrDocCommentOwner container = this.getContainer(element);
        assert (container != null);
        ReadonlyStatusHandler.OperationStatus status = ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(new VirtualFile[]{container.getContainingFile().getVirtualFile()});
        if (status.hasReadonlyFiles()) {
            return;
        }
        GrModifierList modifierList = (GrModifierList)container.getModifierList();
        if (modifierList != null) {
            SuppressForMemberFix.addSuppressAnnotation(project, modifierList, this.myID);
        }
        DaemonCodeAnalyzer.getInstance((Project)project).restart();
    }

    private static void addSuppressAnnotation(Project project, GrModifierList modifierList, String id) throws IncorrectOperationException {
        PsiAnnotation annotation = modifierList.findAnnotation("java.lang.SuppressWarnings");
        GrExpression toAdd = GroovyPsiElementFactory.getInstance(project).createExpressionFromText("\"" + id + "\"");
        if (annotation != null) {
            PsiAnnotationMemberValue value = annotation.findDeclaredAttributeValue(null);
            if (value instanceof GrListOrMap) {
                value.add((PsiElement)toAdd);
            } else if (value != null) {
                GrExpression list = GroovyPsiElementFactory.getInstance(project).createExpressionFromText("[]");
                list.add((PsiElement)value);
                list.add(toAdd);
                annotation.setDeclaredAttributeValue(null, (PsiAnnotationMemberValue)list);
            }
        } else {
            modifierList.addAnnotation("java.lang.SuppressWarnings").setDeclaredAttributeValue(null, (PsiAnnotationMemberValue)toAdd);
        }
    }
}

