/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.TimedComputable;
import com.intellij.util.lang.ClasspathCache;
import com.intellij.util.lang.Loader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.misc.Resource;

class JarLoader
extends Loader {
    private final URL myURL;
    private final boolean myCanLockJar;
    private static final boolean myDebugTime = false;
    private final TimedComputable<ZipFile> myZipFileRef = new TimedComputable<ZipFile>(null){

        @Override
        @NotNull
        protected ZipFile calc() {
            ZipFile zipFile;
            try {
                ZipFile zipFile2 = JarLoader.this._getZipFile();
                if (zipFile2 == null) {
                    throw new RuntimeException("Can't load zip file");
                }
                zipFile = zipFile2;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (zipFile == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/lang/JarLoader$1.calc must not return null");
            }
            return zipFile;
        }
    };
    @NonNls
    private static final String JAR_PROTOCOL = "jar";
    @NonNls
    private static final String FILE_PROTOCOL = "file";
    private static final long NS_THRESHOLD = 10000000L;

    JarLoader(URL url, boolean canLockJar) throws IOException {
        super(new URL(JAR_PROTOCOL, "", -1, url + "!/"));
        this.myURL = url;
        this.myCanLockJar = canLockJar;
    }

    @Nullable
    private ZipFile getZipFile() throws IOException {
        if (this.myCanLockJar) {
            return this.myZipFileRef.acquire();
        }
        return this._getZipFile();
    }

    @Nullable
    private ZipFile _getZipFile() throws IOException {
        if (FILE_PROTOCOL.equals(this.myURL.getProtocol())) {
            String s = FileUtil.unquote(this.myURL.getFile());
            if (!new File(s).exists()) {
                throw new FileNotFoundException(s);
            }
            return new ZipFile(s);
        }
        return null;
    }

    @Override
    void buildCache(ClasspathCache cache) throws IOException {
        ZipFile zipFile = this.getZipFile();
        if (zipFile == null) {
            return;
        }
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            cache.addResourceEntry(zipEntry.getName(), this);
        }
        this.releaseZipFile(zipFile);
    }

    private void releaseZipFile(ZipFile zipFile) throws IOException {
        if (this.myCanLockJar) {
            this.myZipFileRef.release();
        } else {
            zipFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    Resource getResource(String name, boolean flag) {
        long started = 0L;
        try {
            ZipFile file = this.getZipFile();
            if (file == null) {
                Resource resource = null;
                return resource;
            }
            try {
                ZipEntry entry = file.getEntry(name);
                if (entry != null) {
                    MyResource doneFor = new MyResource(entry, new URL(this.getBaseURL(), name));
                    return doneFor;
                }
            }
            finally {
                this.releaseZipFile(file);
            }
        }
        catch (Exception e) {
            Resource resource = null;
            return resource;
        }
        finally {
            long doneFor = 0L;
            if (doneFor > 10000000L) {
                System.out.println(doneFor / 1000000L + " ms for jar loader get resource:" + name);
            }
        }
        return null;
    }

    @NonNls
    public String toString() {
        return "JarLoader [" + this.myURL + "]";
    }

    private class MyResource
    extends Resource {
        private final ZipEntry myEntry;
        private final URL myUrl;

        public MyResource(ZipEntry name, URL url) {
            this.myEntry = name;
            this.myUrl = url;
        }

        public String getName() {
            return this.myEntry.getName();
        }

        public URL getURL() {
            return this.myUrl;
        }

        public URL getCodeSourceURL() {
            return JarLoader.this.myURL;
        }

        @Nullable
        public InputStream getInputStream() throws IOException {
            final ZipFile file = JarLoader.this.getZipFile();
            if (file == null) {
                return null;
            }
            final boolean[] wasReleased = new boolean[]{false};
            try {
                InputStream inputStream = file.getInputStream(this.myEntry);
                if (inputStream == null) {
                    return null;
                }
                return new FilterInputStream(inputStream){
                    private boolean myClosed;
                    {
                        super(x0);
                        this.myClosed = false;
                    }

                    @Override
                    public void close() throws IOException {
                        super.close();
                        if (!this.myClosed) {
                            JarLoader.this.releaseZipFile(file);
                        }
                        this.myClosed = true;
                        wasReleased[0] = true;
                    }
                };
            }
            catch (IOException e) {
                e.printStackTrace();
                assert (!wasReleased[0]);
                JarLoader.this.releaseZipFile(file);
                return null;
            }
        }

        public int getContentLength() {
            return (int)this.myEntry.getSize();
        }
    }
}

