/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.Stack;
import com.intellij.util.lang.ClasspathCache;
import com.intellij.util.lang.FileLoader;
import com.intellij.util.lang.JarLoader;
import com.intellij.util.lang.Loader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import sun.misc.Resource;

class ClassPath {
    private final Stack<URL> myUrls = new Stack();
    private final ArrayList<Loader> myLoaders = new ArrayList();
    private final HashMap<URL, Loader> myLoadersMap = new HashMap();
    private final ClasspathCache myCache = new ClasspathCache();
    @NonNls
    private static final String FILE_PROTOCOL = "file";
    private static final boolean myDebugTime = false;
    private final boolean myCanLockJars;
    private final boolean myCanUseCache;
    private static final long NS_THRESHOLD = 10000000L;
    private static PrintStream ourOrder;

    private static void printOrder(Loader loader, String resource) {
        if (ourOrder == null) {
            File orderFile = new File(PathManager.getBinPath() + File.separator + "order.txt");
            try {
                if (!FileUtil.ensureCanCreateFile(orderFile)) {
                    return;
                }
                ourOrder = new PrintStream(new FileOutputStream(orderFile, true));
                ShutDownTracker.getInstance().registerShutdownTask(new Runnable(){

                    @Override
                    public void run() {
                        ourOrder.close();
                    }
                });
            }
            catch (IOException e) {
                return;
            }
        }
        if (ourOrder != null) {
            String jarURL = FileUtil.toSystemIndependentName(loader.getBaseURL().getFile());
            jarURL = jarURL.replaceFirst(FileUtil.toSystemIndependentName(PathManager.getHomePath()), "");
            jarURL = StringUtil.trimEnd(StringUtil.trimStart(jarURL, "file:/"), "!/");
            ourOrder.println(resource + ":" + jarURL);
        }
    }

    public ClassPath(URL[] urls, boolean canLockJars, boolean canUseCache) {
        this.myCanLockJars = canLockJars;
        this.myCanUseCache = canUseCache;
        this.push(urls);
    }

    void addURL(URL url) {
        this.push(new URL[]{url});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public Resource getResource(String s, boolean flag) {
        long started = 0L;
        try {
            Loader loader;
            Resource resource;
            int i;
            if (!this.myCanUseCache) {
                i = 0;
            } else {
                List<Loader> loaders = this.myCache.getLoaders(s);
                for (Loader loader2 : loaders) {
                    Resource resource2 = loader2.getResource(s, flag);
                    if (resource2 == null) continue;
                    Resource resource3 = resource2;
                    return resource3;
                }
                Stack<URL> i$ = this.myUrls;
                synchronized (i$) {
                    if (this.myUrls.isEmpty()) {
                        resource = null;
                        return resource;
                    }
                }
                i = this.myLoaders.size();
            }
            while ((loader = this.getLoader(i)) != null) {
                Resource resource4 = loader.getResource(s, flag);
                if (resource4 != null) {
                    resource = resource4;
                    return resource;
                }
                ++i;
            }
            Resource resource5 = null;
            return resource5;
        }
        finally {
            long doneFor = 0L;
            if (doneFor > 10000000L) {
                System.out.println(doneFor / 1000000L + " ms for getResource:" + s + ", flag:" + flag);
            }
        }
    }

    public Enumeration<URL> getResources(String name, boolean check) {
        return new MyEnumeration(name, check);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private synchronized Loader getLoader(int i) {
        while (this.myLoaders.size() < i + 1) {
            Loader loader;
            URL url;
            Stack<URL> stack = this.myUrls;
            synchronized (stack) {
                if (this.myUrls.empty()) {
                    return null;
                }
                url = this.myUrls.pop();
            }
            if (this.myLoadersMap.containsKey(url)) continue;
            try {
                loader = this.getLoader(url);
                if (loader == null) {
                }
            }
            catch (IOException ioexception) {}
            continue;
            this.myLoaders.add(loader);
            this.myLoadersMap.put(url, loader);
        }
        return this.myLoaders.get(i);
    }

    @Nullable
    private Loader getLoader(URL url) throws IOException {
        String s = url.getFile();
        Loader loader = null;
        if (s != null && new File(s).isDirectory()) {
            if (FILE_PROTOCOL.equals(url.getProtocol())) {
                loader = new FileLoader(url);
            }
        } else {
            loader = new JarLoader(url, this.myCanLockJars);
        }
        if (loader != null && this.myCanUseCache) {
            try {
                ((Loader)loader).buildCache(this.myCache);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void push(URL[] urls) {
        Stack<URL> stack = this.myUrls;
        synchronized (stack) {
            for (int i = urls.length - 1; i >= 0; --i) {
                this.myUrls.push(urls[i]);
            }
        }
    }

    private class MyEnumeration
    implements Enumeration<URL> {
        private int myIndex = 0;
        private Resource myRes = null;
        private final String myName;
        private final boolean myCheck;

        public MyEnumeration(String name, boolean check) {
            this.myName = name;
            this.myCheck = check;
        }

        private boolean next() {
            Loader loader;
            if (this.myRes != null) {
                return true;
            }
            while ((loader = ClassPath.this.getLoader(this.myIndex++)) != null) {
                this.myRes = loader.getResource(this.myName, this.myCheck);
                if (this.myRes == null) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean hasMoreElements() {
            return this.next();
        }

        @Override
        public URL nextElement() {
            if (!this.next()) {
                throw new NoSuchElementException();
            }
            Resource resource = this.myRes;
            this.myRes = null;
            return resource.getURL();
        }
    }
}

