/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public abstract class FactoryMap<K, V>
implements Map<K, V> {
    static final Object NULL = new Object();
    protected Map<K, V> myMap;

    protected Map<K, V> createMap() {
        return new THashMap();
    }

    @Nullable
    protected abstract V create(K var1);

    private Map<K, V> getMap() {
        if (this.myMap == null) {
            this.myMap = this.createMap();
        }
        return this.myMap;
    }

    @Override
    public V get(Object key) {
        Map<Object, Object> map = this.getMap();
        V value = map.get(FactoryMap.getKey(key));
        if (value == null) {
            value = this.create(key);
            map.put(FactoryMap.getKey(key), value == null ? NULL : value);
        }
        return value == NULL ? null : (V)value;
    }

    private static <K> K getKey(K key) {
        return (K)(key == null ? NULL : key);
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.myMap != null && this.myMap.containsKey(FactoryMap.getKey(key));
    }

    @Override
    public V put(K key, V value) {
        Object v = this.getMap().put(FactoryMap.getKey(key), value == null ? NULL : value);
        return (V)(v == NULL ? null : v);
    }

    @Override
    public V remove(Object key) {
        if (this.myMap == null) {
            return null;
        }
        V v = this.myMap.remove(key);
        return v == NULL ? null : (V)v;
    }

    @Override
    public Set<K> keySet() {
        if (this.myMap == null) {
            return Collections.emptySet();
        }
        Set<K> ts = this.myMap.keySet();
        if (ts.contains(NULL)) {
            HashSet<K> hashSet = new HashSet<K>(ts);
            hashSet.remove(NULL);
            hashSet.add(null);
            return hashSet;
        }
        return ts;
    }

    public Collection<V> notNullValues() {
        if (this.myMap == null) {
            return Collections.emptyList();
        }
        ArrayList<V> values = new ArrayList<V>(this.myMap.values());
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != NULL) continue;
            iterator.remove();
        }
        return values;
    }

    @Override
    public void clear() {
        if (this.myMap != null) {
            this.myMap.clear();
        }
    }

    @Override
    public int size() {
        if (this.myMap == null) {
            return 0;
        }
        return this.myMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap == null || this.myMap.isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.myMap != null && this.myMap.containsValue(value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Collection<V> values() {
        if (this.myMap == null) {
            return Collections.emptyList();
        }
        return this.myMap.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.myMap == null) {
            return Collections.emptySet();
        }
        return this.myMap.entrySet();
    }
}

