/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public abstract class LazyQuery<T>
implements Query<T> {
    private final NotNullLazyValue<Query<T>> myQuery = new NotNullLazyValue<Query<T>>(){

        @Override
        @NotNull
        protected Query<T> compute() {
            Query query = LazyQuery.this.computeQuery();
            if (query == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/LazyQuery$1.compute must not return null");
            }
            return query;
        }
    };

    @NotNull
    protected abstract Query<T> computeQuery();

    @Override
    @NotNull
    public Collection<T> findAll() {
        Collection<T> collection = this.myQuery.getValue().findAll();
        if (collection == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/LazyQuery.findAll must not return null");
        }
        return collection;
    }

    @Override
    public T findFirst() {
        return this.myQuery.getValue().findFirst();
    }

    @Override
    public boolean forEach(@NotNull Processor<T> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/LazyQuery.forEach must not be null");
        }
        return this.myQuery.getValue().forEach(consumer);
    }

    @Override
    public T[] toArray(T[] a) {
        return this.myQuery.getValue().toArray(a);
    }

    @Override
    public Iterator<T> iterator() {
        return this.myQuery.getValue().iterator();
    }
}

