/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class InstanceofQuery<T>
implements Query<T> {
    private final Class<? extends T>[] myClasses;
    private final Query<?> myDelegate;

    public InstanceofQuery(Query<?> delegate, Class<? extends T> ... aClasses) {
        this.myClasses = aClasses;
        this.myDelegate = delegate;
    }

    @Override
    @NotNull
    public Collection<T> findAll() {
        ArrayList result = new ArrayList();
        Collection<?> all = this.myDelegate.findAll();
        for (Object o : all) {
            for (Class<T> clazz : this.myClasses) {
                if (!clazz.isInstance(o)) continue;
                result.add(o);
            }
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/InstanceofQuery.findAll must not return null");
        }
        return arrayList;
    }

    @Override
    public T findFirst() {
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
        this.forEach((Processor<T>)processor);
        return processor.getFoundValue();
    }

    @Override
    public boolean forEach(final @NotNull Processor<T> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/InstanceofQuery.forEach must not be null");
        }
        return this.myDelegate.forEach(new Processor(){

            public boolean process(Object o) {
                for (Class aClass : InstanceofQuery.this.myClasses) {
                    if (!aClass.isInstance(o)) continue;
                    return consumer.process(o);
                }
                return true;
            }
        });
    }

    @Override
    public T[] toArray(T[] a) {
        Collection<T> all = this.findAll();
        return all.toArray(a);
    }

    @Override
    public Iterator<T> iterator() {
        return new UnmodifiableIterator<T>(this.findAll().iterator());
    }
}

