/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.jetbrains.annotations.NotNull;

public class NameUtil {
    private static final Function<String, String> LOWERCASE_MAPPING = new Function<String, String>(){

        @Override
        public String fun(String s) {
            return s.toLowerCase();
        }
    };

    private NameUtil() {
    }

    public static List<String> nameToWordsLowerCase(String name) {
        return ContainerUtil.map(NameUtil.nameToWords(name), LOWERCASE_MAPPING);
    }

    public static String[] nameToWords(String name) {
        ArrayList<String> array = new ArrayList<String>();
        int index = 0;
        while (index < name.length()) {
            int wordStart = index;
            int upperCaseCount = 0;
            int lowerCaseCount = 0;
            int digitCount = 0;
            int specialCount = 0;
            while (index < name.length()) {
                char c = name.charAt(index);
                if (Character.isDigit(c)) {
                    if (upperCaseCount > 0 || lowerCaseCount > 0 || specialCount > 0) break;
                    ++digitCount;
                } else if (Character.isUpperCase(c)) {
                    if (lowerCaseCount > 0 || digitCount > 0 || specialCount > 0) break;
                    ++upperCaseCount;
                } else if (Character.isLowerCase(c)) {
                    if (digitCount > 0 || specialCount > 0) break;
                    if (upperCaseCount > 1) {
                        --index;
                        break;
                    }
                    ++lowerCaseCount;
                } else {
                    if (upperCaseCount > 0 || lowerCaseCount > 0 || digitCount > 0) break;
                    ++specialCount;
                }
                ++index;
            }
            String word = name.substring(wordStart, index);
            array.add(word);
        }
        return ArrayUtil.toStringArray(array);
    }

    public static String buildRegexp(String pattern, int exactPrefixLen, boolean allowToUpper, boolean allowToLower) {
        return NameUtil.buildRegexp(pattern, exactPrefixLen, allowToUpper, allowToLower, false);
    }

    public static String buildRegexp(String pattern, int exactPrefixLen, boolean allowToUpper, boolean allowToLower, boolean lowerCaseWords) {
        int eol = pattern.indexOf(10);
        if (eol != -1) {
            pattern = pattern.substring(0, eol);
        }
        if (pattern.length() >= 80) {
            pattern = pattern.substring(0, 80);
        }
        StringBuffer buffer = new StringBuffer();
        boolean lastIsUppercase = false;
        boolean prevIsUppercase = false;
        boolean endsWithSpace = StringUtil.endsWithChar(pattern, ' ');
        if ((exactPrefixLen = Math.min(exactPrefixLen, (pattern = pattern.trim()).length())) > 0) {
            char c = pattern.charAt(exactPrefixLen - 1);
            prevIsUppercase = Character.isUpperCase(c) || Character.isDigit(c);
        }
        for (int i = 0; i != exactPrefixLen; ++i) {
            char c = pattern.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                buffer.append(c);
                continue;
            }
            buffer.append("\\").append(c);
        }
        if (exactPrefixLen == 0) {
            buffer.append("_*");
        }
        boolean firstIdentifierLetter = exactPrefixLen == 0;
        for (int i = exactPrefixLen; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            lastIsUppercase = false;
            if (Character.isLetterOrDigit(c)) {
                prevIsUppercase = false;
                if (Character.isUpperCase(c) || Character.isDigit(c)) {
                    prevIsUppercase = true;
                    lastIsUppercase = true;
                    buffer.append('(');
                    if (!firstIdentifierLetter) {
                        buffer.append("[a-z\\s0-9\\$]*");
                    }
                    buffer.append(c);
                    if (allowToLower) {
                        buffer.append('|');
                        buffer.append(Character.toLowerCase(c));
                    }
                    if (!firstIdentifierLetter) {
                        buffer.append("|([A-Za-z\\s0-9\\$]*(_|-)(");
                        buffer.append(c);
                        buffer.append("|");
                        buffer.append(Character.toLowerCase(c));
                        buffer.append("))");
                    }
                    buffer.append(')');
                } else if (Character.isLowerCase(c) && allowToUpper) {
                    buffer.append('[');
                    buffer.append(c);
                    buffer.append(Character.toUpperCase(c));
                    buffer.append(']');
                    if (lowerCaseWords) {
                        buffer.append("([a-z\\s0-9\\$]*[-_])?");
                    }
                } else {
                    buffer.append(c);
                }
                firstIdentifierLetter = false;
                continue;
            }
            if (c == '*') {
                buffer.append(".*");
                firstIdentifierLetter = true;
                continue;
            }
            if (c == '.') {
                if (!firstIdentifierLetter) {
                    buffer.append("[a-z\\s0-9\\$]*\\.");
                } else {
                    buffer.append("\\.");
                }
                firstIdentifierLetter = true;
                continue;
            }
            if (c == ' ') {
                buffer.append("([a-z\\s0-9\\$_-]*[\\ _-])+");
                firstIdentifierLetter = true;
                continue;
            }
            if (prevIsUppercase) {
                buffer.append("[A-Za-z\\s0-9\\$]*");
            }
            firstIdentifierLetter = true;
            buffer.append("\\").append(c);
        }
        if (!endsWithSpace) {
            buffer.append(".*");
        } else if (lastIsUppercase) {
            buffer.append("[a-z\\s0-9\\$]*");
        }
        return buffer.toString();
    }

    public static String[] splitNameIntoWords(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/codeStyle/NameUtil.splitNameIntoWords must not be null");
        }
        String[] underlineDelimited = name.split("_");
        ArrayList<String> result = new ArrayList<String>();
        for (String word : underlineDelimited) {
            NameUtil.addAllWords(word, result);
        }
        return ArrayUtil.toStringArray(result);
    }

    private static void addAllWords(String word, List<String> result) {
        StringCharacterIterator it = new StringCharacterIterator(word);
        StringBuffer b = new StringBuffer();
        WordState state = WordState.NO_WORD;
        char curPrevUC = '\u0000';
        char c = it.first();
        while (c != '\uffff') {
            switch (state) {
                case NO_WORD: {
                    if (!Character.isUpperCase(c)) {
                        b.append(c);
                        state = WordState.WORD;
                        break;
                    }
                    state = WordState.PREV_UC;
                    curPrevUC = c;
                    break;
                }
                case PREV_UC: {
                    if (!Character.isUpperCase(c)) {
                        b = NameUtil.startNewWord(result, b, curPrevUC);
                        b.append(c);
                        state = WordState.WORD;
                        break;
                    }
                    b.append(curPrevUC);
                    state = WordState.PREV_UC;
                    curPrevUC = c;
                    break;
                }
                case WORD: {
                    if (Character.isUpperCase(c)) {
                        NameUtil.startNewWord(result, b, c);
                        b.setLength(0);
                        state = WordState.PREV_UC;
                        curPrevUC = c;
                        break;
                    }
                    b.append(c);
                }
            }
            c = it.next();
        }
        if (state == WordState.PREV_UC) {
            b.append(curPrevUC);
        }
        result.add(b.toString());
    }

    private static StringBuffer startNewWord(List<String> result, StringBuffer b, char c) {
        if (b.length() > 0) {
            result.add(b.toString());
        }
        b = new StringBuffer();
        b.append(c);
        return b;
    }

    public static Matcher buildMatcher(String pattern, int exactPrefixLen, boolean allowToUpper, boolean allowToLower) {
        return NameUtil.buildMatcher(pattern, NameUtil.buildRegexp(pattern, exactPrefixLen, allowToUpper, allowToLower));
    }

    public static Matcher buildMatcher(String pattern, int exactPrefixLen, boolean allowToUpper, boolean allowToLower, boolean lowerCaseWords) {
        return NameUtil.buildMatcher(pattern, NameUtil.buildRegexp(pattern, exactPrefixLen, allowToUpper, allowToLower, lowerCaseWords));
    }

    private static Matcher buildMatcher(String pattern, String regexp) {
        return new OptimizedMatcher(pattern, regexp);
    }

    private static class OptimizedMatcher
    implements Matcher {
        private final char[] myPreparedPattern;
        private final boolean myEnsureFirstSymbolsMatch;
        private final Perl5Matcher myMatcher;
        private final Pattern myPattern;

        public OptimizedMatcher(String pattern, String regexp) {
            this.myPreparedPattern = OptimizedMatcher.preparePattern(pattern).toCharArray();
            this.myEnsureFirstSymbolsMatch = pattern.length() > 0 && Character.isLetterOrDigit(pattern.charAt(0));
            try {
                this.myPattern = new Perl5Compiler().compile(regexp);
            }
            catch (MalformedPatternException e) {
                throw new RuntimeException(e);
            }
            this.myMatcher = new Perl5Matcher();
        }

        @Override
        public boolean matches(String name) {
            if (!this.prefilter(name, this.myPreparedPattern)) {
                return false;
            }
            return this.myMatcher.matches(name, this.myPattern);
        }

        private static String preparePattern(String pattern) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < pattern.length(); ++i) {
                char c = pattern.charAt(i);
                if (!Character.isLetterOrDigit(c)) continue;
                builder.append(StringUtil.toLowerCase(c));
            }
            return builder.toString();
        }

        private boolean prefilter(String name, char[] pattern) {
            int nameIndex;
            int patternIndex = 0;
            int patternLen = pattern.length;
            int nameLen = name.length();
            if (this.myEnsureFirstSymbolsMatch) {
                for (nameIndex = 0; nameIndex < nameLen && name.charAt(nameIndex) == '_'; ++nameIndex) {
                }
                if (patternLen == 0 || nameIndex >= nameLen) {
                    return false;
                }
                if (StringUtil.toLowerCase(name.charAt(nameIndex)) != pattern[0]) {
                    return false;
                }
                ++nameIndex;
                ++patternIndex;
            }
            while (patternIndex < patternLen) {
                char c = pattern[patternIndex++];
                do {
                    if (nameIndex < nameLen) continue;
                    return false;
                } while (StringUtil.toLowerCase(name.charAt(nameIndex++)) != c);
            }
            return true;
        }
    }

    public static interface Matcher {
        public boolean matches(String var1);
    }

    private static enum WordState {
        NO_WORD,
        PREV_UC,
        WORD;

    }
}

