/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.List;

public class ShutDownTracker
implements Runnable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.ShutDownTracker");
    private static ShutDownTracker ourInstance;
    private final List<Thread> myThreads = new ArrayList<Thread>();
    private final List<Thread> myShutdownThreads = new ArrayList<Thread>();
    private final List<Runnable> myShutdownTasks = new ArrayList<Runnable>();
    private volatile boolean myIsShutdownHookRunning = false;

    private ShutDownTracker() {
        Runtime.getRuntime().addShutdownHook(new Thread((Runnable)this, "Shutdown tracker"));
    }

    public static synchronized ShutDownTracker getInstance() {
        if (ourInstance == null) {
            ourInstance = new ShutDownTracker();
        }
        return ourInstance;
    }

    public static boolean isShutdownHookRunning() {
        return ShutDownTracker.getInstance().myIsShutdownHookRunning;
    }

    @Override
    public void run() {
        this.myIsShutdownHookRunning = true;
        Thread[] threads = this.getStopperThreads();
        while (threads.length > 0) {
            Thread thread = threads[0];
            if (!thread.isAlive()) {
                if (this.isRegistered(thread)) {
                    LOG.error("Thread '" + thread.getName() + "' did not unregister itself from ShutDownTracker.");
                    this.unregisterStopperThread(thread);
                }
            } else {
                try {
                    thread.join(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            threads = this.getStopperThreads();
        }
        while (!this.myShutdownTasks.isEmpty()) {
            Runnable task = this.myShutdownTasks.remove(this.myShutdownTasks.size() - 1);
            try {
                task.run();
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        for (int idx = this.myShutdownThreads.size() - 1; idx >= 0; --idx) {
            Thread thread = this.myShutdownThreads.remove(idx);
            thread.start();
            try {
                thread.join();
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    private synchronized boolean isRegistered(Thread thread) {
        return this.myThreads.contains(thread);
    }

    private synchronized Thread[] getStopperThreads() {
        return this.myThreads.toArray(new Thread[this.myThreads.size()]);
    }

    public synchronized void registerStopperThread(Thread thread) {
        this.myThreads.add(thread);
    }

    public synchronized void unregisterStopperThread(Thread thread) {
        this.myThreads.remove(thread);
    }

    public void registerShutdownThread(Thread thread) {
        this.myShutdownThreads.add(thread);
    }

    public void registerShutdownThread(int index, Thread thread) {
        this.myShutdownThreads.add(index, thread);
    }

    public void registerShutdownTask(Runnable task) {
        this.myShutdownTasks.add(task);
    }

    public void unregisterShutdownTask(Runnable task) {
        this.myShutdownTasks.remove(task);
    }
}

