/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.browser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import net.sourceforge.jnlp.runtime.JNLPRuntime;

public class FirefoxPreferencesFinder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File find() throws IOException {
        String configPath = System.getProperty("user.home") + File.separator + ".mozilla" + File.separator + "firefox" + File.separator;
        String profilesPath = configPath + "profiles.ini";
        if (!new File(profilesPath).isFile()) {
            throw new FileNotFoundException(profilesPath);
        }
        if (JNLPRuntime.isDebug()) {
            System.out.println("Using firefox's profiles file: " + profilesPath);
        }
        BufferedReader reader = new BufferedReader(new FileReader(profilesPath));
        ArrayList<String> linesInSection = new ArrayList<String>();
        boolean foundDefaultSection = false;
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("[Profile") && line.endsWith("]")) {
                    if (foundDefaultSection) {
                        break;
                    }
                    linesInSection = new ArrayList();
                    continue;
                }
                linesInSection.add(line);
                int equalSignPos = line.indexOf(61);
                if (equalSignPos <= 0) continue;
                String key = line.substring(0, equalSignPos).trim();
                String value = line.substring(equalSignPos + 1).trim();
                if (!key.toLowerCase().equals("default") || !value.equals("1")) continue;
                foundDefaultSection = true;
            }
        }
        finally {
            reader.close();
        }
        if (!foundDefaultSection && linesInSection.size() == 0) {
            throw new FileNotFoundException("preferences file");
        }
        String path = null;
        for (String line : linesInSection) {
            if (!line.startsWith("Path=")) continue;
            path = line.substring("Path=".length());
        }
        if (path == null) {
            throw new FileNotFoundException("preferences file");
        }
        String fullPath = configPath + path + File.separator + "prefs.js";
        if (JNLPRuntime.isDebug()) {
            System.out.println("Found preferences file: " + fullPath);
        }
        return new File(fullPath);
    }
}

