#!/bin/sh
echo 'name: tls
version: 0.8.1
id: tls-0.8.1-6fb2ab6cc5b8b9609a91fc35d9ef85b6

license: BSD3
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: Vincent Hanquez <vincent@snarc.org>
stability: experimental
homepage: http://github.com/vincenthz/hs-tls
package-url:
description: Native Haskell TLS and SSL protocol implementation for server and client.
             .
             This provides a high-level implementation of a sensitive security protocol,
             eliminating a common set of security issues through the use of the advanced
             type system, high level constructions and common Haskell features.
             .
             Currently implement the SSL3.0, TLS1.0, TLS1.1 and TLS1.2 protocol,
             with only RSA supported for Key Exchange.
             .
             Only core protocol available here, have a look at the
             <http://hackage.haskell.org/package/tls-extra/> package for default
             ciphers, compressions and certificates functions.
category: Network
author: Vincent Hanquez <vincent@snarc.org>
pkgpath: security/hs-tls
exposed: True
exposed-modules: Network.TLS Network.TLS.Cipher
                 Network.TLS.Compression Network.TLS.Internal
hidden-modules: Network.TLS.Cap Network.TLS.Struct Network.TLS.MAC
                Network.TLS.Core Network.TLS.Crypto Network.TLS.Packet
                Network.TLS.Record Network.TLS.State Network.TLS.Sending
                Network.TLS.Receiving Network.TLS.Util Network.TLS.Wire
import-dirs: /usr/local/lib/ghc/tls-0.8.1
library-dirs: /usr/local/lib/ghc/tls-0.8.1
hs-libraries: HStls-0.8.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.3.1.0-ee15f259a627d341af7c80a17e8b0e66
         bytestring-0.9.1.10-4e62762ee9b2a5d0cc5bc2fbaaeefd53
         cereal-0.3.0.0-25883d7c37e4efd7c4c2505739809299
         certificate-0.9.5-96d62ae9a843cdc29d4e49d0af0794fe
         crypto-api-0.8-43c4c4e96d2c0015b8cc766a3b046148
         cryptocipher-0.2.8-04893561f254bee9c139cecb27e09f0f
         cryptohash-0.7.0-dc0d7d8cfda43bdf332b9956a1db4f0b
         mtl-2.0.1.0-3e464329054b7660133198d73c31aca5
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-tls-0.8.1/html/tls.haddock
haddock-html: /usr/local/share/doc/hs-tls-0.8.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
