#!/bin/sh
echo 'name: semigroupoids
version: 1.2.6
id: semigroupoids-1.2.6-cbcd834dea851f60eef0b73e55c092e8

license: BSD3
copyright: Copyright (C) 2011 Edward A. Kmett
maintainer: Edward A. Kmett <ekmett@gmail.com>
stability: provisional
homepage: http://github.com/ekmett/semigroupoids
package-url:
description: Provides a wide array of semigroupoids and operations for working with semigroupds.
             .
             A Semigroupoid is a Category without the requirement of identity arrows for every object in the category.
             .
             When working with comonads you often have the @\<*\>@ portion of an @Applicative@, but
             not the @pure@. This was captured in Uustalu and Vene'\''s \"Essence of Dataflow Programming\"
             in the form of the @ComonadZip@ class in the days before @Applicative@. Apply provides a weaker invariant, but for the comonads used for data flow programming (found in the streams package), this invariant is preserved. Applicative function composition forms a semigroupoid.
             .
             Similarly many structures are nearly a comonad, but not quite, for instance lists provide a reasonable '\''extend'\'' operation in the form of '\''tails'\'', but do not always contain a value.
             .
             .
             Ideally the following relationships would hold:
             .
             > Traversable <---- Foldable <--- Functor ------> Alt ---------> Plus           Semigroupoid
             >      |               |            |                              |                  |
             >      v               v            v                              v                  v
             > Traversable1 <--- Foldable1     Apply --------> Applicative -> Alternative      Category
             >                                   |               |              |                  |
             >                                   v               v              v                  v
             >                                 Bind ---------> Monad -------> MonadPlus          Arrow
             >
             .
             Apply, Bind, and Extract give rise the Static, Kleisli and Cokleisli semigroupoids respectively.
             .
             This lets us remove many of the restrictions from various monad transformers
             as in many cases the binding operation or @\<*\>@ operation does not require them.
             .
             Finally, to work with these weaker structures it is beneficial to have containers
             that can provide stronger guarantees about their contents, so versions of '\''Traversable'\''
             and '\''Foldable'\'' that can be folded with just a '\''Semigroup'\'' are added.
category: Control, Comonads
author: Edward A. Kmett
pkgpath: devel/hs-semigroupoids
exposed: True
exposed-modules: Data.Functor.Alt Data.Functor.Apply
                 Data.Functor.Bind Data.Functor.Bind.Trans Data.Functor.Plus
                 Data.Semigroup.Foldable Data.Semigroup.Traversable
                 Data.Semigroupoid Data.Semigroupoid.Dual Data.Semigroupoid.Static
                 Data.Traversable.Instances
hidden-modules:
import-dirs: /usr/local/lib/ghc/semigroupoids-1.2.6
library-dirs: /usr/local/lib/ghc/semigroupoids-1.2.6
hs-libraries: HSsemigroupoids-1.2.6
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.3.1.0-ee15f259a627d341af7c80a17e8b0e66
         comonad-1.1.1.1-67b92efe3ad8147896121aba4cb1d3e3
         containers-0.4.0.0-f1307d32d8f4b51a1487c01f0997b6d9
         contravariant-0.1.2-cdcc33127a3ec6251ae107367a3bc327
         semigroups-0.8.3.2-5821c4dabfb3d3618c695ad160721521
         transformers-0.2.2.0-89265f646be3aed4f502cfc5eccd7c93
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-semigroupoids-1.2.6/html/semigroupoids.haddock
haddock-html: /usr/local/share/doc/hs-semigroupoids-1.2.6/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
