#!/bin/sh
echo 'name: hexpat
version: 0.19.5
id: hexpat-0.19.5-908dd2a40f83aac310306bcf7ad7e8e2

license: BSD3
copyright: (c) 2009 Doug Beardsley <mightybyte@gmail.com>,
           (c) 2009-2010 Stephen Blackheath <http://blacksapphire.com/antispam/>,
           (c) 2009 Gregory Collins,
           (c) 2008 Evan Martin <martine@danga.com>,
           (c) 2009 Matthew Pocock <matthew.pocock@ncl.ac.uk>,
           (c) 2007-2009 Galois Inc.,
           (c) 2010 Kevin Jardine
maintainer: http://blacksapphire.com/antispam/
stability: beta
homepage: http://haskell.org/haskellwiki/Hexpat/
package-url:
description: This package provides a general purpose Haskell XML library using Expat to
             do its parsing (<http://expat.sourceforge.net/> - a fast stream-oriented XML
             parser written in C).  It is extensible to any string type, with @String@,
             @ByteString@ and @Text@ provided out of the box.
             .
             Basic usage: Parsing a tree (/Tree/), formatting a tree (/Format/).
             Other features: Helpers for processing XML trees (/Proc/), trees annotated with
             XML source location (/Annotated/), extended XML trees with comments,
             processing instructions, etc (/Extended/), XML cursors (/Cursor/),
             SAX-style parse (/SAX/), and access to the low-level interface in case speed
             is paramount (/Internal.IO/).
             .
             The design goals are speed, speed, speed, interface simplicity and modularity.
             .
             For introduction and examples, see the /Text.XML.Expat.Tree/ module. For benchmarks,
             <http://haskell.org/haskellwiki/Hexpat/>
             .
             If you want to do interactive I\/O, an obvious option is to use lazy parsing
             with one of the lazy I\/O functions such as hGetContents.  However, this can be
             problematic in some applications because it doesn'\''t handle I\/O errors properly
             and can give no guarantee of timely resource cleanup.  In these cases, chunked
             I\/O is a better approach: Take a look at the /hexpat-iteratee/ package.
             .
             /IO/ is filed under /Internal/ because it'\''s low-level and most users won'\''t want
             it.  The other /Internal/ modules are re-exported by /Annotated/, /Tree/ and /Extended/,
             so you won'\''t need to import them directly.
             .
             Credits to Iavor Diatchki and the @xml@ (XML.Light) package for /Proc/ and /Cursor/.
             Thanks to the many contributors.
             .
             BOUND VS. UNBOUND THREADS: GHC (at least versions 6.12.X) will spawn threads
             if you call a safe FFI callback from an unbound thread.  This can get out of
             control in a busy application.  To avoid this, from version 0.19.1 we now delegate
             processing to a single worker thread if the calling thread is not bound.
             This essentially means that hexpat currently won'\''t exploit multicores very well.
             It also means that hexpat may be more efficient on threads spawned with forkOS
             (to give you a bound thread) rather than forkIO.
             .
             ChangeLog: 0.15 changes intended to fix a (rare) \"error: a C finalizer called back into Haskell.\"
             that seemed only to happen only on ghc6.12.X; 0.15.1 Fix broken Annotated parse;
             0.16 switch from mtl to transformers; 0.17 fix mapNodeContainer & rename some things.;
             0.18 rename defaultEncoding to overrideEncoding. 0.18.3 formatG and indent were demanding list
             items more than once (inefficient in chunked processing); 0.19 add Extended.hs;
             0.19.1 fix a memory leak introduced in 0.19, delegate parsing to bound thread
             if unbound (see note above); 0.19.2 include expat source code so \'\''cabal install\'\'' just works
             on Linux, Mac and Windows (thanks Jacob Stanley); 0.19.3 fix misconfiguration of expat
             which broke entity parsing; 0.19.4 bump version constraint for text; 0.19.5 bump text
             to < 0.12 and fix text-0.10.0.1 breakage.
category: XML
author: Stephen Blackheath [blackh] (the primary author),
        Doug Beardsley,
        Gregory Collins,
        Evan Martin (who started the project),
        Matthew Pocock [drdozer],
        Kevin Jardine,
        Jacob Stanley
pkgpath: textproc/hs-hexpat
exposed: True
exposed-modules: Text.XML.Expat.Annotated Text.XML.Expat.Cursor
                 Text.XML.Expat.Extended Text.XML.Expat.Format Text.XML.Expat.IO
                 Text.XML.Expat.Namespaced Text.XML.Expat.NodeClass
                 Text.XML.Expat.Proc Text.XML.Expat.Qualified Text.XML.Expat.SAX
                 Text.XML.Expat.Tree Text.XML.Expat.Internal.DocumentClass
                 Text.XML.Expat.Internal.IO Text.XML.Expat.Internal.Namespaced
                 Text.XML.Expat.Internal.NodeClass Text.XML.Expat.Internal.Qualified
hidden-modules:
import-dirs: /usr/local/lib/ghc/hexpat-0.19.5
library-dirs: /usr/local/lib/ghc/hexpat-0.19.5
hs-libraries: HShexpat-0.19.5
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: List-0.4.0-209d97333ce2643398218dbbc036c7a6
         base-4.3.1.0-ee15f259a627d341af7c80a17e8b0e66
         bytestring-0.9.1.10-4e62762ee9b2a5d0cc5bc2fbaaeefd53
         containers-0.4.0.0-f1307d32d8f4b51a1487c01f0997b6d9
         deepseq-1.1.0.2-ce16381c4a634f8997917e5081cb960a
         extensible-exceptions-0.1.1.2-d8c5b906654260efd7249f497d17a831
         text-0.11.1.5-a9f0a532672121c1439a824b6891e297
         transformers-0.2.2.0-89265f646be3aed4f502cfc5eccd7c93
         utf8-string-0.3.6-131bec5ed6c825184d560515f17820d3
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-hexpat-0.19.5/html/hexpat.haddock
haddock-html: /usr/local/share/doc/hs-hexpat-0.19.5/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
