#!/bin/sh
echo 'name: enumerator
version: 0.4.14
id: enumerator-0.4.14-63fedf341c69a69125c64fd58230de7c

license: MIT
copyright: Copyright (c) John Millikin 2010-2011
maintainer: jmillikin@gmail.com
stability: experimental
homepage: https://john-millikin.com/software/enumerator/
package-url:
description: Typical buffer&#x2013;based incremental I/O is based around a single loop,
             which reads data from some source (such as a socket or file), transforms
             it, and generates one or more outputs (such as a line count, HTTP
             responses, or modified file). Although efficient and safe, these loops are
             all single&#x2013;purpose; it is difficult or impossible to compose
             buffer&#x2013;based processing loops.
             .
             Haskell&#x2019;s concept of &#x201C;lazy I/O&#x201D; allows pure code to
             operate on data from an external source. However, lazy I/O has several
             shortcomings. Most notably, resources such as memory and file handles can
             be retained for arbitrarily long periods of time, causing unpredictable
             performance and error conditions.
             .
             Enumerators are an efficient, predictable, and safe alternative to lazy
             I/O. Discovered by Oleg Kiselyov, they allow large datasets to be processed
             in near&#x2013;constant space by pure code. Although somewhat more complex
             to write, using enumerators instead of lazy I/O produces more correct
             programs.
             .
             This library contains an enumerator implementation for Haskell, designed to
             be both simple and efficient. Three core types are defined, along with
             numerous helper functions:
             .
             * /Iteratee/: Data sinks, analogous to left folds. Iteratees consume
             a sequence of /input/ values, and generate a single /output/ value.
             Many iteratees are designed to perform side effects (such as printing to
             @stdout@), so they can also be used as monad transformers.
             .
             * /Enumerator/: Data sources, which generate input sequences. Typical
             enumerators read from a file handle, socket, random number generator, or
             other external stream. To operate, enumerators are passed an iteratee, and
             provide that iteratee with input until either the iteratee has completed its
             computation, or EOF.
             .
             * /Enumeratee/: Data transformers, which operate as both enumerators and
             iteratees. Enumeratees read from an /outer/ enumerator, and provide the
             transformed data to an /inner/ iteratee.
category: Data, Enumerator
author: John Millikin <jmillikin@gmail.com>
pkgpath: devel/hs-enumerator
exposed: True
exposed-modules: Data.Enumerator Data.Enumerator.Binary
                 Data.Enumerator.Text Data.Enumerator.List Data.Enumerator.IO
hidden-modules: Data.Enumerator.Util
import-dirs: /usr/local/lib/ghc/enumerator-0.4.14
library-dirs: /usr/local/lib/ghc/enumerator-0.4.14
hs-libraries: HSenumerator-0.4.14
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.3.1.0-ee15f259a627d341af7c80a17e8b0e66
         bytestring-0.9.1.10-4e62762ee9b2a5d0cc5bc2fbaaeefd53
         containers-0.4.0.0-f1307d32d8f4b51a1487c01f0997b6d9
         text-0.11.1.5-a9f0a532672121c1439a824b6891e297
         transformers-0.2.2.0-89265f646be3aed4f502cfc5eccd7c93
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-enumerator-0.4.14/html/enumerator.haddock
haddock-html: /usr/local/share/doc/hs-enumerator-0.4.14/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
