/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.relaxng;

import gnu.xml.stream.XMLParser;
import gnu.xml.validation.relaxng.AnyNameNameClass;
import gnu.xml.validation.relaxng.AttributePattern;
import gnu.xml.validation.relaxng.ChoiceNameClass;
import gnu.xml.validation.relaxng.ChoicePattern;
import gnu.xml.validation.relaxng.DataPattern;
import gnu.xml.validation.relaxng.Define;
import gnu.xml.validation.relaxng.ElementPattern;
import gnu.xml.validation.relaxng.EmptyPattern;
import gnu.xml.validation.relaxng.Grammar;
import gnu.xml.validation.relaxng.GrammarException;
import gnu.xml.validation.relaxng.GroupPattern;
import gnu.xml.validation.relaxng.InterleavePattern;
import gnu.xml.validation.relaxng.ListPattern;
import gnu.xml.validation.relaxng.NSNameNameClass;
import gnu.xml.validation.relaxng.NameClass;
import gnu.xml.validation.relaxng.NameNameClass;
import gnu.xml.validation.relaxng.NotAllowedPattern;
import gnu.xml.validation.relaxng.OneOrMorePattern;
import gnu.xml.validation.relaxng.Param;
import gnu.xml.validation.relaxng.Pattern;
import gnu.xml.validation.relaxng.RefPattern;
import gnu.xml.validation.relaxng.TextPattern;
import gnu.xml.validation.relaxng.ValuePattern;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.DatatypeLibrary;
import org.relaxng.datatype.helpers.DatatypeLibraryLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

class FullSyntaxBuilder {
    static final Map VOCABULARY = new HashMap();
    static final Set STRIPPED_ATTRIBUTES = new HashSet();
    static final Set PATTERN_ELEMENTS = new HashSet();
    private Set urls;
    private int refCount;
    private Map datatypeLibraries;

    static {
        Set<String> elementAttrs = Collections.singleton("name");
        HashSet dataAttrs = new HashSet();
        dataAttrs.add("type");
        dataAttrs.add("datatypeLibrary");
        HashSet valueAttrs = new HashSet();
        valueAttrs.add("type");
        valueAttrs.add("datatypeLibrary");
        valueAttrs.add("ns");
        Set<String> externalAttrs = Collections.singleton("href");
        Set<String> startAttrs = Collections.singleton("combine");
        HashSet defineAttrs = new HashSet();
        defineAttrs.add("name");
        defineAttrs.add("combine");
        Set<String> nsAttrs = Collections.singleton("ns");
        VOCABULARY.put("element", elementAttrs);
        VOCABULARY.put("attribute", elementAttrs);
        VOCABULARY.put("group", Collections.EMPTY_SET);
        VOCABULARY.put("interleave", Collections.EMPTY_SET);
        VOCABULARY.put("choice", Collections.EMPTY_SET);
        VOCABULARY.put("optional", Collections.EMPTY_SET);
        VOCABULARY.put("zeroOrMore", Collections.EMPTY_SET);
        VOCABULARY.put("oneOrMore", Collections.EMPTY_SET);
        VOCABULARY.put("list", Collections.EMPTY_SET);
        VOCABULARY.put("mixed", Collections.EMPTY_SET);
        VOCABULARY.put("ref", elementAttrs);
        VOCABULARY.put("parentRef", elementAttrs);
        VOCABULARY.put("empty", Collections.EMPTY_SET);
        VOCABULARY.put("text", Collections.EMPTY_SET);
        VOCABULARY.put("value", valueAttrs);
        VOCABULARY.put("data", dataAttrs);
        VOCABULARY.put("notAllowed", Collections.EMPTY_SET);
        VOCABULARY.put("externalRef", externalAttrs);
        VOCABULARY.put("grammar", Collections.EMPTY_SET);
        VOCABULARY.put("param", elementAttrs);
        VOCABULARY.put("except", Collections.EMPTY_SET);
        VOCABULARY.put("div", Collections.EMPTY_SET);
        VOCABULARY.put("include", externalAttrs);
        VOCABULARY.put("start", startAttrs);
        VOCABULARY.put("define", defineAttrs);
        VOCABULARY.put("name", nsAttrs);
        VOCABULARY.put("anyName", Collections.EMPTY_SET);
        VOCABULARY.put("nsName", nsAttrs);
        STRIPPED_ATTRIBUTES.add("name");
        STRIPPED_ATTRIBUTES.add("type");
        STRIPPED_ATTRIBUTES.add("combine");
        PATTERN_ELEMENTS.add("element");
        PATTERN_ELEMENTS.add("attribute");
        PATTERN_ELEMENTS.add("group");
        PATTERN_ELEMENTS.add("interleave");
        PATTERN_ELEMENTS.add("choice");
        PATTERN_ELEMENTS.add("optional");
        PATTERN_ELEMENTS.add("zeroOrMore");
        PATTERN_ELEMENTS.add("oneOrMore");
        PATTERN_ELEMENTS.add("list");
        PATTERN_ELEMENTS.add("mixed");
        PATTERN_ELEMENTS.add("ref");
        PATTERN_ELEMENTS.add("parentRef");
        PATTERN_ELEMENTS.add("empty");
        PATTERN_ELEMENTS.add("text");
        PATTERN_ELEMENTS.add("value");
        PATTERN_ELEMENTS.add("data");
        PATTERN_ELEMENTS.add("notAllowed");
        PATTERN_ELEMENTS.add("externalRef");
        PATTERN_ELEMENTS.add("grammar");
    }

    FullSyntaxBuilder() {
    }

    synchronized Grammar parse(Document doc) throws IOException {
        Node parent;
        this.urls = new HashSet();
        this.refCount = 1;
        doc.normalizeDocument();
        this.transform(doc);
        Element p = doc.getDocumentElement();
        Element grammar = doc.createElementNS("http://relaxng.org/ns/structure/1.0", "grammar");
        Element start = doc.createElementNS("http://relaxng.org/ns/structure/1.0", "start");
        doc.removeChild(p);
        doc.appendChild(grammar);
        grammar.appendChild(start);
        start.appendChild(p);
        this.transformGrammar(grammar, p);
        Element define = FullSyntaxBuilder.getNextSiblingElement(start);
        while (define != null) {
            Element next = FullSyntaxBuilder.getNextSiblingElement(define);
            String name = define.getAttribute("new-name");
            if (name != null) {
                define.setAttribute("name", name);
                define.removeAttribute("new-name");
            } else {
                grammar.removeChild(define);
            }
            define = next;
        }
        HashSet allDefines = new HashSet();
        HashSet reachableDefines = new HashSet();
        this.getDefines(allDefines, grammar, grammar, false);
        this.getDefines(reachableDefines, grammar, start, true);
        allDefines.removeAll(reachableDefines);
        for (Element d : allDefines) {
            Node parent2 = d.getParentNode();
            parent2.removeChild(d);
        }
        HashSet elements = new HashSet();
        this.getElements(elements, grammar, grammar);
        for (Element element : elements) {
            parent = element.getParentNode();
            if (reachableDefines.contains(parent)) continue;
            define = doc.createElementNS("http://relaxng.org/ns/structure/1.0", "define");
            Element ref = doc.createElementNS("http://relaxng.org/ns/structure/1.0", "ref");
            String name = this.createRefName();
            define.setAttribute("name", name);
            ref.setAttribute("name", name);
            parent.insertBefore(ref, element);
            define.appendChild(element);
            grammar.appendChild(define);
            reachableDefines.add(define);
        }
        Iterator i = reachableDefines.iterator();
        while (i.hasNext()) {
            Element d = (Element)i.next();
            Element child = FullSyntaxBuilder.getFirstChildElement(d);
            if (child == null || !"element".equals(child.getLocalName())) continue;
            i.remove();
        }
        this.expandRefs(reachableDefines, grammar);
        for (Element d : reachableDefines) {
            parent = d.getParentNode();
            parent.removeChild(d);
        }
        this.transform2(p);
        Grammar ret = this.parseGrammar(grammar);
        this.datatypeLibraries = null;
        return ret;
    }

    private void getDefines(Set defines, Element grammar, Element node2, boolean followRefs) {
        String elementName = node2.getLocalName();
        if ("define".equals(elementName)) {
            defines.add(node2);
        } else if ("ref".equals(elementName) && followRefs) {
            String rname = node2.getAttribute("name");
            Element define = FullSyntaxBuilder.getFirstChildElement(grammar);
            define = FullSyntaxBuilder.getNextSiblingElement(define);
            while (define != null) {
                String dname = define.getAttribute("name");
                if (rname.equals(dname)) {
                    this.getDefines(defines, grammar, node2, followRefs);
                    break;
                }
                define = FullSyntaxBuilder.getNextSiblingElement(define);
            }
        }
        Element child = FullSyntaxBuilder.getFirstChildElement(node2);
        while (child != null) {
            this.getDefines(defines, grammar, child, followRefs);
            child = FullSyntaxBuilder.getNextSiblingElement(child);
        }
    }

    private void getElements(Set elements, Element grammar, Element node2) {
        String elementName = node2.getLocalName();
        if ("element".equals(elementName)) {
            elements.add(node2);
        }
        Element child = FullSyntaxBuilder.getFirstChildElement(node2);
        while (child != null) {
            this.getElements(elements, grammar, child);
            child = FullSyntaxBuilder.getNextSiblingElement(child);
        }
    }

    private void expandRefs(Set defines, Element node2) throws GrammarException {
        String elementName = node2.getLocalName();
        if ("ref".equals(elementName)) {
            String rname = node2.getAttribute("name");
            for (Element define : defines) {
                String dname = define.getAttribute("name");
                if (!rname.equals(dname)) continue;
                Element child = FullSyntaxBuilder.getFirstChildElement(define);
                this.forbidRefs(child, rname);
                Element refChild = (Element)child.cloneNode(true);
                Node parent = node2.getParentNode();
                parent.insertBefore(refChild, node2);
                parent.removeChild(node2);
                node2 = refChild;
                break;
            }
        }
        Element child = FullSyntaxBuilder.getFirstChildElement(node2);
        while (child != null) {
            this.expandRefs(defines, child);
            child = FullSyntaxBuilder.getNextSiblingElement(child);
        }
    }

    private void forbidRefs(Element node2, String name) throws GrammarException {
        String rname;
        String elementName = node2.getLocalName();
        if ("ref".equals(elementName) && name.equals(rname = node2.getAttribute("name"))) {
            throw new GrammarException("cannot expand ref with name '" + name + "' due to circularity");
        }
        Element child = FullSyntaxBuilder.getFirstChildElement(node2);
        while (child != null) {
            this.forbidRefs(child, name);
            child = FullSyntaxBuilder.getNextSiblingElement(child);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void transform(Node node) throws IOException {
        parent = node.getParentNode();
        switch (node.getNodeType()) {
            case 1: {
                elementNs = node.getNamespaceURI();
                elementName = node.getLocalName();
                if (!"http://relaxng.org/ns/structure/1.0".equals(elementNs) || !FullSyntaxBuilder.VOCABULARY.containsKey(elementName)) {
                    parent.removeChild(node);
                    break;
                }
                allowedAttrs = (Set)FullSyntaxBuilder.VOCABULARY.get(elementName);
                attrs = node.getAttributes();
                len = attrs.getLength();
                i = len - 1;
                while (i >= 0) {
                    attr = attrs.item(i);
                    attrNs = attr.getNamespaceURI();
                    attrName = attr.getLocalName();
                    if (!"http://www.w3.org/2000/xmlns/".equals(attrNs)) {
                        if (!"http://relaxng.org/ns/structure/1.0".equals(attrNs) && attrNs != null || !allowedAttrs.contains(attrName)) {
                            attrs.removeNamedItemNS(attrNs, attrName);
                        } else if (FullSyntaxBuilder.STRIPPED_ATTRIBUTES.contains(attrName)) {
                            attr.setNodeValue(attr.getNodeValue().trim());
                        } else if ("datatypeLibrary".equals(attrName)) {
                            dl = attr.getNodeValue();
                            attr.setNodeValue(FullSyntaxBuilder.escapeURL(dl));
                        } else if ("href".equals(attrName)) {
                            href = attr.getNodeValue();
                            href = XMLParser.absolutize(node.getBaseURI(), FullSyntaxBuilder.escapeURL(href));
                            attr.setNodeValue(href);
                        }
                    }
                    --i;
                }
                if (!"data".equals(elementName) && !"value".equals(elementName)) ** GOTO lbl52
                element = (Element)node;
                dl = element.getAttribute("datatypeLibrary");
                if (dl == null) {
                    p = parent;
                    while (dl == null && p != null && p.getNodeType() == 1) {
                        dl = ((Element)p).getAttribute("datatypeLibrary");
                        p = p.getParentNode();
                    }
                    if (dl == null) {
                        dl = "";
                    }
                    element.setAttribute("datatypeLibrary", dl);
                }
                if ("value".equals(elementName) && (type = element.getAttribute("type")) == null) {
                    element.setAttribute("type", "token");
                    element.setAttribute("datatypeLibrary", "");
                }
                ** GOTO lbl337
lbl52:
                // 1 sources

                if ("externalRef".equals(elementName)) {
                    externalRef = (Element)node;
                    href = externalRef.getAttribute("href");
                    if (this.urls.contains(href)) {
                        throw new GrammarException("recursive href");
                    }
                    this.urls.add(href);
                    element = FullSyntaxBuilder.resolve(href);
                    eNs = element.getNamespaceURI();
                    eName = element.getLocalName();
                    if (!"http://relaxng.org/ns/structure/1.0".equals(eNs) && eNs != null || !FullSyntaxBuilder.PATTERN_ELEMENTS.contains(eName)) {
                        throw new GrammarException("externally referenced element is not a pattern");
                    }
                    this.transform(element);
                    this.urls.remove(href);
                    ns = element.getAttribute("ns");
                    if (ns != null) {
                        element.setAttribute("ns", externalRef.getAttribute("ns"));
                    }
                    element = (Element)externalRef.getOwnerDocument().importNode(element, true);
                    parent.replaceChild(element, externalRef);
                    return;
                }
                if ("include".equals(elementName)) {
                    include = (Element)node;
                    href = include.getAttribute("href");
                    if (this.urls.contains(href)) {
                        throw new GrammarException("recursive href");
                    }
                    this.urls.add(href);
                    element = FullSyntaxBuilder.resolve(href);
                    eNs = element.getNamespaceURI();
                    eName = element.getLocalName();
                    if (!"http://relaxng.org/ns/structure/1.0".equals(eNs) && eNs != null || !"grammar".equals(eName)) {
                        throw new GrammarException("included element is not a grammar");
                    }
                    this.transform(element);
                    this.urls.remove(href);
                    includeComponents = this.getComponents(include);
                    grammarComponents = this.getComponents(element);
                    for (Element comp : includeComponents) {
                        compName = comp.getLocalName();
                        if ("start".equals(compName)) {
                            found = false;
                            for (Element c2 : grammarComponents) {
                                if (!"start".equals(c2.getLocalName())) continue;
                                c2.getParentNode().removeChild(c2);
                                found = true;
                            }
                            if (found) continue;
                            throw new GrammarException("no start component in included grammar");
                        }
                        if (!"define".equals(compName)) continue;
                        name = comp.getAttribute("name");
                        found = false;
                        for (Element c2 : grammarComponents) {
                            if (!"define".equals(c2.getLocalName()) || !name.equals(c2.getAttribute("name"))) continue;
                            c2.getParentNode().removeChild(c2);
                            found = true;
                        }
                        if (found) continue;
                        throw new GrammarException("no define component with name '" + name + "' in included grammar");
                    }
                    doc = include.getOwnerDocument();
                    includeDiv = doc.createElementNS("http://relaxng.org/ns/structure/1.0", "div");
                    grammarDiv = doc.createElementNS("http://relaxng.org/ns/structure/1.0", "div");
                    element = (Element)doc.importNode(element, true);
                    ctx = element.getFirstChild();
                    while (ctx != null) {
                        next = ctx.getNextSibling();
                        grammarDiv.appendChild(ctx);
                        ctx = next;
                    }
                    includeDiv.appendChild(grammarDiv);
                    ctx = include.getFirstChild();
                    while (ctx != null) {
                        next = ctx.getNextSibling();
                        includeDiv.appendChild(ctx);
                        ctx = next;
                    }
                    parent.replaceChild(includeDiv, include);
                    this.transform(includeDiv);
                    return;
                }
                if (!"attribute".equals(elementName) && !"element".equals(elementName)) ** GOTO lbl178
                element = (Element)node;
                name = element.getAttribute("name");
                if (name != null) {
                    doc = element.getOwnerDocument();
                    n = doc.createElementNS("http://relaxng.org/ns/structure/1.0", "name");
                    n.appendChild(doc.createTextNode(name));
                    first = element.getFirstChild();
                    if (first != null) {
                        element.insertBefore(n, first);
                    } else {
                        element.appendChild(n);
                    }
                    if ("attribute".equals(elementName) && (ns = element.getAttribute("ns")) != null) {
                        n.setAttribute("ns", ns);
                        element.removeAttribute("ns");
                    }
                    element.removeAttribute("name");
                }
                if (!"attribute".equals(elementName)) ** GOTO lbl164
                if (this.getComponents(node).size() == 1) {
                    doc = node.getOwnerDocument();
                    text = doc.createElementNS("http://relaxng.org/ns/structure/1.0", "text");
                    node.appendChild(text);
                }
                ** GOTO lbl337
lbl164:
                // 1 sources

                if (node.getChildNodes().getLength() <= 2) ** GOTO lbl337
                doc = node.getOwnerDocument();
                child = doc.createElementNS("http://relaxng.org/ns/structure/1.0", "group");
                ctx = FullSyntaxBuilder.getFirstChildElement(node);
                ctx = FullSyntaxBuilder.getNextSiblingElement(ctx);
                while (ctx != null) {
                    next /* !! */  = FullSyntaxBuilder.getNextSiblingElement(ctx);
                    child.appendChild(ctx);
                    ctx = next /* !! */ ;
                }
                node.appendChild(child);
                ** GOTO lbl337
lbl178:
                // 1 sources

                if ("div".equals(elementName)) {
                    ctx = node.getFirstChild();
                    while (ctx != null) {
                        next = ctx.getNextSibling();
                        parent.insertBefore(ctx, node);
                        this.transform(ctx);
                        ctx = next;
                    }
                    parent.removeChild(node);
                    return;
                }
                if (!"mixed".equals(elementName)) ** GOTO lbl210
                FullSyntaxBuilder.transformToOneChildElement(node, "group");
                doc = node.getOwnerDocument();
                interleave = doc.createElementNS("http://relaxng.org/ns/structure/1.0", "interleave");
                ctx = node.getFirstChild();
                while (ctx != null) {
                    next = ctx.getNextSibling();
                    interleave.appendChild(ctx);
                    ctx = next;
                }
                text = doc.createElementNS("http://relaxng.org/ns/structure/1.0", "text");
                interleave.appendChild(text);
                parent.insertBefore(interleave, node);
                parent.removeChild(node);
                node = interleave;
                ** GOTO lbl337
lbl210:
                // 1 sources

                if (!"optional".equals(elementName)) ** GOTO lbl230
                FullSyntaxBuilder.transformToOneChildElement(node, "group");
                doc = node.getOwnerDocument();
                choice = doc.createElementNS("http://relaxng.org/ns/structure/1.0", "choice");
                ctx = node.getFirstChild();
                while (ctx != null) {
                    next = ctx.getNextSibling();
                    choice.appendChild(ctx);
                    ctx = next;
                }
                empty = doc.createElementNS("http://relaxng.org/ns/structure/1.0", "empty");
                choice.appendChild(empty);
                parent.insertBefore(choice, node);
                parent.removeChild(node);
                node = choice;
                ** GOTO lbl337
lbl230:
                // 1 sources

                if (!"zeroOrMore".equals(elementName)) ** GOTO lbl253
                FullSyntaxBuilder.transformToOneChildElement(node, "group");
                doc = node.getOwnerDocument();
                choice = doc.createElementNS("http://relaxng.org/ns/structure/1.0", "choice");
                oneOrMore = doc.createElementNS("http://relaxng.org/ns/structure/1.0", "oneOrMore");
                ctx = node.getFirstChild();
                while (ctx != null) {
                    next = ctx.getNextSibling();
                    oneOrMore.appendChild(ctx);
                    ctx = next;
                }
                empty = doc.createElementNS("http://relaxng.org/ns/structure/1.0", "empty");
                choice.appendChild(oneOrMore);
                choice.appendChild(empty);
                parent.insertBefore(choice, node);
                parent.removeChild(node);
                node = choice;
                ** GOTO lbl337
lbl253:
                // 1 sources

                if (!"list".equals(elementName) && !"oneOrMore".equals(elementName) && !"define".equals(elementName)) ** GOTO lbl256
                FullSyntaxBuilder.transformToOneChildElement(node, "group");
                ** GOTO lbl337
lbl256:
                // 1 sources

                if (!"except".equals(elementName)) ** GOTO lbl270
                FullSyntaxBuilder.transformToOneChildElement(node, "choice");
                parentName = parent.getLocalName();
                if (!"anyName".equals(parentName)) ** GOTO lbl262
                FullSyntaxBuilder.forbidDescendants(node, Collections.singleton("anyName"));
                ** GOTO lbl337
lbl262:
                // 1 sources

                if (!"nsName".equals(parentName)) ** GOTO lbl337
                names = new HashSet<T>();
                names.add("nsName");
                names.add("anyName");
                FullSyntaxBuilder.forbidDescendants(node, names);
                ** GOTO lbl337
lbl270:
                // 1 sources

                if ("choice".equals(elementName) || "group".equals(elementName) || "interleave".equals(elementName)) {
                    ctx = FullSyntaxBuilder.getFirstChildElement(node);
                    next = FullSyntaxBuilder.getNextSiblingElement(ctx);
                    if (next == null) {
                        parent.insertBefore(ctx, node);
                        parent.removeChild(node);
                        this.transform(ctx);
                        return;
                    }
                    next2 = FullSyntaxBuilder.getNextSiblingElement(next);
                    if (next2 != null) {
                        doc = node.getOwnerDocument();
                        child = doc.createElementNS("http://relaxng.org/ns/structure/1.0", elementName);
                        child.appendChild(ctx);
                        child.appendChild(next);
                        node.insertBefore(next2, child);
                        this.transform(node);
                    }
                } else if ("grammar".equals(elementName)) {
                    combine = null;
                    nodes = new LinkedList<T>();
                    ctx = node.getFirstChild();
                    while (ctx != null) {
                        next = ctx.getNextSibling();
                        if ("start".equals(ctx.getLocalName())) {
                            c = ((Element)ctx).getAttribute("combine");
                            if (combine != null && !combine.equals(c)) {
                                throw new GrammarException("multiple start elements but no combine attribute");
                            }
                            combine = c;
                            nodes.add(ctx);
                        }
                        ctx = next;
                    }
                    if (!nodes.isEmpty()) {
                        FullSyntaxBuilder.combineNodes(node, combine, "start", nodes);
                    }
                    defines = new HashMap<String, List<T>>();
                    defineCombines = new HashMap<String, String>();
                    ctx = node.getFirstChild();
                    while (ctx != null) {
                        next /* !! */  = ctx.getNextSibling();
                        if ("define".equals(ctx.getLocalName())) {
                            name = ((Element)ctx).getAttribute("name");
                            combine = (String)defineCombines.get(name);
                            c = ((Element)ctx).getAttribute("combine");
                            if (combine != null && !combine.equals(c)) {
                                throw new GrammarException("multiple define elements with name '" + name + "' but no " + "combine attribute");
                            }
                            defineCombines.put(name, c);
                            nodes = (List)defines.get(name);
                            if (nodes == null) {
                                nodes = new LinkedList<T>();
                                defines.put(name, nodes);
                            }
                            nodes.add(ctx);
                        }
                        ctx = next /* !! */ ;
                    }
                    for (String name : defines.keySet()) {
                        combine = (String)defineCombines.get(name);
                        nodes = (List)defines.get(name);
                        if (nodes.isEmpty()) continue;
                        FullSyntaxBuilder.combineNodes(node, combine, "define", nodes);
                    }
                }
lbl337:
                // 15 sources

                if (!"name".equals(elementName) && !"nsName".equals(elementName) && !"value".equals(elementName)) break;
                element = (Element)node;
                ns = element.getAttribute("ns");
                if (ns == null) {
                    ctx = parent;
                    while (ns == null && ctx != null && ctx.getNodeType() == 1) {
                        ns = ((Element)ctx).getAttribute("ns");
                        ctx = ctx.getParentNode();
                    }
                    element.setAttribute("ns", ns == null ? "" : ns);
                }
                if ("name".equals(elementName)) {
                    name = element.getTextContent();
                    ci = name.indexOf(58);
                    if (ci != -1) {
                        prefix = name.substring(0, ci);
                        element.setTextContent(name.substring(ci + 1));
                        ns = element.lookupNamespaceURI(prefix);
                        element.setAttribute("ns", ns == null ? "" : ns);
                    }
                    if (!FullSyntaxBuilder.isDescendantOfFirstChildOfAttribute(element) || !"".equals(element.getAttribute("ns")) || !"xmlns".equals(element.getTextContent())) break;
                    throw new GrammarException("name cannot be xmlns");
                }
                if (!"nsName".equals(elementName) || !FullSyntaxBuilder.isDescendantOfFirstChildOfAttribute(element) || !"http://www.w3.org/2000/xmlns".equals(element.getAttribute("ns"))) break;
                throw new GrammarException("nsName cannot be XMLNS URI");
            }
            case 3: 
            case 4: {
                parentName = parent.getLocalName();
                if ("name".equals(parentName)) {
                    node.setNodeValue(node.getNodeValue().trim());
                }
                if ("param".equals(parentName) || "value".equals(parentName) || !FullSyntaxBuilder.isWhitespace(node.getNodeValue())) break;
                parent.removeChild(node);
                break;
            }
            case 9: {
                break;
            }
            default: {
                parent.removeChild(node);
            }
        }
        ctx = node.getFirstChild();
        while (ctx != null) {
            next = ctx.getNextSibling();
            this.transform(ctx);
            ctx = next;
        }
    }

    private void transformGrammar(Node grammar, Node node2) throws GrammarException {
        if (node2.getNodeType() == 1) {
            String elementName = node2.getLocalName();
            if ("grammar".equals(elementName)) {
                this.handleRefs(grammar, node2, node2);
                Node start = null;
                Node ctx = node2.getFirstChild();
                while (ctx != null) {
                    Node next = ctx.getNextSibling();
                    String childName = ctx.getLocalName();
                    if ("define".equals(childName)) {
                        grammar.appendChild(ctx);
                    } else if ("start".equals(childName)) {
                        start = ctx;
                    }
                    ctx = next;
                }
                if (start == null) {
                    throw new GrammarException("no start element for grammar");
                }
                Element p = FullSyntaxBuilder.getFirstChildElement(start);
                Node parent = node2.getParentNode();
                parent.insertBefore(p, node2);
                parent.removeChild(node2);
                node2 = p;
            }
            Node ctx = node2.getFirstChild();
            while (ctx != null) {
                Node next = ctx.getNextSibling();
                this.transformGrammar(grammar, ctx);
                ctx = next;
            }
        }
    }

    private void handleRefs(Node grammar1, Node grammar2, Node node2) throws GrammarException {
        if (node2.getNodeType() == 1) {
            String elementName = node2.getLocalName();
            if ("ref".equals(elementName) || "parentRef".equals(elementName)) {
                String name;
                Node grammar = grammar2;
                if ("parentRef".equals(elementName)) {
                    grammar = grammar1;
                }
                if ((name = ((Element)node2).getAttribute("name")) != null) {
                    throw new GrammarException("no name attribute on " + elementName);
                }
                Node define = null;
                Node ctx = grammar.getFirstChild();
                while (define == null && ctx != null) {
                    String dname;
                    if ("define".equals(ctx.getLocalName()) && name.equals(dname = ((Element)ctx).getAttribute("name"))) {
                        define = ctx;
                    }
                    ctx = ctx.getNextSibling();
                }
                if (define == null) {
                    throw new GrammarException("no define for '" + name + "'");
                }
                name = ((Element)define).getAttribute("new-name");
                if (name == null) {
                    name = this.createRefName();
                    ((Element)define).setAttribute("new-name", name);
                }
                if ("parentRef".equals(elementName)) {
                    Document doc = node2.getOwnerDocument();
                    Element ref = doc.createElementNS("http://relaxng.org/ns/structure/1.0", "ref");
                    Node ctx2 = node2.getFirstChild();
                    while (ctx2 != null) {
                        Node next = ctx2.getNextSibling();
                        ref.appendChild(ctx2);
                        ctx2 = next;
                    }
                    Node parent = node2.getParentNode();
                    parent.insertBefore(ref, node2);
                    parent.removeChild(node2);
                    node2 = ref;
                }
                ((Element)node2).setAttribute("name", name);
            } else if ("grammar".equals(elementName)) {
                grammar1 = grammar2;
                grammar2 = node2;
            }
            Node ctx = node2.getFirstChild();
            while (ctx != null) {
                Node next = ctx.getNextSibling();
                this.handleRefs(grammar1, grammar2, ctx);
                ctx = next;
            }
        }
    }

    private String createRefName() {
        return "ref" + Integer.toString(this.refCount++);
    }

    private void transform2(Node node2) throws GrammarException {
        Node parent = node2.getParentNode();
        if (node2.getNodeType() == 1) {
            String parentName;
            String elementName = node2.getLocalName();
            if ("notAllowed".equals(elementName)) {
                parentName = parent.getLocalName();
                if ("attribute".equals(parentName) || "list".equals(parentName) || "group".equals(parentName) || "interleave".equals(parentName) || "oneOrMore".equals(parentName)) {
                    Node pp = parent.getParentNode();
                    pp.insertBefore(node2, parent);
                    pp.removeChild(parent);
                    this.transform2(node2);
                    return;
                }
                if ("choice".equals(parentName)) {
                    Element p1 = FullSyntaxBuilder.getFirstChildElement(parent);
                    Element p2 = FullSyntaxBuilder.getNextSiblingElement(p1);
                    if (p1 == null || p2 == null) {
                        throw new GrammarException("choice does not have two children");
                    }
                    String p1Name = p1.getLocalName();
                    String p2Name = p2.getLocalName();
                    Node pp = parent.getParentNode();
                    if ("notAllowed".equals(p1Name) && "notAllowed".equals(p2Name)) {
                        pp.insertBefore(p1, parent);
                        pp.removeChild(parent);
                        this.transform2(p1);
                        return;
                    }
                    if ("notAllowed".equals(p1Name)) {
                        pp.insertBefore(p2, parent);
                        pp.removeChild(parent);
                        this.transform2(p2);
                        return;
                    }
                    pp.insertBefore(p1, parent);
                    pp.removeChild(parent);
                    this.transform2(p1);
                    return;
                }
                if ("except".equals(parentName)) {
                    Node pp = parent.getParentNode();
                    pp.removeChild(parent);
                    return;
                }
            } else if ("empty".equals(elementName)) {
                parentName = parent.getLocalName();
                if ("group".equals(parentName) || "interleave".equals(parentName)) {
                    Element p1 = FullSyntaxBuilder.getFirstChildElement(parent);
                    Element p2 = FullSyntaxBuilder.getNextSiblingElement(p1);
                    if (p1 == null || p2 == null) {
                        throw new GrammarException(String.valueOf(parentName) + " does not have " + "two children");
                    }
                    String p1Name = p1.getLocalName();
                    String p2Name = p2.getLocalName();
                    Node pp = parent.getParentNode();
                    if ("empty".equals(p1Name) && "empty".equals(p2Name)) {
                        pp.insertBefore(p1, parent);
                        pp.removeChild(parent);
                        this.transform2(p1);
                        return;
                    }
                    if ("empty".equals(p1Name)) {
                        pp.insertBefore(p2, parent);
                        pp.removeChild(parent);
                        this.transform2(p2);
                        return;
                    }
                    pp.insertBefore(p1, parent);
                    pp.removeChild(parent);
                    this.transform2(p1);
                    return;
                }
                if ("choice".equals(parentName)) {
                    Element p1 = FullSyntaxBuilder.getFirstChildElement(parent);
                    Element p2 = FullSyntaxBuilder.getNextSiblingElement(p1);
                    if (p1 == null || p2 == null) {
                        throw new GrammarException(String.valueOf(parentName) + " does not have " + "two children");
                    }
                    String p1Name = p1.getLocalName();
                    String p2Name = p2.getLocalName();
                    Node pp = parent.getParentNode();
                    if ("empty".equals(p1Name) && "empty".equals(p2Name)) {
                        pp.insertBefore(p1, parent);
                        pp.removeChild(parent);
                        this.transform2(p1);
                        return;
                    }
                } else if ("oneOrMore".equals(parentName)) {
                    Node pp = parent.getParentNode();
                    pp.insertBefore(node2, parent);
                    pp.removeChild(parent);
                    this.transform2(node2);
                    return;
                }
            }
            Node ctx = node2.getFirstChild();
            while (ctx != null) {
                Node next = ctx.getNextSibling();
                this.transform2(ctx);
                ctx = next;
            }
        }
    }

    private static boolean isWhitespace(String text) {
        int len = text.length();
        int i = 0;
        while (i < len) {
            char c = text.charAt(i);
            if (c != ' ' && c != '\t' && c != '\n' && c != '\r') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static String escapeURL(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            RuntimeException e2 = new RuntimeException("UTF-8 is unsupported");
            e2.initCause(e);
            throw e2;
        }
    }

    private static Element resolve(String url) throws IOException {
        try {
            URL u = new URL(url);
            InputStream in = u.openStream();
            DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
            f.setNamespaceAware(true);
            f.setCoalescing(true);
            f.setExpandEntityReferences(true);
            f.setIgnoringComments(true);
            f.setIgnoringElementContentWhitespace(true);
            DocumentBuilder b = f.newDocumentBuilder();
            Document doc = b.parse(in, url);
            in.close();
            String fragment = u.getRef();
            if (fragment != null) {
                return doc.getElementById(fragment);
            }
            return doc.getDocumentElement();
        }
        catch (SAXException e) {
            IOException e2 = new IOException("error parsing included element");
            e2.initCause(e);
            throw e2;
        }
        catch (ParserConfigurationException e) {
            IOException e2 = new IOException("error parsing included element");
            e2.initCause(e);
            throw e2;
        }
    }

    private List getComponents(Node node2) {
        LinkedList ret = new LinkedList();
        Node ctx = node2.getFirstChild();
        while (ctx != null) {
            String ns;
            if (ctx.getNodeType() == 1 && ((ns = ctx.getNamespaceURI()) == null || ns.equals("http://relaxng.org/ns/structure/1.0"))) {
                String name = ctx.getLocalName();
                if ("div".equals(name)) {
                    ret.addAll(this.getComponents(ctx));
                } else if (VOCABULARY.containsKey(name)) {
                    ret.add(ctx);
                }
            }
            ctx = ctx.getNextSibling();
        }
        return ret;
    }

    private static void transformToOneChildElement(Node node2, String name) {
        if (node2.getChildNodes().getLength() < 2) {
            return;
        }
        Document doc = node2.getOwnerDocument();
        Element child = doc.createElementNS("http://relaxng.org/ns/structure/1.0", name);
        Element ctx = FullSyntaxBuilder.getFirstChildElement(node2);
        while (ctx != null) {
            Element next = FullSyntaxBuilder.getNextSiblingElement(ctx);
            child.appendChild(ctx);
            ctx = next;
        }
        node2.appendChild(child);
    }

    private static Element getFirstChildElement(Node node2) {
        Node ctx = node2.getFirstChild();
        while (ctx != null && ctx.getNodeType() != 1) {
            ctx = ctx.getNextSibling();
        }
        return (Element)ctx;
    }

    private static Element getNextSiblingElement(Node node2) {
        Node ctx = node2.getNextSibling();
        while (ctx != null && ctx.getNodeType() != 1) {
            ctx = ctx.getNextSibling();
        }
        return (Element)ctx;
    }

    private static void forbidDescendants(Node node2, Set names) throws GrammarException {
        Node ctx = node2.getFirstChild();
        while (ctx != null) {
            String ns = ctx.getNamespaceURI();
            if ("http://relaxng.org/ns/structure/1.0".equals(ns)) {
                String name = ctx.getLocalName();
                if (names.contains(name)) {
                    throw new GrammarException("name not allowed: " + name);
                }
                FullSyntaxBuilder.forbidDescendants(ctx, names);
            }
            ctx = ctx.getNextSibling();
        }
    }

    private static boolean isDescendantOfFirstChildOfAttribute(Node node2) {
        Node child = node2;
        Node parent = node2.getParentNode();
        while (parent != null && !"attribute".equals(parent.getLocalName())) {
            child = parent;
            parent = child.getParentNode();
        }
        if (parent == null) {
            return false;
        }
        Element firstChild = FullSyntaxBuilder.getFirstChildElement(parent);
        return firstChild == child;
    }

    private static void combineNodes(Node node2, String combine, String name, List nodes) {
        Document doc = node2.getOwnerDocument();
        Element child = doc.createElementNS("http://relaxng.org/ns/structure/1.0", name);
        Element combineNode = doc.createElementNS("http://relaxng.org/ns/structure/1.0", combine);
        child.appendChild(combineNode);
        boolean inserted = false;
        for (Node startNode : nodes) {
            if (!inserted) {
                node2.insertBefore(child, startNode);
                inserted = true;
            }
            Node ctx = startNode.getFirstChild();
            while (ctx != null) {
                Node next = ctx.getNextSibling();
                combineNode.appendChild(ctx);
                ctx = next;
            }
            node2.removeChild(startNode);
        }
    }

    Grammar parseGrammar(Element node2) throws GrammarException {
        this.checkName(node2, "grammar");
        Grammar grammar = new Grammar();
        Element start = FullSyntaxBuilder.getFirstChildElement(node2);
        grammar.start = this.parsePattern(FullSyntaxBuilder.getFirstChildElement(start));
        Element define = FullSyntaxBuilder.getNextSiblingElement(start);
        while (define != null) {
            grammar.defines.add(this.parseDefine(define));
            define = FullSyntaxBuilder.getNextSiblingElement(define);
        }
        return grammar;
    }

    Define parseDefine(Element node2) throws GrammarException {
        this.checkName(node2, "define");
        Define define = new Define();
        define.name = node2.getAttribute("name");
        define.element = this.parseElement(FullSyntaxBuilder.getFirstChildElement(node2));
        return define;
    }

    Pattern parseTop(Element node2) throws GrammarException {
        String name = node2.getLocalName();
        if ("notAllowed".equals(name)) {
            return this.parseNotAllowed(node2);
        }
        return this.parsePattern(node2);
    }

    Pattern parsePattern(Element node2) throws GrammarException {
        String name = node2.getLocalName();
        if ("empty".equals(name)) {
            return this.parseEmpty(node2);
        }
        return this.parseNonEmptyPattern(node2);
    }

    Pattern parseNonEmptyPattern(Element node2) throws GrammarException {
        String name = node2.getLocalName();
        if ("text".equals(name)) {
            return this.parseText(node2);
        }
        if ("data".equals(name)) {
            return this.parseData(node2);
        }
        if ("value".equals(name)) {
            return this.parseValue(node2);
        }
        if ("list".equals(name)) {
            return this.parseList(node2);
        }
        if ("attribute".equals(name)) {
            return this.parseAttribute(node2);
        }
        if ("ref".equals(name)) {
            return this.parseRef(node2);
        }
        if ("oneOrMore".equals(name)) {
            return this.parseOneOrMore(node2);
        }
        if ("choice".equals(name)) {
            return this.parseChoice(node2);
        }
        if ("group".equals(name)) {
            return this.parseGroup(node2);
        }
        if ("interleave".equals(name)) {
            return this.parseInterleave(node2);
        }
        throw new GrammarException("invalid pattern: " + name);
    }

    ElementPattern parseElement(Element node2) throws GrammarException {
        this.checkName(node2, "element");
        ElementPattern element = new ElementPattern();
        Element nameClass = FullSyntaxBuilder.getFirstChildElement(node2);
        element.nameClass = this.parseNameClass(nameClass);
        element.pattern = this.parseTop(FullSyntaxBuilder.getNextSiblingElement(nameClass));
        return element;
    }

    NotAllowedPattern parseNotAllowed(Element node2) throws GrammarException {
        this.checkName(node2, "notAllowed");
        return NotAllowedPattern.INSTANCE;
    }

    EmptyPattern parseEmpty(Element node2) throws GrammarException {
        this.checkName(node2, "empty");
        return EmptyPattern.INSTANCE;
    }

    TextPattern parseText(Element node2) throws GrammarException {
        this.checkName(node2, "text");
        return TextPattern.INSTANCE;
    }

    DataPattern parseData(Element node2) throws GrammarException {
        this.checkName(node2, "data");
        DataPattern data = new DataPattern();
        DatatypeLibrary dl = this.getDatatypeLibrary(node2.getAttribute("datatypeLibrary"));
        String type = node2.getAttribute("type");
        try {
            data.type = dl.createDatatype(type);
            data.datatypeLibrary = dl;
        }
        catch (DatatypeException e) {
            GrammarException e2 = new GrammarException(type);
            e2.initCause(e);
            throw e2;
        }
        Element ctx = FullSyntaxBuilder.getFirstChildElement(node2);
        while (ctx != null) {
            Element next = FullSyntaxBuilder.getNextSiblingElement(ctx);
            String name = ctx.getLocalName();
            if ("param".equals(name)) {
                data.params.add(this.parseParam(ctx));
            } else if ("except".equals(name) && next == null) {
                data.exceptPattern = this.parsePattern(FullSyntaxBuilder.getFirstChildElement(ctx));
            } else {
                throw new GrammarException("invalid element: " + name);
            }
            ctx = next;
        }
        return data;
    }

    Param parseParam(Element node2) throws GrammarException {
        this.checkName(node2, "param");
        Param param = new Param();
        param.name = node2.getAttribute("name");
        param.value = node2.getTextContent();
        return param;
    }

    ValuePattern parseValue(Element node2) throws GrammarException {
        this.checkName(node2, "value");
        ValuePattern value = new ValuePattern();
        DatatypeLibrary dl = this.getDatatypeLibrary(node2.getAttribute("datatypeLibrary"));
        String type = node2.getAttribute("type");
        try {
            value.type = dl.createDatatype(type);
            value.datatypeLibrary = dl;
        }
        catch (DatatypeException e) {
            GrammarException e2 = new GrammarException(type);
            e2.initCause(e);
            throw e2;
        }
        value.ns = node2.getAttribute("ns");
        value.value = node2.getTextContent();
        return value;
    }

    ListPattern parseList(Element node2) throws GrammarException {
        this.checkName(node2, "list");
        ListPattern list2 = new ListPattern();
        list2.pattern = this.parsePattern(FullSyntaxBuilder.getFirstChildElement(node2));
        return list2;
    }

    AttributePattern parseAttribute(Element node2) throws GrammarException {
        this.checkName(node2, "attribute");
        AttributePattern attribute = new AttributePattern();
        Element nameClass = FullSyntaxBuilder.getFirstChildElement(node2);
        attribute.nameClass = this.parseNameClass(nameClass);
        attribute.pattern = this.parsePattern(FullSyntaxBuilder.getNextSiblingElement(nameClass));
        return attribute;
    }

    RefPattern parseRef(Element node2) throws GrammarException {
        this.checkName(node2, "ref");
        RefPattern ref = new RefPattern();
        ref.name = node2.getAttribute("name");
        return ref;
    }

    OneOrMorePattern parseOneOrMore(Element node2) throws GrammarException {
        this.checkName(node2, "oneOrMore");
        OneOrMorePattern oneOrMore = new OneOrMorePattern();
        oneOrMore.pattern = this.parseNonEmptyPattern(FullSyntaxBuilder.getFirstChildElement(node2));
        return oneOrMore;
    }

    ChoicePattern parseChoice(Element node2) throws GrammarException {
        this.checkName(node2, "choice");
        ChoicePattern choice = new ChoicePattern();
        Element p1 = FullSyntaxBuilder.getFirstChildElement(node2);
        Element p2 = FullSyntaxBuilder.getNextSiblingElement(p1);
        choice.pattern1 = this.parsePattern(p1);
        choice.pattern2 = this.parseNonEmptyPattern(p2);
        return choice;
    }

    GroupPattern parseGroup(Element node2) throws GrammarException {
        this.checkName(node2, "group");
        GroupPattern group = new GroupPattern();
        Element p1 = FullSyntaxBuilder.getFirstChildElement(node2);
        Element p2 = FullSyntaxBuilder.getNextSiblingElement(p1);
        group.pattern1 = this.parseNonEmptyPattern(p1);
        group.pattern2 = this.parseNonEmptyPattern(p2);
        return group;
    }

    InterleavePattern parseInterleave(Element node2) throws GrammarException {
        this.checkName(node2, "interleave");
        InterleavePattern interleave = new InterleavePattern();
        Element p1 = FullSyntaxBuilder.getFirstChildElement(node2);
        Element p2 = FullSyntaxBuilder.getNextSiblingElement(p1);
        interleave.pattern1 = this.parseNonEmptyPattern(p1);
        interleave.pattern2 = this.parseNonEmptyPattern(p2);
        return interleave;
    }

    NameClass parseNameClass(Element node2) throws GrammarException {
        String name = node2.getLocalName();
        if ("anyName".equals(name)) {
            return this.parseAnyName(node2);
        }
        if ("name".equals(name)) {
            return this.parseName(node2);
        }
        if ("nsName".equals(name)) {
            return this.parseNsName(node2);
        }
        if ("choice".equals(name)) {
            return this.parseChoiceNameClass(node2);
        }
        throw new GrammarException("invalid name class: " + name);
    }

    AnyNameNameClass parseAnyName(Element node2) throws GrammarException {
        this.checkName(node2, "anyName");
        AnyNameNameClass anyName = new AnyNameNameClass();
        Element except = FullSyntaxBuilder.getFirstChildElement(node2);
        if (except != null) {
            this.checkName(except, "except");
            anyName.exceptNameClass = this.parseNameClass(FullSyntaxBuilder.getFirstChildElement(except));
        }
        return anyName;
    }

    NameNameClass parseName(Element node2) throws GrammarException {
        this.checkName(node2, "name");
        NameNameClass name = new NameNameClass();
        name.ns = node2.getAttribute("ns");
        name.name = node2.getTextContent();
        return name;
    }

    NSNameNameClass parseNsName(Element node2) throws GrammarException {
        this.checkName(node2, "nsName");
        NSNameNameClass nsName = new NSNameNameClass();
        nsName.ns = node2.getAttribute("ns");
        Element except = FullSyntaxBuilder.getFirstChildElement(node2);
        if (except != null) {
            this.checkName(except, "except");
            nsName.exceptNameClass = this.parseNameClass(FullSyntaxBuilder.getFirstChildElement(except));
        }
        return nsName;
    }

    ChoiceNameClass parseChoiceNameClass(Element node2) throws GrammarException {
        this.checkName(node2, "choice");
        ChoiceNameClass choice = new ChoiceNameClass();
        Element c1 = FullSyntaxBuilder.getFirstChildElement(node2);
        Element c2 = FullSyntaxBuilder.getNextSiblingElement(c1);
        choice.name1 = this.parseNameClass(c1);
        choice.name2 = this.parseNameClass(c2);
        return choice;
    }

    void checkName(Element node2, String name) throws GrammarException {
        if (!name.equals(node2.getLocalName())) {
            throw new GrammarException("expecting " + name);
        }
    }

    DatatypeLibrary getDatatypeLibrary(String uri) throws GrammarException {
        DatatypeLibrary library;
        if (this.datatypeLibraries == null) {
            this.datatypeLibraries = new HashMap();
        }
        if ((library = (DatatypeLibrary)this.datatypeLibraries.get(uri)) == null) {
            library = new DatatypeLibraryLoader().createDatatypeLibrary(uri);
            if (library == null) {
                throw new GrammarException("Datatype library not supported: " + uri);
            }
            this.datatypeLibraries.put(uri, library);
        }
        return library;
    }
}

