/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.jar;

import gnu.classpath.tools.jar.Action;
import gnu.classpath.tools.jar.Main;
import gnu.classpath.tools.jar.Messages;
import gnu.classpath.tools.jar.WorkSet;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Extractor
extends Action {
    private WorkSet allItems;

    private void copyFile(InputStream input, File output) throws IOException {
        int len;
        FileOutputStream os = new FileOutputStream(output);
        byte[] buffer = new byte[1024];
        while ((len = input.read(buffer)) != -1) {
            os.write(buffer, 0, len);
        }
        os.close();
    }

    public void run(Main parameters) throws IOException {
        ZipEntry entry;
        ZipInputStream zis;
        this.allItems = new WorkSet(parameters.entries);
        File zfile = parameters.archiveFile;
        if (zfile == null || "-".equals(zfile.getName())) {
            zis = new ZipInputStream(System.in);
        } else {
            BufferedInputStream ins = new BufferedInputStream(new FileInputStream(zfile));
            zis = new ZipInputStream(ins);
        }
        while ((entry = zis.getNextEntry()) != null) {
            if (!this.allItems.contains(entry.getName())) continue;
            File file = new File(entry.getName());
            if (entry.isDirectory()) {
                if (!file.mkdirs() || !parameters.verbose) continue;
                String msg = MessageFormat.format(Messages.getString("Extractor.Created"), file);
                System.err.println(msg);
                continue;
            }
            File parent = file.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
            this.copyFile(zis, file);
            if (!parameters.verbose) continue;
            String fmt = entry.getMethod() == 0 ? Messages.getString("Extractor.Extracted") : Messages.getString("Extractor.Inflated");
            String msg = MessageFormat.format(fmt, file);
            System.err.println(msg);
        }
    }
}

