/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.gjdoc;

import com.sun.javadoc.ClassDoc;
import gnu.classpath.tools.gjdoc.ClassDocImpl;
import gnu.classpath.tools.gjdoc.Debug;
import gnu.classpath.tools.gjdoc.DocImpl;
import gnu.classpath.tools.gjdoc.GjdocPackageDoc;
import gnu.classpath.tools.gjdoc.Main;
import gnu.classpath.tools.gjdoc.ParseException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

class PackageDocImpl
extends DocImpl
implements GjdocPackageDoc {
    private String packageName;
    private File packageDirectory;
    private Set allClassesSet = new TreeSet();
    private List ordinaryClassesList = new ArrayList();
    private List exceptionsList = new ArrayList();
    private List interfacesList = new ArrayList();
    private List errorsList = new ArrayList();
    private ClassDoc[] allClasses;
    private ClassDoc[] ordinaryClasses;
    private ClassDoc[] exceptions;
    private ClassDoc[] interfaces;
    private ClassDoc[] errors;
    public static final PackageDocImpl DEFAULT_PACKAGE = new PackageDocImpl("");
    private boolean isIncluded = false;

    PackageDocImpl(String packageName) {
        super(null);
        this.packageName = packageName;
    }

    public void addClass(ClassDoc classDoc) {
        if (Main.getInstance().includeAccessLevel(((ClassDocImpl)classDoc).accessLevel)) {
            this.allClassesSet.add(classDoc);
        }
    }

    public void resolve() {
        for (ClassDocImpl classDoc : this.allClassesSet) {
            try {
                classDoc.resolve();
            }
            catch (ParseException e) {
                System.err.println("FIXME: add try-catch to force compilation" + e);
            }
            if (classDoc.isInterface()) {
                this.interfacesList.add(classDoc);
                continue;
            }
            if (classDoc.isException()) {
                this.exceptionsList.add(classDoc);
                continue;
            }
            if (classDoc.isError()) {
                this.errorsList.add(classDoc);
                continue;
            }
            this.ordinaryClassesList.add(classDoc);
        }
    }

    public void resolveComments() {
        if (this.rawDocumentation != null) {
            this.tagMap = PackageDocImpl.parseCommentTags(this.rawDocumentation.toCharArray(), 0, this.rawDocumentation.length(), null, null, null, null);
        }
        this.resolveTags();
    }

    public String name() {
        return this.packageName;
    }

    public ClassDoc[] allClasses() {
        if (this.allClasses == null) {
            this.allClasses = this.toClassDocArray(this.allClassesSet);
        }
        return this.allClasses;
    }

    public ClassDoc[] ordinaryClasses() {
        if (this.ordinaryClasses == null) {
            this.ordinaryClasses = this.toClassDocArray(this.ordinaryClassesList);
        }
        return this.ordinaryClasses;
    }

    public ClassDoc[] exceptions() {
        if (this.exceptions == null) {
            this.exceptions = this.toClassDocArray(this.exceptionsList);
        }
        return this.exceptions;
    }

    public ClassDoc[] interfaces() {
        if (this.interfaces == null) {
            this.interfaces = this.toClassDocArray(this.interfacesList);
        }
        return this.interfaces;
    }

    public ClassDoc[] errors() {
        if (this.errors == null) {
            this.errors = this.toClassDocArray(this.errorsList);
        }
        return this.errors;
    }

    private ClassDoc[] toClassDocArray(Collection classDocList) {
        Object[] result = classDocList.toArray(new ClassDoc[classDocList.size()]);
        Arrays.sort(result);
        return result;
    }

    public ClassDoc findClass(String name) {
        return Main.getRootDoc().classNamed(String.valueOf(this.packageName) + "." + name);
    }

    public void dump(int level) {
        Debug.log(level, "All classes:");
        Debug.dumpArray(level, this.allClasses());
        Debug.log(level, "Ordinary classes:");
        Debug.dumpArray(level, this.ordinaryClasses());
    }

    public boolean isPackage() {
        return true;
    }

    public boolean isIncluded() {
        return this.isIncluded;
    }

    void setIsIncluded(boolean b) {
        this.isIncluded = b;
    }

    public String toString() {
        return this.packageName;
    }

    public int compareTo(Object o) {
        if (o != null && o instanceof PackageDocImpl) {
            return this.name().compareTo(((PackageDocImpl)o).name());
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof PackageDocImpl) {
            return this.name().equals(((PackageDocImpl)o).name());
        }
        return false;
    }

    public void setPackageDirectory(File packageDirectory) {
        this.packageDirectory = packageDirectory;
    }

    public File packageDirectory() {
        return this.packageDirectory;
    }
}

