/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth;

import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;

public final class PrivateCredentialPermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = 5284372143517237068L;
    private final String credentialClass;
    private final Set principals;
    private final boolean testing;

    public PrivateCredentialPermission(String string, String string2) {
        super(string);
        string2 = string2.trim().toLowerCase();
        if (!"read".equals(string2)) {
            throw new IllegalArgumentException("actions must be \"read\"");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \"'");
        this.principals = new HashSet();
        if (stringTokenizer.countTokens() < 3 || (stringTokenizer.countTokens() & 1) == 0) {
            throw new IllegalArgumentException("badly formed credential name");
        }
        this.credentialClass = stringTokenizer.nextToken();
        while (stringTokenizer.hasMoreTokens()) {
            this.principals.add(new CredOwner(stringTokenizer.nextToken(), stringTokenizer.nextToken()));
        }
        this.testing = false;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PrivateCredentialPermission)) {
            return false;
        }
        PrivateCredentialPermission privateCredentialPermission = (PrivateCredentialPermission)object;
        if (!privateCredentialPermission.getActions().equals(this.getActions())) {
            return false;
        }
        if (!privateCredentialPermission.getCredentialClass().equals(this.getCredentialClass())) {
            return false;
        }
        String[][] stringArray = this.getPrincipals();
        String[][] stringArray2 = privateCredentialPermission.getPrincipals();
        if (stringArray2 == null) {
            return false;
        }
        if (stringArray2.length != stringArray.length) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i][0].equals(stringArray2[i][0]) && stringArray[i][1].equals(stringArray2[i][1])) continue;
            return false;
        }
        return true;
    }

    public String getActions() {
        return "read";
    }

    public String getCredentialClass() {
        return this.credentialClass;
    }

    public String[][] getPrincipals() {
        String[][] stringArray = new String[this.principals.size()][];
        Iterator iterator = this.principals.iterator();
        for (int i = 0; i < this.principals.size() && iterator.hasNext(); ++i) {
            CredOwner credOwner = (CredOwner)iterator.next();
            stringArray[i] = new String[]{credOwner.getPrincipalClass(), credOwner.getPrincipalName()};
        }
        return stringArray;
    }

    public int hashCode() {
        return this.credentialClass.hashCode() + this.principals.hashCode();
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof PrivateCredentialPermission)) {
            return false;
        }
        PrivateCredentialPermission privateCredentialPermission = (PrivateCredentialPermission)permission;
        if (!this.credentialClass.equals("*") && !this.credentialClass.equals(privateCredentialPermission.getCredentialClass())) {
            return false;
        }
        String[][] stringArray = this.getPrincipals();
        String[][] stringArray2 = privateCredentialPermission.getPrincipals();
        if (stringArray2 == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray2.length; ++j) {
                if (!stringArray[i][0].equals(stringArray2[j][0]) || !stringArray[i][1].equals("*") && !stringArray[i][1].equals(stringArray2[j][1])) continue;
                return true;
            }
        }
        return false;
    }

    public PermissionCollection newPermissionCollection() {
        return null;
    }

    private static class CredOwner
    implements Serializable {
        private final String principalClass;
        private final String principalName;

        CredOwner(String string, String string2) {
            this.principalClass = string;
            this.principalName = string2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof CredOwner)) {
                return false;
            }
            return this.principalClass.equals(((CredOwner)object).getPrincipalClass()) && this.principalName.equals(((CredOwner)object).getPrincipalName());
        }

        public int hashCode() {
            return this.principalClass.hashCode() + this.principalName.hashCode();
        }

        public String getPrincipalClass() {
            return this.principalClass;
        }

        public String getPrincipalName() {
            return this.principalName;
        }
    }
}

