/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import java.lang.management.ThreadInfo;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.SimpleType;

public class MemoryUsage {
    private long init;
    private long used;
    private long committed;
    private long maximum;

    public MemoryUsage(long l, long l2, long l3, long l4) {
        if (l < (long)-1) {
            throw new IllegalArgumentException("Initial value of " + l + " is too small.");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("Used value of " + l2 + " is too small.");
        }
        if (l3 < 0L) {
            throw new IllegalArgumentException("Committed value of " + l3 + " is too small.");
        }
        if (l3 < l2) {
            throw new IllegalArgumentException("Committed value of " + l3 + " is below " + l2 + ", the amount used.");
        }
        if (l4 < (long)-1) {
            throw new IllegalArgumentException("Maximum value of " + l4 + " is too small.");
        }
        if (l4 != (long)-1 && l4 < l3) {
            throw new IllegalArgumentException("Maximum value of " + l4 + " is below " + l3 + ", the amount " + "committed.");
        }
        this.init = l;
        this.used = l2;
        this.committed = l3;
        this.maximum = l4;
    }

    public static MemoryUsage from(CompositeData compositeData) {
        if (compositeData == null) {
            return null;
        }
        CompositeType compositeType = compositeData.getCompositeType();
        ThreadInfo.checkAttribute(compositeType, "init", SimpleType.LONG);
        ThreadInfo.checkAttribute(compositeType, "used", SimpleType.LONG);
        ThreadInfo.checkAttribute(compositeType, "committed", SimpleType.LONG);
        ThreadInfo.checkAttribute(compositeType, "max", SimpleType.LONG);
        return new MemoryUsage((Long)compositeData.get("init"), (Long)compositeData.get("used"), (Long)compositeData.get("committed"), (Long)compositeData.get("max"));
    }

    public long getCommitted() {
        return this.committed;
    }

    public long getInit() {
        return this.init;
    }

    public long getMax() {
        return this.maximum;
    }

    public long getUsed() {
        return this.used;
    }

    public String toString() {
        int n = 0x100000;
        return this.getClass().getName() + "[init=" + this.init + " bytes (~" + this.init / (long)n + "MB), used=" + this.used + " bytes (~" + this.used / (long)n + "MB), committed=" + this.committed + " bytes (~" + this.committed / (long)n + "MB), maximum=" + this.maximum + " bytes (~" + this.maximum / (long)n + "MB)]";
    }
}

