/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class Runtime {
    private final String[] libpath;
    private Thread exitSequence;
    private Set shutdownHooks;
    private boolean finalizeOnExit;
    private static final Runtime current;

    private Runtime() {
        if (current != null) {
            throw new InternalError("Attempt to recreate Runtime");
        }
        this.libpath = new String[0];
    }

    public static Runtime getRuntime() {
        return current;
    }

    public void exit(int n) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkExit(n);
        }
        this.exitNoChecks(n);
    }

    static void exitNoChecksAccessor(int n) {
        current.exitNoChecks(n);
    }

    private void exitNoChecks(int n) {
        if (this.runShutdownHooks()) {
            this.exitInternal(n);
        }
        String[] stringArray = this.libpath;
        synchronized (stringArray) {
            block8: {
                try {
                    if (this.shutdownHooks == null) break block8;
                    this.shutdownHooks.remove(Thread.currentThread());
                    this.exitSequence.interrupt();
                    n = 0;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
            Object var3_3 = null;
        }
        if (n != 0) {
            this.exitInternal(n);
        }
        while (true) {
            try {
                this.exitSequence.join();
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    boolean runShutdownHooks() {
        var1_1 = false;
        var2_2 = this.libpath;
        // MONITORENTER : var2_2
        try {
            if (this.exitSequence == null) {
                var1_1 = true;
                this.exitSequence = Thread.currentThread();
                if (this.shutdownHooks != null) {
                    var3_3 = this.shutdownHooks.iterator();
                    while (var3_3.hasNext()) {
                        try {
                            ((Thread)var3_3.next()).start();
                        }
                        catch (IllegalThreadStateException var4_5) {
                            var3_3.remove();
                        }
                    }
                }
            }
            var3_3 = null;
        }
        catch (Throwable var4_6) {
            var3_4 = null;
            // MONITOREXIT : var2_2
            throw var4_6;
        }
        if (var1_1 == false) return var1_1;
        if (this.shutdownHooks == null) ** GOTO lbl57
        block20: while (true) {
            block26: {
                var4_7 = this.libpath;
                // MONITORENTER : var4_7
                try {
                    var3_3 = new Thread[this.shutdownHooks.size()];
                    this.shutdownHooks.toArray(var3_3);
                }
                catch (Throwable var6_12) {
                    var5_10 = null;
                    // MONITOREXIT : var4_7
                    throw var6_12;
                }
                var5_9 = null;
                // MONITOREXIT : var4_7
                if (var3_3.length != 0) break block26;
                var8_14 = this.libpath;
                // MONITORENTER : var8_14
                try {
                    this.shutdownHooks = null;
                }
                catch (Throwable var10_21) {
                    var9_19 = null;
                    // MONITOREXIT : var8_14
                    throw var10_21;
                }
                var9_18 = null;
                // MONITOREXIT : var8_14
lbl57:
                // 2 sources

                this.runFinalizationForExit();
                return var1_1;
            }
            var5_8 = 0;
            while (true) {
                block25: {
                    if (var5_8 >= var3_3.length) continue block20;
                    try {
                        var6_11 = this.libpath;
                        // MONITORENTER : var6_11
                        try {
                            if (!this.shutdownHooks.contains(var3_3[var5_8])) {
                                var7_13 = null;
                                // MONITOREXIT : var6_11
                                break block25;
                            }
                            var7_13 = null;
                        }
                        catch (Throwable var8_15) {
                            var7_13 = null;
                            // MONITOREXIT : var6_11
                            throw var8_15;
                        }
                        var3_3[var5_8].join();
                        var7_13 = this.libpath;
                        // MONITORENTER : var7_13
                        try {}
                        catch (Throwable var9_17) {
                            var8_14 = null;
                            // MONITOREXIT : var7_13
                            throw var9_17;
                        }
                        {
                            this.shutdownHooks.remove(var3_3[var5_8]);
                        }
                        var8_14 = null;
                        // MONITOREXIT : var7_13
                    }
                    catch (InterruptedException var8_16) {
                        // empty catch block
                    }
                }
                ++var5_8;
            }
            break;
        }
    }

    public void addShutdownHook(Thread thread) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("shutdownHooks"));
        }
        if (thread.isAlive() || thread.getThreadGroup() == null) {
            throw new IllegalArgumentException("The hook thread " + thread + " must not have been already run or started");
        }
        String[] stringArray = this.libpath;
        synchronized (stringArray) {
            try {
                if (this.exitSequence != null) {
                    throw new IllegalStateException("The Virtual Machine is exiting. It is not possible anymore to add any hooks");
                }
                if (this.shutdownHooks == null) {
                    this.shutdownHooks = new HashSet();
                }
                if (!this.shutdownHooks.add(thread)) {
                    throw new IllegalArgumentException(thread.toString() + " had already been inserted");
                }
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                throw throwable;
            }
        }
    }

    public boolean removeShutdownHook(Thread thread) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("shutdownHooks"));
        }
        String[] stringArray = this.libpath;
        synchronized (stringArray) {
            block5: {
                try {
                    if (this.exitSequence != null) {
                        throw new IllegalStateException();
                    }
                    if (this.shutdownHooks == null) break block5;
                    boolean bl = this.shutdownHooks.remove(thread);
                    Object var5_6 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    throw throwable;
                }
            }
            Object var5_7 = null;
        }
        boolean bl = false;
        return bl;
    }

    public void halt(int n) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkExit(n);
        }
        this.exitInternal(n);
    }

    public static void runFinalizersOnExit(boolean bl) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkExit(0);
        }
        Runtime.current.finalizeOnExit = bl;
    }

    public Process exec(String string) throws IOException {
        return this.exec(string, null, null);
    }

    public Process exec(String string, String[] stringArray) throws IOException {
        return this.exec(string, stringArray, null);
    }

    public Process exec(String string, String[] stringArray, File file) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String[] stringArray2 = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = stringTokenizer.nextToken();
        }
        return this.exec(stringArray2, stringArray, file);
    }

    public Process exec(String[] stringArray) throws IOException {
        return this.exec(stringArray, null, null);
    }

    public Process exec(String[] stringArray, String[] stringArray2) throws IOException {
        return this.exec(stringArray, stringArray2, null);
    }

    public Process exec(String[] stringArray, String[] stringArray2, File file) throws IOException {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkExec(stringArray[0]);
        }
        return this.execInternal(stringArray, stringArray2, file);
    }

    public native int availableProcessors();

    public native long freeMemory();

    public native long totalMemory();

    public native long maxMemory();

    public native void gc();

    public native void runFinalization();

    public native void traceInstructions(boolean var1);

    public native void traceMethodCalls(boolean var1);

    public void load(String string) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkLink(string);
        }
        this._load(string, false);
    }

    public void loadLibrary(String string) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkLink(string);
        }
        this._load(string, true);
    }

    public InputStream getLocalizedInputStream(InputStream inputStream) {
        return inputStream;
    }

    public OutputStream getLocalizedOutputStream(OutputStream outputStream) {
        return outputStream;
    }

    native void exitInternal(int var1);

    native void _load(String var1, boolean var2);

    native boolean loadLibraryInternal(String var1);

    private static native void init();

    private native void runFinalizationForExit();

    static native String nativeGetLibname(String var0, String var1);

    native Process execInternal(String[] var1, String[] var2, File var3) throws IOException;

    static {
        Runtime.init();
        current = new Runtime();
    }
}

