/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Double
extends Number
implements Comparable {
    private static final long serialVersionUID = -9172774392245257468L;
    public static final double MAX_VALUE = 1.7976931348623157E308;
    public static final double MIN_VALUE = 4.9E-324;
    public static final double NEGATIVE_INFINITY = -1.0 / 0.0;
    public static final double POSITIVE_INFINITY = 1.0 / 0.0;
    public static final double NaN = 0.0 / 0.0;
    public static final int SIZE = 64;
    public static final Class TYPE = VMClassLoader.getPrimitiveClass('D');
    private final double value;

    public Double(double d) {
        this.value = d;
    }

    public Double(String string) {
        this.value = Double.parseDouble(string);
    }

    public static String toString(double d) {
        return VMDouble.toString(d, false);
    }

    public static String toHexString(double d) {
        int n;
        if (Double.isNaN(d)) {
            return "NaN";
        }
        if (Double.isInfinite(d)) {
            if (d < 0.0) {
                return "-Infinity";
            }
            return "Infinity";
        }
        long l = Double.doubleToLongBits(d);
        StringBuilder stringBuilder = new StringBuilder();
        if (l < 0L) {
            stringBuilder.append('-');
        }
        stringBuilder.append("0x");
        int n2 = 52;
        int n3 = 11;
        long l2 = (1L << (n2 & 0x3F)) - 1L;
        long l3 = l & l2;
        long l4 = (1L << (n3 & 0x3F)) - 1L;
        long l5 = l >>> (n2 & 0x3F) & l4;
        stringBuilder.append(l5 == 0L ? (char)'0' : '1');
        stringBuilder.append('.');
        stringBuilder.append(Long.toHexString(l3));
        if (l5 == 0L && l3 != 0L) {
            n = 4 + (l < 0L ? 1 : 0);
            int n4 = n + (n2 + 3) / 4;
            while (stringBuilder.length() < n4) {
                stringBuilder.insert(n, '0');
            }
        }
        stringBuilder.append('p');
        if (l5 != 0L || l3 != 0L) {
            n = l5 == 0L ? 1 : 0;
            l5 -= (long)((1 << (n3 + -1 & 0x1F)) - 1);
            if (n != 0) {
                ++l5;
            }
        }
        stringBuilder.append(Long.toString(l5));
        return stringBuilder.toString();
    }

    public static Double valueOf(double d) {
        return new Double(d);
    }

    public static Double valueOf(String string) {
        return new Double(Double.parseDouble(string));
    }

    public static double parseDouble(String string) {
        return VMDouble.parseDouble(string);
    }

    public static boolean isNaN(double d) {
        return d != d;
    }

    public static boolean isInfinite(double d) {
        return d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY;
    }

    public boolean isNaN() {
        return Double.isNaN(this.value);
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.value);
    }

    public String toString() {
        return Double.toString(this.value);
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return (long)this.value;
    }

    public float floatValue() {
        return (float)this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.value);
        return (int)l ^ (int)(l >>> 32);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Double)) {
            return false;
        }
        double d = ((Double)object).value;
        if (this.value == d) {
            return this.value != 0.0 || 1.0 / this.value == 1.0 / d;
        }
        return Double.isNaN(this.value) && Double.isNaN(d);
    }

    public static long doubleToLongBits(double d) {
        return VMDouble.doubleToLongBits(d);
    }

    public static long doubleToRawLongBits(double d) {
        return VMDouble.doubleToRawLongBits(d);
    }

    public static double longBitsToDouble(long l) {
        return VMDouble.longBitsToDouble(l);
    }

    public int compareTo(Double d) {
        return Double.compare(this.value, d.value);
    }

    public int compareTo(Object object) {
        return Double.compare(this.value, ((Double)object).value);
    }

    public static int compare(double d, double d2) {
        if (Double.isNaN(d)) {
            if (Double.isNaN(d2)) {
                return 0;
            }
            return 1;
        }
        if (Double.isNaN(d2)) {
            return -1;
        }
        if (d == 0.0 && d2 == 0.0) {
            return (int)(1.0 / d - 1.0 / d2);
        }
        if (d == d2) {
            return 0;
        }
        if (d > d2) {
            return 1;
        }
        return -1;
    }
}

