/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LineNumberInputStream
extends FilterInputStream {
    private int lineNumber;
    private int markLineNumber;
    private boolean justReadReturnChar;

    private /* synthetic */ void finit$() {
        this.lineNumber = 0;
        this.markLineNumber = 0;
        this.justReadReturnChar = false;
    }

    public LineNumberInputStream(InputStream inputStream) {
        super(inputStream);
        this.finit$();
    }

    public int available() throws IOException {
        return this.in.available() / 2;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void mark(int n) {
        this.in.mark(n);
        this.markLineNumber = this.lineNumber;
    }

    public int read() throws IOException {
        int n = this.in.read();
        if (n == 10) {
            if (this.justReadReturnChar) {
                n = this.in.read();
                this.justReadReturnChar = false;
            } else {
                ++this.lineNumber;
            }
        } else if (n == 13) {
            n = 10;
            this.justReadReturnChar = true;
            ++this.lineNumber;
        } else {
            this.justReadReturnChar = false;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        int n4 = n;
        while (n2-- > 0 && (n3 = this.read()) >= 0) {
            byArray[n++] = (byte)n3;
        }
        if (n == n4) {
            return -1;
        }
        return n - n4;
    }

    public void reset() throws IOException {
        this.in.reset();
        this.lineNumber = this.markLineNumber;
        this.justReadReturnChar = false;
    }

    public void setLineNumber(int n) {
        this.lineNumber = n;
    }

    public long skip(long l) throws IOException {
        int n;
        if (l <= 0L) {
            return 0L;
        }
        long l2 = l;
        while ((n = this.read()) >= 0) {
            if (n == 10 || n == 13) {
                ++this.lineNumber;
            }
            if (--l > 0L) continue;
        }
        return l2 - l;
    }
}

