/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;

public class BandCombineOp
implements RasterOp {
    private RenderingHints hints;
    private float[][] matrix;

    public BandCombineOp(float[][] fArray, RenderingHints renderingHints) {
        this.matrix = fArray;
        this.hints = renderingHints;
    }

    public WritableRaster filter(Raster raster, WritableRaster writableRaster) {
        if (writableRaster == null) {
            writableRaster = this.createCompatibleDestRaster(raster);
        }
        float[] fArray = new float[this.matrix[0].length];
        float[] fArray2 = new float[this.matrix.length];
        for (int i = raster.getMinY(); i < raster.getHeight() + raster.getMinY(); ++i) {
            for (int j = raster.getMinX(); j < raster.getWidth() + raster.getMinX(); ++j) {
                fArray[fArray.length - 1] = 1.0f;
                raster.getPixel(j, i, fArray);
                for (int k = 0; k < this.matrix.length; ++k) {
                    fArray2[k] = 0.0f;
                    for (int i2 = 0; i2 < this.matrix[0].length; ++i2) {
                        int n = k;
                        fArray2[n] = fArray2[n] + fArray[i2] * this.matrix[k][i2];
                    }
                }
                writableRaster.setPixel(j, i, fArray2);
            }
        }
        return writableRaster;
    }

    public final Rectangle2D getBounds2D(Raster raster) {
        return raster.getBounds();
    }

    public WritableRaster createCompatibleDestRaster(Raster raster) {
        return Raster.createBandedRaster(4, raster.getWidth(), raster.getHeight(), this.matrix.length, new Point(raster.getMinX(), raster.getMinY()));
    }

    public final Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            return (Point2D)point2D.clone();
        }
        point2D2.setLocation(point2D);
        return point2D2;
    }

    public final RenderingHints getRenderingHints() {
        return this.hints;
    }

    public final float[][] getMatrix() {
        return this.matrix;
    }
}

