/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.geom.CubicCurve2D;
import java.awt.geom.PathIterator;
import java.awt.geom.QuadCurve2D;
import java.util.NoSuchElementException;

public class FlatteningPathIterator
implements PathIterator {
    private final PathIterator srcIter;
    private final double flatnessSq;
    private final int recursionLimit;
    private double[] stack;
    private int stackSize;
    private int[] recLevel;
    private final double[] scratch;
    private int srcSegType;
    private double srcPosX;
    private double srcPosY;
    private boolean done;

    private /* synthetic */ void finit$() {
        this.scratch = new double[6];
    }

    public FlatteningPathIterator(PathIterator pathIterator, double d) {
        this(pathIterator, d, 10);
    }

    public FlatteningPathIterator(PathIterator pathIterator, double d, int n) {
        this.finit$();
        if (d < 0.0 || n < 0) {
            throw new IllegalArgumentException();
        }
        this.srcIter = pathIterator;
        double d2 = d;
        this.flatnessSq = d2 * d2;
        this.recursionLimit = n;
        this.fetchSegment();
    }

    public double getFlatness() {
        return Math.sqrt(this.flatnessSq);
    }

    public int getRecursionLimit() {
        return this.recursionLimit;
    }

    public int getWindingRule() {
        return this.srcIter.getWindingRule();
    }

    public boolean isDone() {
        return this.done;
    }

    public void next() {
        if (this.stackSize > 0) {
            --this.stackSize;
            if (this.stackSize > 0) {
                switch (this.srcSegType) {
                    case 2: {
                        this.subdivideQuadratic();
                        return;
                    }
                    case 3: {
                        this.subdivideCubic();
                        return;
                    }
                }
                throw new IllegalStateException();
            }
        }
        this.srcIter.next();
        this.fetchSegment();
    }

    public int currentSegment(double[] dArray) {
        if (this.done) {
            throw new NoSuchElementException();
        }
        switch (this.srcSegType) {
            case 4: {
                return this.srcSegType;
            }
            case 0: 
            case 1: {
                dArray[0] = this.srcPosX;
                dArray[1] = this.srcPosY;
                return this.srcSegType;
            }
            case 2: {
                if (this.stackSize == 0) {
                    dArray[0] = this.srcPosX;
                    dArray[1] = this.srcPosY;
                } else {
                    int n = this.stack.length - 4 * this.stackSize;
                    dArray[0] = this.stack[n + 2];
                    dArray[1] = this.stack[n + 3];
                }
                return 1;
            }
            case 3: {
                if (this.stackSize == 0) {
                    dArray[0] = this.srcPosX;
                    dArray[1] = this.srcPosY;
                } else {
                    int n = this.stack.length - 6 * this.stackSize;
                    dArray[0] = this.stack[n + 4];
                    dArray[1] = this.stack[n + 5];
                }
                return 1;
            }
        }
        throw new IllegalStateException();
    }

    public int currentSegment(float[] fArray) {
        if (this.done) {
            throw new NoSuchElementException();
        }
        switch (this.srcSegType) {
            case 4: {
                return this.srcSegType;
            }
            case 0: 
            case 1: {
                fArray[0] = (float)this.srcPosX;
                fArray[1] = (float)this.srcPosY;
                return this.srcSegType;
            }
            case 2: {
                if (this.stackSize == 0) {
                    fArray[0] = (float)this.srcPosX;
                    fArray[1] = (float)this.srcPosY;
                } else {
                    int n = this.stack.length - 4 * this.stackSize;
                    fArray[0] = (float)this.stack[n + 2];
                    fArray[1] = (float)this.stack[n + 3];
                }
                return 1;
            }
            case 3: {
                if (this.stackSize == 0) {
                    fArray[0] = (float)this.srcPosX;
                    fArray[1] = (float)this.srcPosY;
                } else {
                    int n = this.stack.length - 6 * this.stackSize;
                    fArray[0] = (float)this.stack[n + 4];
                    fArray[1] = (float)this.stack[n + 5];
                }
                return 1;
            }
        }
        throw new IllegalStateException();
    }

    private void fetchSegment() {
        if (this.srcIter.isDone()) {
            this.done = true;
            return;
        }
        this.srcSegType = this.srcIter.currentSegment(this.scratch);
        switch (this.srcSegType) {
            case 4: {
                return;
            }
            case 0: 
            case 1: {
                this.srcPosX = this.scratch[0];
                this.srcPosY = this.scratch[1];
                return;
            }
            case 2: {
                if (this.recursionLimit == 0) {
                    this.srcPosX = this.scratch[2];
                    this.srcPosY = this.scratch[3];
                    this.stackSize = 0;
                    return;
                }
                int n = 4 * this.recursionLimit;
                this.stackSize = 1;
                if (this.stack == null) {
                    this.stack = new double[n + 6];
                    this.recLevel = new int[this.recursionLimit + 1];
                }
                this.recLevel[0] = 0;
                this.stack[n] = this.srcPosX;
                this.stack[n + 1] = this.srcPosY;
                this.stack[n + 2] = this.scratch[0];
                this.stack[n + 3] = this.scratch[1];
                double d = this.scratch[2];
                this.stack[n + 4] = d;
                this.srcPosX = d;
                double d2 = this.scratch[3];
                this.stack[n + 5] = d2;
                this.srcPosY = d2;
                this.subdivideQuadratic();
                break;
            }
            case 3: {
                if (this.recursionLimit == 0) {
                    this.srcPosX = this.scratch[4];
                    this.srcPosY = this.scratch[5];
                    this.stackSize = 0;
                    return;
                }
                int n = 6 * this.recursionLimit;
                this.stackSize = 1;
                if (this.stack == null || this.stack.length < n + 8) {
                    this.stack = new double[n + 8];
                    this.recLevel = new int[this.recursionLimit + 1];
                }
                this.recLevel[0] = 0;
                this.stack[n] = this.srcPosX;
                this.stack[n + 1] = this.srcPosY;
                this.stack[n + 2] = this.scratch[0];
                this.stack[n + 3] = this.scratch[1];
                this.stack[n + 4] = this.scratch[2];
                this.stack[n + 5] = this.scratch[3];
                double d = this.scratch[4];
                this.stack[n + 6] = d;
                this.srcPosX = d;
                double d3 = this.scratch[5];
                this.stack[n + 7] = d3;
                this.srcPosY = d3;
                this.subdivideCubic();
                return;
            }
        }
    }

    private void subdivideQuadratic() {
        int n = this.stack.length - 4 * this.stackSize - 2;
        int n2 = this.recLevel[this.stackSize - 1];
        while (n2 < this.recursionLimit && QuadCurve2D.getFlatnessSq(this.stack, n) >= this.flatnessSq) {
            int n3 = ++n2;
            this.recLevel[this.stackSize - 1] = n3;
            this.recLevel[this.stackSize] = n3;
            QuadCurve2D.subdivide(this.stack, n, this.stack, n - 4, this.stack, n);
            ++this.stackSize;
            n -= 4;
        }
    }

    private void subdivideCubic() {
        int n = this.stack.length - 6 * this.stackSize - 2;
        int n2 = this.recLevel[this.stackSize - 1];
        while (n2 < this.recursionLimit && CubicCurve2D.getFlatnessSq(this.stack, n) >= this.flatnessSq) {
            int n3 = ++n2;
            this.recLevel[this.stackSize - 1] = n3;
            this.recLevel[this.stackSize] = n3;
            CubicCurve2D.subdivide(this.stack, n, this.stack, n - 6, this.stack, n);
            ++this.stackSize;
            n -= 6;
        }
    }
}

