/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.NoSuchElementException;

public abstract class Arc2D
extends RectangularShape {
    public static final int OPEN = 0;
    public static final int CHORD = 1;
    public static final int PIE = 2;
    int type;

    protected Arc2D(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException();
        }
        this.type = n;
    }

    public abstract double getAngleStart();

    public abstract double getAngleExtent();

    public int getArcType() {
        return this.type;
    }

    public Point2D getStartPoint() {
        double d = Math.toRadians(this.getAngleStart());
        double d2 = this.getWidth() / 2.0;
        double d3 = this.getHeight() / 2.0;
        double d4 = this.getX() + d2 + d2 * Math.cos(d);
        double d5 = this.getY() + d3 - d3 * Math.sin(d);
        return new Point2D.Double(d4, d5);
    }

    public Point2D getEndPoint() {
        double d = Math.toRadians(this.getAngleStart() + this.getAngleExtent());
        double d2 = this.getWidth() / 2.0;
        double d3 = this.getHeight() / 2.0;
        double d4 = this.getX() + d2 + d2 * Math.cos(d);
        double d5 = this.getY() + d3 - d3 * Math.sin(d);
        return new Point2D.Double(d4, d5);
    }

    public abstract void setArc(double var1, double var3, double var5, double var7, double var9, double var11, int var13);

    public void setArc(Point2D point2D, Dimension2D dimension2D, double d, double d2, int n) {
        this.setArc(point2D.getX(), point2D.getY(), dimension2D.getWidth(), dimension2D.getHeight(), d, d2, n);
    }

    public void setArc(Rectangle2D rectangle2D, double d, double d2, int n) {
        this.setArc(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight(), d, d2, n);
    }

    public void setArc(Arc2D arc2D) {
        this.setArc(arc2D.getX(), arc2D.getY(), arc2D.getWidth(), arc2D.getHeight(), arc2D.getAngleStart(), arc2D.getAngleExtent(), arc2D.getArcType());
    }

    public void setArcByCenter(double d, double d2, double d3, double d4, double d5, int n) {
        double d6 = d3;
        double d7 = d3;
        this.setArc(d - d3, d2 - d3, d6 + d6, d7 + d7, d4, d5, n);
    }

    public void setArcByTangent(Point2D point2D, Point2D point2D2, Point2D point2D3, double d) {
        if ((point2D2.getX() - point2D.getX()) * (point2D3.getY() - point2D.getY()) - (point2D3.getX() - point2D.getX()) * (point2D2.getY() - point2D.getY()) > 0.0) {
            Point2D point2D4 = point2D3;
            point2D3 = point2D;
            point2D = point2D4;
        }
        double d2 = (point2D.getX() - point2D2.getX()) / point2D.distance(point2D2);
        double d3 = (point2D.getY() - point2D2.getY()) / point2D.distance(point2D2);
        double d4 = (point2D2.getX() - point2D3.getX()) / point2D3.distance(point2D2);
        double d5 = (point2D2.getY() - point2D3.getY()) / point2D3.distance(point2D2);
        double d6 = Math.atan2(d2, d3);
        double d7 = Math.atan2(d4, d5);
        double d8 = d * Math.cos(d7) - d * Math.cos(d6);
        double d9 = -d * Math.sin(d7) + d * Math.sin(d6);
        if (d6 < 0.0) {
            d6 += Math.PI * 2;
        }
        if (d7 < 0.0) {
            d7 += Math.PI * 2;
        }
        if (d7 < d6) {
            d7 += Math.PI * 2;
        }
        d2 = point2D.getX() - point2D2.getX();
        d3 = point2D.getY() - point2D2.getY();
        d4 = point2D3.getX() - point2D2.getX();
        d5 = point2D3.getY() - point2D2.getY();
        double d10 = -(d2 * d9 - d3 * d8) / (d4 * d3 - d2 * d5);
        double d11 = d10 * (point2D3.getX() - point2D2.getX()) + point2D2.getX();
        double d12 = d10 * (point2D3.getY() - point2D2.getY()) + point2D2.getY();
        double d13 = d11 - d * Math.cos(d7);
        double d14 = d12 + d * Math.sin(d7);
        this.setArc(d13 - d, d14 - d, 2.0 * d, 2.0 * d, Math.toDegrees(d6), Math.toDegrees(d7 - d6), this.getArcType());
    }

    public abstract void setAngleStart(double var1);

    public abstract void setAngleExtent(double var1);

    public void setAngleStart(Point2D point2D) {
        double d = point2D.getX() - (this.getX() + this.getWidth() / 2.0);
        double d2 = point2D.getY() - (this.getY() + this.getHeight() / 2.0);
        this.setAngleStart(Math.toDegrees(Math.atan2(-d2, d)));
    }

    public void setAngles(double d, double d2, double d3, double d4) {
        double d5 = this.getX();
        double d6 = this.getY();
        double d7 = this.getWidth();
        double d8 = this.getHeight();
        d3 -= d5 + d7 / 2.0;
        d4 -= d6 + d8 / 2.0;
        double d9 = Math.toDegrees(Math.atan2(-(d2 -= d6 + d8 / 2.0), d -= d5 + d7 / 2.0));
        double d10 = Math.toDegrees(Math.atan2(-d4, d3)) - d9;
        if (d10 < 0.0) {
            d10 += 360.0;
        }
        this.setAngleStart(d9);
        this.setAngleExtent(d10);
    }

    public void setAngles(Point2D point2D, Point2D point2D2) {
        this.setAngles(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY());
    }

    public void setArcType(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException();
        }
        this.type = n;
    }

    public void setFrame(double d, double d2, double d3, double d4) {
        this.setArc(d, d2, d3, d4, this.getAngleStart(), this.getAngleExtent(), this.type);
    }

    public Rectangle2D getBounds2D() {
        double d = this.getAngleExtent();
        if (Math.abs(d) >= 360.0) {
            return this.makeBounds(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        double d2 = this.getWidth() / 2.0;
        double d3 = this.getHeight() / 2.0;
        double d4 = this.getX() + d2;
        double d5 = this.getY() + d3;
        Point2D point2D = this.getStartPoint();
        Rectangle2D rectangle2D = this.makeBounds(point2D.getX(), point2D.getY(), 0.0, 0.0);
        rectangle2D.add(this.getEndPoint());
        if (this.type == 2) {
            rectangle2D.add(d4, d5);
        }
        if (this.containsAngle(0.0)) {
            rectangle2D.add(d4 + d2, d5);
        }
        if (this.containsAngle(90.0)) {
            rectangle2D.add(d4, d5 - d3);
        }
        if (this.containsAngle(180.0)) {
            rectangle2D.add(d4 - d2, d5);
        }
        if (this.containsAngle(270.0)) {
            rectangle2D.add(d4, d5 + d3);
        }
        return rectangle2D;
    }

    protected abstract Rectangle2D makeBounds(double var1, double var3, double var5, double var7);

    public boolean containsAngle(double d) {
        double d2 = this.getAngleStart();
        double d3 = this.getAngleExtent();
        double d4 = d2 + d3;
        if (d3 == 0.0) {
            return false;
        }
        if (d3 >= 360.0 || d3 <= -360.0) {
            return true;
        }
        if (d3 < 0.0) {
            d4 = d2;
            d2 += d3;
        }
        d2 %= 360.0;
        while (d2 < 0.0) {
            d2 += 360.0;
        }
        d4 %= 360.0;
        while (d4 < d2) {
            d4 += 360.0;
        }
        d %= 360.0;
        while (d < d2) {
            d += 360.0;
        }
        return d >= d2 && d < d4;
    }

    public boolean contains(double d, double d2) {
        double d3 = this.getWidth();
        double d4 = this.getHeight();
        double d5 = this.getAngleExtent();
        if (d3 <= 0.0 || d4 <= 0.0 || d5 == 0.0) {
            return false;
        }
        double d6 = this.getX() + d3 / 2.0;
        double d7 = this.getY() + d4 / 2.0;
        double d8 = (d - d6) * 2.0 / d3;
        double d9 = (d2 - d7) * 2.0 / d4;
        double d10 = d8;
        double d11 = d9;
        if (d10 * d10 + d11 * d11 >= 1.0) {
            return false;
        }
        double d12 = Math.toDegrees(Math.atan2(-d9, d8));
        if (this.getArcType() == 2) {
            return this.containsAngle(d12);
        }
        double d13 = Math.toRadians(this.getAngleStart());
        double d14 = Math.toRadians(this.getAngleStart() + d5);
        double d15 = d6 + this.getWidth() * Math.cos(d13) / 2.0;
        double d16 = d7 - this.getHeight() * Math.sin(d13) / 2.0;
        double d17 = d6 + this.getWidth() * Math.cos(d14) / 2.0;
        double d18 = d7 - this.getHeight() * Math.sin(d14) / 2.0;
        double d19 = ((d17 - d15) * (d7 - d16) - (d6 - d15) * (d18 - d16)) * ((d17 - d15) * (d2 - d16) - (d - d15) * (d18 - d16));
        if (Math.abs(d5) > 180.0) {
            if (this.containsAngle(d12)) {
                return true;
            }
            return d19 > 0.0;
        }
        if (!this.containsAngle(d12)) {
            return false;
        }
        return d19 < 0.0;
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        double d5;
        double d6 = this.getAngleExtent();
        if (d6 == 0.0) {
            return false;
        }
        if (this.contains(d, d2) || this.contains(d, d2 + d4) || this.contains(d + d3, d2) || this.contains(d + d3, d2 + d4)) {
            return true;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, d3, d4);
        double d7 = this.getWidth() / 2.0;
        double d8 = this.getHeight() / 2.0;
        double d9 = this.getX() + d7;
        double d10 = this.getY() + d8;
        double d11 = d9 + d7 * Math.cos(Math.toRadians(this.getAngleStart()));
        double d12 = d10 - d8 * Math.sin(Math.toRadians(this.getAngleStart()));
        double d13 = d9 + d7 * Math.cos(Math.toRadians(this.getAngleStart() + d6));
        double d14 = d10 - d8 * Math.sin(Math.toRadians(this.getAngleStart() + d6));
        if (this.getArcType() != 1) {
            if (double_.intersectsLine(d9, d10, d11, d12)) {
                return true;
            }
            if (double_.intersectsLine(d9, d10, d13, d14)) {
                return true;
            }
        } else if (double_.intersectsLine(d11, d12, d13, d14)) {
            return true;
        }
        double d15 = d5 = d2 - d10;
        double d16 = d8;
        double d17 = d7 * Math.sqrt(1.0 - d15 * d15 / (d16 * d16));
        if (!java.lang.Double.isNaN(d17)) {
            if (d9 + d17 >= d && d9 + d17 <= d + d3 && this.containsAngle(Math.toDegrees(Math.atan2(-d5, d17)))) {
                return true;
            }
            if (d9 - d17 >= d && d9 - d17 <= d + d3 && this.containsAngle(Math.toDegrees(Math.atan2(-d5, -d17)))) {
                return true;
            }
        }
        double d18 = d5 = d2 + d4 - d10;
        double d19 = d8;
        d17 = d7 * Math.sqrt(1.0 - d18 * d18 / (d19 * d19));
        if (!java.lang.Double.isNaN(d17)) {
            if (d9 + d17 >= d && d9 + d17 <= d + d3 && this.containsAngle(Math.toDegrees(Math.atan2(-d5, d17)))) {
                return true;
            }
            if (d9 - d17 >= d && d9 - d17 <= d + d3 && this.containsAngle(Math.toDegrees(Math.atan2(-d5, -d17)))) {
                return true;
            }
        }
        double d20 = d17 = d - d9;
        double d21 = d7;
        d5 = d8 * Math.sqrt(1.0 - d20 * d20 / (d21 * d21));
        if (!java.lang.Double.isNaN(d5)) {
            if (d10 + d5 >= d2 && d10 + d5 <= d2 + d4 && this.containsAngle(Math.toDegrees(Math.atan2(-d5, d17)))) {
                return true;
            }
            if (d10 - d5 >= d2 && d10 - d5 <= d2 + d4 && this.containsAngle(Math.toDegrees(Math.atan2(d5, d17)))) {
                return true;
            }
        }
        double d22 = d17 = d + d3 - d9;
        double d23 = d7;
        d5 = d8 * Math.sqrt(1.0 - d22 * d22 / (d23 * d23));
        if (!java.lang.Double.isNaN(d5)) {
            if (d10 + d5 >= d2 && d10 + d5 <= d2 + d4 && this.containsAngle(Math.toDegrees(Math.atan2(-d5, d17)))) {
                return true;
            }
            if (d10 - d5 >= d2 && d10 - d5 <= d2 + d4 && this.containsAngle(Math.toDegrees(Math.atan2(d5, d17)))) {
                return true;
            }
        }
        return double_.contains(d9, d10);
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        double d5 = this.getAngleExtent();
        if (d5 == 0.0) {
            return false;
        }
        if (!(this.contains(d, d2) && this.contains(d, d2 + d4) && this.contains(d + d3, d2) && this.contains(d + d3, d2 + d4))) {
            return false;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, d3, d4);
        double d6 = this.getWidth() / 2.0;
        double d7 = this.getHeight() / 2.0;
        double d8 = this.getX() + d6;
        double d9 = this.getY() + d7;
        double d10 = d8 + d6 * Math.cos(Math.toRadians(this.getAngleStart()));
        double d11 = d9 - d7 * Math.sin(Math.toRadians(this.getAngleStart()));
        double d12 = d8 + d6 * Math.cos(Math.toRadians(this.getAngleStart() + d5));
        double d13 = d9 - d7 * Math.sin(Math.toRadians(this.getAngleStart() + d5));
        if (this.getArcType() != 1) {
            if (double_.intersectsLine(d8, d9, d10, d11)) {
                return false;
            }
            if (double_.intersectsLine(d8, d9, d12, d13)) {
                return false;
            }
        } else if (double_.intersectsLine(d10, d11, d12, d13)) {
            return false;
        }
        return true;
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new ArcIterator(this, affineTransform);
    }

    public static class Float
    extends Arc2D {
        public float x;
        public float y;
        public float width;
        public float height;
        public float start;
        public float extent;

        public Float() {
            super(0);
        }

        public Float(int n) {
            super(n);
        }

        public Float(float f, float f2, float f3, float f4, float f5, float f6, int n) {
            super(n);
            this.x = f;
            this.y = f2;
            this.width = f3;
            this.height = f4;
            this.start = f5;
            this.extent = f6;
        }

        public Float(Rectangle2D rectangle2D, float f, float f2, int n) {
            super(n);
            this.x = (float)rectangle2D.getX();
            this.y = (float)rectangle2D.getY();
            this.width = (float)rectangle2D.getWidth();
            this.height = (float)rectangle2D.getHeight();
            this.start = f;
            this.extent = f2;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public double getAngleStart() {
            return this.start;
        }

        public double getAngleExtent() {
            return this.extent;
        }

        public boolean isEmpty() {
            return this.width <= 0.0f || this.height <= 0.0f;
        }

        public void setArc(double d, double d2, double d3, double d4, double d5, double d6, int n) {
            this.x = (float)d;
            this.y = (float)d2;
            this.width = (float)d3;
            this.height = (float)d4;
            this.start = (float)d5;
            this.extent = (float)d6;
            this.setArcType(n);
        }

        public void setAngleStart(double d) {
            this.start = (float)d;
        }

        public void setAngleExtent(double d) {
            this.extent = (float)d;
        }

        protected Rectangle2D makeBounds(double d, double d2, double d3, double d4) {
            return new Rectangle2D.Float((float)d, (float)d2, (float)d3, (float)d4);
        }
    }

    public static class Double
    extends Arc2D {
        public double x;
        public double y;
        public double width;
        public double height;
        public double start;
        public double extent;

        public Double() {
            super(0);
        }

        public Double(int n) {
            super(n);
        }

        public Double(double d, double d2, double d3, double d4, double d5, double d6, int n) {
            super(n);
            this.x = d;
            this.y = d2;
            this.width = d3;
            this.height = d4;
            this.start = d5;
            this.extent = d6;
        }

        public Double(Rectangle2D rectangle2D, double d, double d2, int n) {
            super(n);
            this.x = rectangle2D.getX();
            this.y = rectangle2D.getY();
            this.width = rectangle2D.getWidth();
            this.height = rectangle2D.getHeight();
            this.start = d;
            this.extent = d2;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public double getAngleStart() {
            return this.start;
        }

        public double getAngleExtent() {
            return this.extent;
        }

        public boolean isEmpty() {
            return this.width <= 0.0 || this.height <= 0.0;
        }

        public void setArc(double d, double d2, double d3, double d4, double d5, double d6, int n) {
            this.x = d;
            this.y = d2;
            this.width = d3;
            this.height = d4;
            this.start = d5;
            this.extent = d6;
            this.setArcType(n);
        }

        public void setAngleStart(double d) {
            this.start = d;
        }

        public void setAngleExtent(double d) {
            this.extent = d;
        }

        protected Rectangle2D makeBounds(double d, double d2, double d3, double d4) {
            return new Rectangle2D.Double(d, d2, d3, d4);
        }
    }

    static final class ArcIterator
    implements PathIterator {
        private int current;
        private final int limit;
        private final AffineTransform xform;
        private final double x;
        private final double y;
        private final double w;
        private final double h;
        private final double start;
        private final double extent;
        private final int type;

        public ArcIterator(Arc2D arc2D, AffineTransform affineTransform) {
            this.xform = affineTransform;
            this.x = arc2D.getX();
            this.y = arc2D.getY();
            this.w = arc2D.getWidth();
            this.h = arc2D.getHeight();
            double d = arc2D.getAngleStart() * (Math.PI / 180);
            double d2 = arc2D.getAngleExtent() * (Math.PI / 180);
            if (d2 < 0.0) {
                d2 = -d2;
                d = Math.PI * 2 - d2 + d;
            }
            this.start = d;
            this.extent = d2;
            this.type = arc2D.type;
            this.limit = this.w < 0.0 || this.h < 0.0 ? -1 : (d2 == 0.0 ? this.type : (d2 <= 1.5707963267948966 ? this.type + 1 : (d2 <= Math.PI ? this.type + 2 : (d2 <= 4.71238898038469 ? this.type + 3 : this.type + 4))));
        }

        public ArcIterator(Ellipse2D ellipse2D, AffineTransform affineTransform) {
            this.xform = affineTransform;
            this.x = ellipse2D.getX();
            this.y = ellipse2D.getY();
            this.w = ellipse2D.getWidth();
            this.h = ellipse2D.getHeight();
            this.start = 0.0;
            this.extent = Math.PI * 2;
            this.type = 1;
            this.limit = this.w < 0.0 || this.h < 0.0 ? -1 : 5;
        }

        public int getWindingRule() {
            return 1;
        }

        public boolean isDone() {
            return this.current > this.limit;
        }

        public void next() {
            ++this.current;
        }

        public int currentSegment(float[] fArray) {
            double[] dArray = new double[6];
            int n = this.currentSegment(dArray);
            for (int i = 0; i < 6; ++i) {
                fArray[i] = (float)dArray[i];
            }
            return n;
        }

        public int currentSegment(double[] dArray) {
            double d = this.w / 2.0;
            double d2 = this.h / 2.0;
            double d3 = this.x + d;
            double d4 = this.y + d2;
            if (this.current > this.limit) {
                throw new NoSuchElementException("arc iterator out of bounds");
            }
            if (this.current == 0) {
                dArray[0] = d3 + d * Math.cos(this.start);
                dArray[1] = d4 - d2 * Math.sin(this.start);
                if (this.xform != null) {
                    this.xform.transform(dArray, 0, dArray, 0, 1);
                }
                return 0;
            }
            if (this.type != 0 && this.current == this.limit) {
                return 4;
            }
            if (this.current == this.limit - 1 && this.type == 2) {
                dArray[0] = d3;
                dArray[1] = d4;
                if (this.xform != null) {
                    this.xform.transform(dArray, 0, dArray, 0, 1);
                }
                return 1;
            }
            double d5 = (Math.sqrt(2.0) - 1.0) * 1.3333333333333333;
            double d6 = 1.5707963267948966;
            double d7 = this.start + (double)(this.current - 1) * d6;
            double d8 = Math.min(this.start + this.extent - d7, d6);
            double d9 = d8 / d6;
            double d10 = d3 + d * Math.cos(d7);
            double d11 = d4 - d2 * Math.sin(d7);
            double d12 = d3 + d * Math.cos(d7 + d8);
            double d13 = d4 - d2 * Math.sin(d7 + d8);
            AffineTransform affineTransform = new AffineTransform();
            double[] dArray2 = new double[2];
            double d14 = d5 * d9;
            double d15 = d7;
            dArray2[0] = 0.0;
            dArray2[1] = d14;
            affineTransform.scale(d, d2);
            affineTransform.rotate(d15);
            affineTransform.transform(dArray2, 0, dArray2, 0, 1);
            dArray[0] = d10 + dArray2[0];
            dArray[1] = d11 - dArray2[1];
            dArray2[0] = 0.0;
            dArray2[1] = -d14;
            affineTransform.rotate(d8);
            affineTransform.transform(dArray2, 0, dArray2, 0, 1);
            dArray[2] = d12 + dArray2[0];
            dArray[3] = d13 - dArray2[1];
            dArray[4] = d12;
            dArray[5] = d13;
            if (this.xform != null) {
                this.xform.transform(dArray, 0, dArray, 0, 3);
            }
            return 3;
        }
    }
}

