/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.ItemSelectable;
import java.awt.MenuItem;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.CheckboxMenuItemPeer;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleValue;

public class CheckboxMenuItem
extends MenuItem
implements ItemSelectable,
Accessible {
    private static transient long next_chkmenuitem_number;
    private static final long serialVersionUID = 6190621106981774043L;
    private boolean state;
    private transient ItemListener item_listeners;

    public CheckboxMenuItem() {
        this("", false);
    }

    public CheckboxMenuItem(String string) {
        this(string, false);
    }

    public CheckboxMenuItem(String string, boolean bl) {
        super(string);
        this.state = bl;
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
    }

    public boolean getState() {
        return this.state;
    }

    public synchronized void setState(boolean bl) {
        this.state = bl;
        if (this.peer != null) {
            CheckboxMenuItemPeer checkboxMenuItemPeer = (CheckboxMenuItemPeer)this.peer;
            checkboxMenuItemPeer.setState(bl);
        }
    }

    public Object[] getSelectedObjects() {
        if (!this.state) {
            return null;
        }
        Object[] objectArray = new Object[]{this.getLabel()};
        return objectArray;
    }

    public synchronized void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createCheckboxMenuItem(this);
        }
        super.addNotify();
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        this.item_listeners = AWTEventMulticaster.add(this.item_listeners, itemListener);
        this.enableEvents(512);
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        this.item_listeners = AWTEventMulticaster.remove(this.item_listeners, itemListener);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        if (this.item_listeners != null) {
            this.item_listeners.itemStateChanged(itemEvent);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void dispatchEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ItemEvent) {
            CheckboxMenuItem checkboxMenuItem = this;
            // MONITORENTER : checkboxMenuItem
            try {
                this.state = ((ItemEvent)aWTEvent).getStateChange() == 1;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                // MONITOREXIT : checkboxMenuItem
                throw throwable;
            }
            Object var3_3 = null;
            // MONITOREXIT : checkboxMenuItem
        }
        if (aWTEvent.id <= 701 && aWTEvent.id >= 701 && (this.item_listeners != null || (this.eventMask & (long)512) != 0L)) {
            this.processEvent(aWTEvent);
            return;
        }
        super.dispatchEventImpl(aWTEvent);
    }

    public String paramString() {
        return "label=" + this.getLabel() + ",state=" + this.state + "," + super.paramString();
    }

    public EventListener[] getListeners(Class clazz) {
        if (clazz == CheckboxMenuItem.class$("java.awt.event.ItemListener")) {
            return AWTEventMulticaster.getListeners(this.item_listeners, clazz);
        }
        return super.getListeners(clazz);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])this.getListeners(CheckboxMenuItem.class$("java.awt.event.ItemListener"));
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTCheckboxMenuItem(this);
        }
        return this.accessibleContext;
    }

    String generateName() {
        return "chkmenuitem" + CheckboxMenuItem.getUniqueLong();
    }

    private static synchronized long getUniqueLong() {
        return next_chkmenuitem_number++;
    }

    protected class AccessibleAWTCheckboxMenuItem
    extends MenuItem.AccessibleAWTMenuItem
    implements AccessibleAction,
    AccessibleValue {
        private /* synthetic */ CheckboxMenuItem this$0;
        private static final long serialVersionUID = -1122642964303476L;

        protected AccessibleAWTCheckboxMenuItem(CheckboxMenuItem checkboxMenuItem) {
            this.this$0 = checkboxMenuItem;
            super(checkboxMenuItem);
        }
    }
}

