/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.sound.midi.file;

import gnu.javax.sound.midi.file.MidiDataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.Sequence;
import javax.sound.midi.Track;

public class MidiFileWriter
extends javax.sound.midi.spi.MidiFileWriter {
    public int[] getMidiFileTypes() {
        return new int[]{0, 1};
    }

    public int[] getMidiFileTypes(Sequence sequence) {
        if (sequence.getTracks().length == 1) {
            return new int[]{0};
        }
        return new int[]{1};
    }

    public int write(Sequence sequence, int n, OutputStream outputStream) throws IOException {
        MidiDataOutputStream midiDataOutputStream = new MidiDataOutputStream(outputStream);
        Track[] trackArray = sequence.getTracks();
        midiDataOutputStream.writeInt(1297377380);
        midiDataOutputStream.writeInt(6);
        midiDataOutputStream.writeShort(n);
        midiDataOutputStream.writeShort(trackArray.length);
        float f = sequence.getDivisionType();
        int n2 = sequence.getResolution();
        int n3 = 0;
        if (f == 0.0f) {
            n3 = n2 & Short.MAX_VALUE;
        }
        midiDataOutputStream.writeShort(n3);
        int n4 = 14;
        for (int i = 0; i < trackArray.length; ++i) {
            n4 += this.writeTrack(trackArray[i], midiDataOutputStream);
        }
        return n4;
    }

    private int computeTrackLength(Track track, MidiDataOutputStream midiDataOutputStream) {
        boolean bl = false;
        int n = 0;
        int n2 = track.size();
        long l = 0L;
        for (int i = 0; i < n2; ++i) {
            MidiEvent midiEvent = track.get(i);
            long l2 = midiEvent.getTick();
            n += midiDataOutputStream.variableLengthIntLength((int)l2 - (int)l);
            l = l2;
            n += midiEvent.getMessage().getLength();
        }
        return n;
    }

    private int writeTrack(Track track, MidiDataOutputStream midiDataOutputStream) throws IOException {
        Object object;
        int n = track.size();
        Object object2 = null;
        midiDataOutputStream.writeInt(1297379947);
        int n2 = this.computeTrackLength(track, midiDataOutputStream);
        midiDataOutputStream.writeInt(n2);
        for (int i = 0; i < n; ++i) {
            object = track.get(i);
            int n3 = 0;
            if (object2 != null) {
                n3 = (int)((MidiEvent)object).getTick() - (int)((MidiEvent)object2).getTick();
            }
            midiDataOutputStream.writeVariableLengthInt(n3);
            byte[] byArray = ((MidiEvent)object).getMessage().getMessage();
            midiDataOutputStream.write(byArray);
            object2 = object;
        }
        if (object2 != null && ((MidiEvent)object2).getMessage() instanceof MetaMessage && ((MetaMessage)(object = (MetaMessage)((MidiEvent)object2).getMessage())).getType() == 47) {
            return n2 + 8;
        }
        midiDataOutputStream.writeVariableLengthInt(0);
        midiDataOutputStream.writeByte(255);
        midiDataOutputStream.writeByte(47);
        midiDataOutputStream.writeVariableLengthInt(0);
        return n2 + 8 + 4;
    }

    public int write(Sequence sequence, int n, File file) throws IOException {
        int n2;
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            n2 = this.write(sequence, n, fileOutputStream);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            ((OutputStream)fileOutputStream).close();
            throw throwable;
        }
        ((OutputStream)fileOutputStream).close();
        return n2;
    }
}

