/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.crypto.key.dh.GnuDHPublicKey;
import gnu.javax.crypto.key.srp6.SRPPublicKey;
import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.Handshake;
import gnu.javax.net.ssl.provider.JessieRSAPublicKey;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.Signature;
import gnu.javax.net.ssl.provider.Util;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.net.ssl.SSLProtocolException;

class ServerKeyExchange
implements Handshake.Body {
    private PublicKey publicKey;
    private Signature signature;
    private byte[] srpSalt;

    ServerKeyExchange(PublicKey publicKey, Signature signature) {
        this(publicKey, signature, null);
    }

    ServerKeyExchange(PublicKey publicKey, Signature signature, byte[] byArray) {
        this.publicKey = publicKey;
        this.signature = signature;
        this.srpSalt = byArray;
    }

    static ServerKeyExchange read(InputStream inputStream, CipherSuite cipherSuite, PublicKey publicKey) throws IOException {
        Object object;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        PublicKey publicKey2 = null;
        byte[] byArray = null;
        String string = cipherSuite.getKeyExchange();
        if (string.equals("DHE")) {
            object = new byte[dataInputStream.readUnsignedShort()];
            dataInputStream.readFully((byte[])object);
            BigInteger bigInteger = new BigInteger(1, (byte[])object);
            object = new byte[dataInputStream.readUnsignedShort()];
            dataInputStream.readFully((byte[])object);
            BigInteger bigInteger2 = new BigInteger(1, (byte[])object);
            object = new byte[dataInputStream.readUnsignedShort()];
            dataInputStream.readFully((byte[])object);
            BigInteger bigInteger3 = new BigInteger(1, (byte[])object);
            publicKey2 = new GnuDHPublicKey(null, bigInteger, bigInteger2, bigInteger3);
        } else if (string.equals("RSA")) {
            object = new byte[dataInputStream.readUnsignedShort()];
            dataInputStream.readFully((byte[])object);
            BigInteger bigInteger = new BigInteger(1, (byte[])object);
            object = new byte[dataInputStream.readUnsignedShort()];
            dataInputStream.readFully((byte[])object);
            BigInteger bigInteger4 = new BigInteger(1, (byte[])object);
            publicKey2 = new JessieRSAPublicKey(bigInteger, bigInteger4);
        } else if (string.equals("SRP")) {
            object = new byte[dataInputStream.readUnsignedShort()];
            dataInputStream.readFully((byte[])object);
            BigInteger bigInteger = new BigInteger(1, (byte[])object);
            object = new byte[dataInputStream.readUnsignedShort()];
            dataInputStream.readFully((byte[])object);
            BigInteger bigInteger5 = new BigInteger(1, (byte[])object);
            byArray = new byte[dataInputStream.readUnsignedByte()];
            dataInputStream.readFully(byArray);
            object = new byte[dataInputStream.readUnsignedShort()];
            dataInputStream.readFully((byte[])object);
            BigInteger bigInteger6 = new BigInteger(1, (byte[])object);
            try {
                publicKey2 = new SRPPublicKey(bigInteger, bigInteger5, bigInteger6);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new SSLProtocolException(illegalArgumentException.getMessage());
            }
        } else {
            throw new SSLProtocolException("invalid kex algorithm");
        }
        object = null;
        if (!cipherSuite.getSignature().equals("anon")) {
            object = Signature.read(inputStream, cipherSuite, publicKey);
        }
        return new ServerKeyExchange(publicKey2, (Signature)object, byArray);
    }

    public void write(OutputStream outputStream) throws IOException {
        this.write(outputStream, ProtocolVersion.TLS_1);
    }

    public void write(OutputStream outputStream, ProtocolVersion protocolVersion) throws IOException {
        if (this.publicKey instanceof DHPublicKey) {
            this.writeBigint(outputStream, ((DHPublicKey)this.publicKey).getParams().getP());
            this.writeBigint(outputStream, ((DHPublicKey)this.publicKey).getParams().getG());
            this.writeBigint(outputStream, ((DHPublicKey)this.publicKey).getY());
        } else if (this.publicKey instanceof RSAPublicKey) {
            this.writeBigint(outputStream, ((RSAPublicKey)this.publicKey).getModulus());
            this.writeBigint(outputStream, ((RSAPublicKey)this.publicKey).getPublicExponent());
        } else if (this.publicKey instanceof SRPPublicKey) {
            this.writeBigint(outputStream, ((SRPPublicKey)this.publicKey).getN());
            this.writeBigint(outputStream, ((SRPPublicKey)this.publicKey).getG());
            outputStream.write(this.srpSalt.length);
            outputStream.write(this.srpSalt);
            this.writeBigint(outputStream, ((SRPPublicKey)this.publicKey).getY());
        }
        if (this.signature != null) {
            this.signature.write(outputStream, protocolVersion);
        }
    }

    PublicKey getPublicKey() {
        return this.publicKey;
    }

    Signature getSignature() {
        return this.signature;
    }

    byte[] getSRPSalt() {
        return this.srpSalt;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("struct {");
        printWriter.println("  publicKey = struct {");
        if (this.publicKey instanceof DHPublicKey) {
            printWriter.println("    p = " + ((DHPublicKey)this.publicKey).getParams().getP().toString(16) + ";");
            printWriter.println("    g = " + ((DHPublicKey)this.publicKey).getParams().getG().toString(16) + ";");
            printWriter.println("    y = " + ((DHPublicKey)this.publicKey).getY().toString(16) + ";");
            printWriter.println("  } DHPublicKey;");
        } else if (this.publicKey instanceof RSAPublicKey) {
            printWriter.println("    modulus = " + ((RSAPublicKey)this.publicKey).getModulus().toString(16) + ";");
            printWriter.println("    exponent = " + ((RSAPublicKey)this.publicKey).getPublicExponent().toString(16) + ";");
            printWriter.println("  } RSAPublicKey;");
        } else if (this.publicKey instanceof SRPPublicKey) {
            printWriter.println("    N = " + ((SRPPublicKey)this.publicKey).getN().toString(16) + ";");
            printWriter.println("    g = " + ((SRPPublicKey)this.publicKey).getG().toString(16) + ";");
            printWriter.println("    salt = " + Util.toHexString(this.srpSalt, ':') + ";");
            printWriter.println("    B = " + ((SRPPublicKey)this.publicKey).getY().toString(16) + ";");
            printWriter.println("  } SRPPublicKey;");
        }
        if (this.signature != null) {
            printWriter.println("  signature =");
            BufferedReader bufferedReader = new BufferedReader(new StringReader(this.signature.toString()));
            try {
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    printWriter.print("    ");
                    printWriter.println(string);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        printWriter.println("} ServerKeyExchange;");
        return stringWriter.toString();
    }

    private void writeBigint(OutputStream outputStream, BigInteger bigInteger) throws IOException {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray[0] == 0) {
            outputStream.write(byArray.length - 1 >>> 8 & 0xFF);
            outputStream.write(byArray.length - 1 & 0xFF);
            outputStream.write(byArray, 1, byArray.length - 1);
        } else {
            outputStream.write(byArray.length >>> 8 & 0xFF);
            outputStream.write(byArray.length & 0xFF);
            outputStream.write(byArray);
        }
    }
}

