/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.bmp;

import gnu.javax.imageio.bmp.BMPEncoder;
import gnu.javax.imageio.bmp.BMPException;
import gnu.javax.imageio.bmp.BMPFileHeader;
import gnu.javax.imageio.bmp.BMPInfoHeader;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import javax.imageio.IIOImage;
import javax.imageio.ImageWriteParam;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;

public class EncodeRLE4
extends BMPEncoder {
    protected BMPInfoHeader infoHeader;
    protected BMPFileHeader fileHeader;
    protected long offset;
    private static final byte ESCAPE = 0;
    private static final byte EOL = 0;
    private static final byte EOB = 1;
    private static final byte DELTA = 2;

    public EncodeRLE4(BMPFileHeader bMPFileHeader, BMPInfoHeader bMPInfoHeader) {
        this.fileHeader = bMPFileHeader;
        this.infoHeader = bMPInfoHeader;
        this.offset = 54;
    }

    public void encode(ImageOutputStream imageOutputStream, IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        int n;
        int n2 = this.infoHeader.biWidth * this.infoHeader.biHeight - 1;
        int n3 = 1;
        int n4 = n = n2 - this.infoHeader.biWidth;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        try {
            int[] nArray = new int[this.infoHeader.biWidth * this.infoHeader.biHeight];
            PixelGrabber pixelGrabber = new PixelGrabber((BufferedImage)iIOImage.getRenderedImage(), 0, 0, this.infoHeader.biWidth, this.infoHeader.biHeight, nArray, 0, this.infoHeader.biWidth);
            pixelGrabber.grabPixels();
            for (int i = 0; i < n2; ++i) {
                int n5 = nArray[n];
                byteBuffer.put((byte)n5);
                if (n3 == this.infoHeader.biWidth) {
                    n3 = 1;
                    n4 = n = n4 - this.infoHeader.biWidth;
                } else {
                    ++n3;
                }
                ++n;
            }
            byteBuffer.flip();
            imageOutputStream.write(this.uncompress(this.infoHeader.biWidth, this.infoHeader.biHeight, byteBuffer));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] uncompress(int n, int n2, ByteBuffer byteBuffer) throws IOException {
        byte[] byArray = new byte[2];
        byte[] byArray2 = new byte[n * n2 >> 1];
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        n += n & 1;
        n >>= 1;
        try {
            block13: while (true) {
                block24: {
                    int n5;
                    int n6;
                    block23: {
                        block22: {
                            byte[] byArray3;
                            int n7;
                            block21: {
                                block20: {
                                    if ((n3 >> 1) + n4 * n >= n * n2) {
                                        return byArray2;
                                    }
                                    try {
                                        byteBuffer.get(byArray);
                                    }
                                    catch (BufferUnderflowException bufferUnderflowException) {
                                        throw new IOException("Error reading compressed data.");
                                    }
                                    if (byArray[0] != 0) break block20;
                                    switch (byArray[1]) {
                                        case 1: {
                                            return byArray2;
                                        }
                                        case 0: {
                                            n3 = 0;
                                            ++n4;
                                            continue block13;
                                        }
                                        case 2: {
                                            try {
                                                byteBuffer.get(byArray);
                                            }
                                            catch (BufferUnderflowException bufferUnderflowException) {
                                                throw new IOException("Error reading compressed data.");
                                            }
                                            n6 = byArray[0] & 0xFF;
                                            n5 = byArray[1] & 0xFF;
                                            n3 += n6;
                                            n4 += n5;
                                            continue block13;
                                        }
                                    }
                                    int n8 = n7 = byArray[1] & 0xFF;
                                    n8 += n8 & 1;
                                    n8 >>= 1;
                                    n8 += n8 & 1;
                                    byArray3 = new byte[n8];
                                    try {
                                        byteBuffer.get(byArray3);
                                    }
                                    catch (BufferUnderflowException bufferUnderflowException) {
                                        throw new IOException("Error reading compressed data.");
                                    }
                                    if ((n3 & 1) != 0) break block21;
                                    n7 += n7 & 1;
                                    System.arraycopy(byArray3, 0, byArray2, (n3 >> 1) + n * (n2 - n4 - 1), n7 >>= 1);
                                    break block22;
                                }
                                n6 = byArray[0] & 0xFF;
                                if ((n3 & 1) != 0) break block23;
                                n6 += n6 & 1;
                                n6 >>= 1;
                                for (n5 = 0; n5 < n6; ++n5) {
                                    byArray2[(n2 - n4 - 1) * n + n5 + (n3 >> 1)] = byArray[1];
                                }
                                break block24;
                            }
                            for (int i = 0; i < n7; ++i) {
                                if ((i & 1) == 0) {
                                    int n9 = (n3 + i >> 1) + n * (n2 - n4 - 1);
                                    byArray2[n9] = byArray2[n9] | (byte)((byArray3[i >> 1] & 0xF0) >> 4);
                                    continue;
                                }
                                int n10 = (n3 + i >> 1) + n * (n2 - n4 - 1);
                                byArray2[n10] = byArray2[n10] | (byte)((byArray3[i >> 1] & 0xF) << 4);
                            }
                        }
                        n3 += byArray[1] & 0xFF;
                        continue;
                    }
                    for (n5 = 0; n5 < n6; ++n5) {
                        if ((n5 & 1) == 0) {
                            int n11 = (n3 + n5 >> 1) + n * (n2 - n4 - 1);
                            byArray2[n11] = byArray2[n11] | (byte)((byArray[1] & 0xF0) >> 4);
                            continue;
                        }
                        int n12 = (n3 + n5 >> 1) + n * (n2 - n4 - 1);
                        byArray2[n12] = byArray2[n12] | (byte)((byArray[1] & 0xF) << 4);
                    }
                }
                n3 += byArray[0] & 0xFF;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new BMPException("Invalid RLE data.");
        }
    }
}

