/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.bmp;

import gnu.javax.imageio.bmp.BMPDecoder;
import gnu.javax.imageio.bmp.BMPException;
import gnu.javax.imageio.bmp.BMPFileHeader;
import gnu.javax.imageio.bmp.BMPInfoHeader;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

public class DecodeBF16
extends BMPDecoder {
    private int[] bitmasks;
    private boolean useDefaultMasks;

    public DecodeBF16(BMPFileHeader bMPFileHeader, BMPInfoHeader bMPInfoHeader, boolean bl) {
        super(bMPFileHeader, bMPInfoHeader);
        this.useDefaultMasks = bl;
        if (this.useDefaultMasks) {
            this.bitmasks = new int[]{63488, 2016, 31};
        }
    }

    public BufferedImage decode(ImageInputStream imageInputStream) throws IOException, BMPException {
        Object object;
        if (!this.useDefaultMasks) {
            this.bitmasks = this.readBitMasks(imageInputStream);
        }
        this.skipToImage(imageInputStream);
        Dimension dimension = this.infoHeader.getSize();
        int n = (int)dimension.getHeight();
        int n2 = (int)dimension.getWidth();
        int n3 = n2 + (n2 & 1) << 1;
        short[] sArray = new short[n2 * n];
        for (int i = n - 1; i >= 0; --i) {
            object = new byte[n3];
            if (imageInputStream.read((byte[])object) != n3) {
                throw new IOException("Couldn't read image data.");
            }
            for (int j = 0; j < n2; ++j) {
                sArray[j + i * n2] = (short)object[j * 2] & 0xFF | (short)((object[j * 2 + 1] & 0xFF) << 8);
            }
        }
        DirectColorModel directColorModel = new DirectColorModel(16, this.bitmasks[0], this.bitmasks[1], this.bitmasks[2]);
        object = new SinglePixelPackedSampleModel(1, n2, n, this.bitmasks);
        DataBufferUShort dataBufferUShort = new DataBufferUShort(sArray, n2 * n, 0);
        WritableRaster writableRaster = Raster.createWritableRaster((SampleModel)object, dataBufferUShort, null);
        return new BufferedImage(directColorModel, writableRaster, false, null);
    }
}

