/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.sasl.srp;

public interface SRPRegistry {
    public static final String N_2048_BITS = "1";
    public static final String N_1536_BITS = "2";
    public static final String N_1280_BITS = "3";
    public static final String N_1024_BITS = "4";
    public static final String N_768_BITS = "5";
    public static final String N_640_BITS = "6";
    public static final String N_512_BITS = "7";
    public static final String[] SRP_ALGORITHMS;
    public static final String SRP_DEFAULT_DIGEST_NAME;
    public static final String SRP_DIGEST_NAME = "srp.digest.name";
    public static final String SHARED_MODULUS = "srp.N";
    public static final String FIELD_GENERATOR = "srp.g";
    public static final String AVAILABLE_OPTIONS = "srp.L";
    public static final String CHOSEN_OPTIONS = "srp.o";
    public static final String USER_NAME = "srp.U";
    public static final String USER_ROLE = "srp.I";
    public static final String USER_SALT = "srp.s";
    public static final String PASSWORD_VERIFIER = "srp.v";
    public static final String CLIENT_PUBLIC_KEY = "srp.A";
    public static final String SERVER_PUBLIC_KEY = "srp.B";
    public static final String CLIENT_EVIDENCE = "srp.M1";
    public static final String SERVER_EVIDENCE = "srp.M2";
    public static final String SRP_HASH = "gnu.crypto.sasl.srp.hash";
    public static final String SRP_MANDATORY = "gnu.crypto.sasl.srp.mandatory";
    public static final String SRP_REPLAY_DETECTION = "gnu.crypto.sasl.srp.replay.detection";
    public static final String SRP_INTEGRITY_PROTECTION = "gnu.crypto.sasl.srp.integrity";
    public static final String SRP_CONFIDENTIALITY = "gnu.crypto.sasl.srp.confidentiality";
    public static final String PASSWORD_FILE = "gnu.crypto.sasl.srp.password.file";
    public static final String PASSWORD_DB = "gnu.crypto.sasl.srp.password.db";
    public static final String DEFAULT_PASSWORD_FILE = "/etc/tpasswd";
    public static final boolean DEFAULT_REPLAY_DETECTION = true;
    public static final boolean DEFAULT_INTEGRITY = true;
    public static final boolean DEFAULT_CONFIDENTIALITY = false;
    public static final String HMAC_SHA1 = "hmac-sha1";
    public static final String HMAC_MD5 = "hmac-md5";
    public static final String HMAC_RIPEMD_160 = "hmac-ripemd-160";
    public static final String[] INTEGRITY_ALGORITHMS;
    public static final String AES = "aes";
    public static final String BLOWFISH = "blowfish";
    public static final String[] CONFIDENTIALITY_ALGORITHMS;
    public static final String OPTION_MANDATORY = "mandatory";
    public static final String OPTION_SRP_DIGEST = "mda";
    public static final String OPTION_REPLAY_DETECTION = "replay_detection";
    public static final String OPTION_INTEGRITY = "integrity";
    public static final String OPTION_CONFIDENTIALITY = "confidentiality";
    public static final String OPTION_MAX_BUFFER_SIZE = "maxbuffersize";
    public static final String MANDATORY_NONE = "none";
    public static final String DEFAULT_MANDATORY = "replay_detection";
    public static final String MD_NAME_FIELD = "srp.md.name";
    public static final String USER_VERIFIER_FIELD = "srp.user.verifier";
    public static final String SALT_FIELD = "srp.salt";
    public static final String CONFIG_NDX_FIELD = "srp.config.ndx";
    public static final int MINIMUM_MODULUS_BITLENGTH = 512;

    static {
        N_2048_BITS = N_2048_BITS;
        N_1536_BITS = N_1536_BITS;
        N_1280_BITS = N_1280_BITS;
        N_1024_BITS = N_1024_BITS;
        N_768_BITS = N_768_BITS;
        N_640_BITS = N_640_BITS;
        N_512_BITS = N_512_BITS;
        SRP_ALGORITHMS = new String[]{"sha-160", "md5", "ripemd128", "ripemd160", "sha-256", "sha-384", "sha-512"};
        SRP_DEFAULT_DIGEST_NAME = SRP_ALGORITHMS[0];
        SRP_DIGEST_NAME = SRP_DIGEST_NAME;
        SHARED_MODULUS = SHARED_MODULUS;
        FIELD_GENERATOR = FIELD_GENERATOR;
        AVAILABLE_OPTIONS = AVAILABLE_OPTIONS;
        CHOSEN_OPTIONS = CHOSEN_OPTIONS;
        USER_NAME = USER_NAME;
        USER_ROLE = USER_ROLE;
        USER_SALT = USER_SALT;
        PASSWORD_VERIFIER = PASSWORD_VERIFIER;
        CLIENT_PUBLIC_KEY = CLIENT_PUBLIC_KEY;
        SERVER_PUBLIC_KEY = SERVER_PUBLIC_KEY;
        CLIENT_EVIDENCE = CLIENT_EVIDENCE;
        SERVER_EVIDENCE = SERVER_EVIDENCE;
        SRP_HASH = SRP_HASH;
        SRP_MANDATORY = SRP_MANDATORY;
        SRP_REPLAY_DETECTION = SRP_REPLAY_DETECTION;
        SRP_INTEGRITY_PROTECTION = SRP_INTEGRITY_PROTECTION;
        SRP_CONFIDENTIALITY = SRP_CONFIDENTIALITY;
        PASSWORD_FILE = PASSWORD_FILE;
        PASSWORD_DB = PASSWORD_DB;
        DEFAULT_PASSWORD_FILE = DEFAULT_PASSWORD_FILE;
        HMAC_SHA1 = HMAC_SHA1;
        HMAC_MD5 = HMAC_MD5;
        HMAC_RIPEMD_160 = HMAC_RIPEMD_160;
        INTEGRITY_ALGORITHMS = new String[]{HMAC_SHA1, HMAC_MD5, HMAC_RIPEMD_160};
        AES = AES;
        BLOWFISH = BLOWFISH;
        CONFIDENTIALITY_ALGORITHMS = new String[]{AES, BLOWFISH};
        OPTION_MANDATORY = OPTION_MANDATORY;
        OPTION_SRP_DIGEST = OPTION_SRP_DIGEST;
        OPTION_REPLAY_DETECTION = "replay_detection";
        OPTION_INTEGRITY = OPTION_INTEGRITY;
        OPTION_CONFIDENTIALITY = OPTION_CONFIDENTIALITY;
        OPTION_MAX_BUFFER_SIZE = OPTION_MAX_BUFFER_SIZE;
        MANDATORY_NONE = MANDATORY_NONE;
        DEFAULT_MANDATORY = "replay_detection";
        MD_NAME_FIELD = MD_NAME_FIELD;
        USER_VERIFIER_FIELD = USER_VERIFIER_FIELD;
        SALT_FIELD = SALT_FIELD;
        CONFIG_NDX_FIELD = CONFIG_NDX_FIELD;
    }
}

