/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.key.dss;

import gnu.java.security.hash.Sha160;
import gnu.java.security.key.IKeyPairGenerator;
import gnu.java.security.key.dss.DSSPrivateKey;
import gnu.java.security.key.dss.DSSPublicKey;
import gnu.java.security.key.dss.FIPS186;
import gnu.java.security.util.PRNG;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.security.spec.DSAParameterSpec;
import java.util.Map;
import java.util.logging.Logger;

public class DSSKeyPairGenerator
implements IKeyPairGenerator {
    private static final Logger log = Logger.getLogger(DSSKeyPairGenerator.class$("gnu.java.security.key.dss.DSSKeyPairGenerator").getName());
    private static final BigInteger TWO = BigInteger.valueOf(2);
    public static final String MODULUS_LENGTH = "gnu.crypto.dss.L";
    public static final String USE_DEFAULTS = "gnu.crypto.dss.use.defaults";
    public static final String STRICT_DEFAULTS = "gnu.crypto.dss.strict.defaults";
    public static final String SOURCE_OF_RANDOMNESS = "gnu.crypto.dss.prng";
    public static final String DSS_PARAMETERS = "gnu.crypto.dss.params";
    public static final String PREFERRED_ENCODING_FORMAT = "gnu.crypto.dss.encoding";
    public static final int DEFAULT_MODULUS_LENGTH = 1024;
    private static final int DEFAULT_ENCODING_FORMAT = 1;
    private static final int[] T_SHS;
    public static final DSAParameterSpec KEY_PARAMS_512;
    public static final DSAParameterSpec KEY_PARAMS_768;
    public static final DSAParameterSpec KEY_PARAMS_1024;
    private static final BigInteger TWO_POW_160;
    private int L;
    private SecureRandom rnd;
    private BigInteger seed;
    private BigInteger counter;
    private BigInteger p;
    private BigInteger q;
    private BigInteger e;
    private BigInteger g;
    private BigInteger XKEY;
    private PRNG prng;
    private int preferredFormat;

    private /* synthetic */ void finit$() {
        this.rnd = null;
        this.prng = null;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public String name() {
        return "dss";
    }

    public void setup(Map map) {
        DSAParameterSpec dSAParameterSpec;
        Boolean bl;
        Integer n = (Integer)map.get(MODULUS_LENGTH);
        int n2 = this.L = n == null ? 1024 : n;
        if (this.L % 64 != 0 || this.L < 512 || this.L > 1024) {
            throw new IllegalArgumentException(MODULUS_LENGTH);
        }
        Boolean bl2 = (Boolean)map.get(USE_DEFAULTS);
        if (bl2 == null) {
            bl2 = Boolean.TRUE;
        }
        if ((bl = (Boolean)map.get(STRICT_DEFAULTS)) == null) {
            bl = Boolean.FALSE;
        }
        if ((dSAParameterSpec = (DSAParameterSpec)map.get(DSS_PARAMETERS)) != null) {
            this.p = dSAParameterSpec.getP();
            this.q = dSAParameterSpec.getQ();
            this.g = dSAParameterSpec.getG();
        } else if (bl2.equals(Boolean.TRUE)) {
            switch (this.L) {
                case 512: {
                    this.p = KEY_PARAMS_512.getP();
                    this.q = KEY_PARAMS_512.getQ();
                    this.g = KEY_PARAMS_512.getG();
                    break;
                }
                case 768: {
                    this.p = KEY_PARAMS_768.getP();
                    this.q = KEY_PARAMS_768.getQ();
                    this.g = KEY_PARAMS_768.getG();
                    break;
                }
                case 1024: {
                    this.p = KEY_PARAMS_1024.getP();
                    this.q = KEY_PARAMS_1024.getQ();
                    this.g = KEY_PARAMS_1024.getG();
                    break;
                }
                default: {
                    if (bl.equals(Boolean.TRUE)) {
                        throw new IllegalArgumentException("Does not provide default parameters for " + this.L + "-bit modulus length");
                    }
                    this.p = null;
                    this.q = null;
                    this.g = null;
                    break;
                }
            }
        } else {
            this.p = null;
            this.q = null;
            this.g = null;
        }
        this.rnd = (SecureRandom)map.get(SOURCE_OF_RANDOMNESS);
        Integer n3 = (Integer)map.get(PREFERRED_ENCODING_FORMAT);
        this.preferredFormat = n3 == null ? 1 : n3;
        byte[] byArray = new byte[20];
        this.nextRandomBytes(byArray);
        this.XKEY = new BigInteger(1, byArray).setBit(159).setBit(0);
    }

    public KeyPair generate() {
        BigInteger[] bigIntegerArray;
        if (this.p == null) {
            bigIntegerArray = new FIPS186(this.L, this.rnd).generateParameters();
            this.seed = bigIntegerArray[0];
            this.counter = bigIntegerArray[1];
            this.q = bigIntegerArray[2];
            this.p = bigIntegerArray[3];
            this.e = bigIntegerArray[4];
            this.g = bigIntegerArray[5];
        }
        bigIntegerArray = this.nextX();
        BigInteger bigInteger = this.g.modPow((BigInteger)bigIntegerArray, this.p);
        DSSPublicKey dSSPublicKey = new DSSPublicKey(this.preferredFormat, this.p, this.q, this.g, bigInteger);
        DSSPrivateKey dSSPrivateKey = new DSSPrivateKey(this.preferredFormat, this.p, this.q, this.g, (BigInteger)bigIntegerArray);
        return new KeyPair(dSSPublicKey, dSSPrivateKey);
    }

    private synchronized BigInteger nextX() {
        byte[] byArray = this.XKEY.toByteArray();
        byte[] byArray2 = new byte[64];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        int[] nArray = Sha160.G(T_SHS[0], T_SHS[1], T_SHS[2], T_SHS[3], T_SHS[4], byArray2, 0);
        byte[] byArray3 = new byte[20];
        int n = 0;
        for (int i = 0; i < 5; ++i) {
            byArray3[n++] = (byte)(nArray[i] >>> 24);
            byArray3[n++] = (byte)(nArray[i] >>> 16);
            byArray3[n++] = (byte)(nArray[i] >>> 8);
            byArray3[n++] = (byte)nArray[i];
        }
        BigInteger bigInteger = new BigInteger(1, byArray3).mod(this.q);
        this.XKEY = this.XKEY.add(bigInteger).add(BigInteger.ONE).mod(TWO_POW_160);
        return bigInteger;
    }

    private void nextRandomBytes(byte[] byArray) {
        if (this.rnd != null) {
            this.rnd.nextBytes(byArray);
        } else {
            this.getDefaultPRNG().nextBytes(byArray);
        }
    }

    private PRNG getDefaultPRNG() {
        if (this.prng == null) {
            this.prng = PRNG.getInstance();
        }
        return this.prng;
    }

    public DSSKeyPairGenerator() {
        this.finit$();
    }

    static {
        MODULUS_LENGTH = MODULUS_LENGTH;
        USE_DEFAULTS = USE_DEFAULTS;
        STRICT_DEFAULTS = STRICT_DEFAULTS;
        SOURCE_OF_RANDOMNESS = SOURCE_OF_RANDOMNESS;
        DSS_PARAMETERS = DSS_PARAMETERS;
        PREFERRED_ENCODING_FORMAT = PREFERRED_ENCODING_FORMAT;
        T_SHS = new int[]{1732584193, -271733879, -1732584194, 271733878, -1009589776};
        KEY_PARAMS_512 = new DSAParameterSpec(new BigInteger("fca682ce8e12caba26efccf7110e526db078b05edecbcd1eb4a208f3ae1617ae01f35b91a47e6df63413c5e12ed0899bcd132acd50d99151bdc43ee737592e17", 16), new BigInteger("962eddcc369cba8ebb260ee6b6a126d9346e38c5", 16), new BigInteger("678471b27a9cf44ee91a49c5147db1a9aaf244f05a434d6486931d2d14271b9e35030b71fd73da179069b32e2935630e1c2062354d0da20a6c416e50be794ca4", 16));
        KEY_PARAMS_768 = new DSAParameterSpec(new BigInteger("e9e642599d355f37c97ffd3567120b8e25c9cd43e927b3a9670fbec5d890141922d2c3b3ad2480093799869d1e846aab49fab0ad26d2ce6a22219d470bce7d777d4a21fbe9c270b57f607002f3cef8393694cf45ee3688c11a8c56ab127a3daf", 16), new BigInteger("9cdbd84c9f1ac2f38d0f80f42ab952e7338bf511", 16), new BigInteger("30470ad5a005fb14ce2d9dcd87e38bc7d1b1c5facbaecbe95f190aa7a31d23c4dbbcbe06174544401a5b2c020965d8c2bd2171d3668445771f74ba084d2029d83c1c158547f3a9f1a2715be23d51ae4d3e5a1f6a7064f316933a346d3f529252", 16));
        KEY_PARAMS_1024 = new DSAParameterSpec(new BigInteger("fd7f53811d75122952df4a9c2eece4e7f611b7523cef4400c31e3f80b6512669455d402251fb593d8d58fabfc5f5ba30f6cb9b556cd7813b801d346ff26660b76b9950a5a49f9fe8047b1022c24fbba9d7feb7c61bf83b57e7c6a8a6150f04fb83f6d3c51ec3023554135a169132f675f3ae2b61d72aeff22203199dd14801c7", 16), new BigInteger("9760508f15230bccb292b982a2eb840bf0581cf5", 16), new BigInteger("f7e1a085d69b3ddecbbcab5c36b857b97994afbbfa3aea82f9574c0b3d0782675159578ebad4594fe67107108180b449167123e84c281613b7cf09328cc8a6e13c167a8b547c8d28e0a3ae1e2bb3a675916ea37f0bfa213562f1fb627a01243bcca4f1bea8519089a883dfe15ae59f06928b665e807b552564014c3bfecf492a", 16));
        TWO_POW_160 = TWO.pow(160);
    }
}

