/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.server;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.server.RMIClassLoaderSpi;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;

public class RMIClassLoaderImpl
extends RMIClassLoaderSpi {
    private static RMIClassLoaderImpl instance = null;
    private static Map cacheLoaders = new Hashtable(89);
    private static Map cacheAnnotations = new Hashtable(89);
    private static MyClassLoader defaultClassLoader;
    private static String defaultAnnotation;
    private static URL defaultCodebase;

    private RMIClassLoaderImpl() {
    }

    public static RMIClassLoaderSpi getInstance() {
        if (instance == null) {
            instance = new RMIClassLoaderImpl();
        }
        return instance;
    }

    public Class loadClass(String string, String string2, ClassLoader classLoader) throws MalformedURLException, ClassNotFoundException {
        ClassLoader classLoader2 = classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader;
        try {
            return Class.forName(string2, false, classLoader2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classLoader2 = string.length() == 0 ? defaultClassLoader : this.getClassLoader(string);
            if (classLoader2 == null) {
                throw new ClassNotFoundException("Could not find class (" + string2 + ") at codebase (" + string + ")");
            }
            return Class.forName(string2, false, classLoader2);
        }
    }

    public Class loadProxyClass(String string, String[] stringArray, ClassLoader classLoader) throws MalformedURLException, ClassNotFoundException {
        return null;
    }

    public ClassLoader getClassLoader(String string) throws MalformedURLException {
        CacheKey cacheKey = new CacheKey(string, Thread.currentThread().getContextClassLoader());
        ClassLoader classLoader = (ClassLoader)cacheLoaders.get(cacheKey);
        if (classLoader == null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            ArrayList arrayList = new ArrayList();
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(new URL(stringTokenizer.nextToken()));
            }
            classLoader = new MyClassLoader((URL[])arrayList.toArray(new URL[arrayList.size()]), Thread.currentThread().getContextClassLoader(), string);
            cacheLoaders.put(cacheKey, classLoader);
        }
        return classLoader;
    }

    public String getClassAnnotation(Class clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader == null || classLoader == ClassLoader.getSystemClassLoader()) {
            return System.getProperty("java.rmi.server.codebase");
        }
        if (classLoader instanceof MyClassLoader) {
            return ((MyClassLoader)classLoader).getClassAnnotation();
        }
        String string = (String)cacheAnnotations.get(classLoader);
        if (string != null) {
            return string;
        }
        if (classLoader instanceof URLClassLoader) {
            URL[] uRLArray = ((URLClassLoader)classLoader).getURLs();
            if (uRLArray.length == 0) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer(64 * uRLArray.length);
            for (int i = 0; i < uRLArray.length; ++i) {
                stringBuffer.append(uRLArray[i].toExternalForm());
                stringBuffer.append(' ');
            }
            string = stringBuffer.toString();
            cacheAnnotations.put(classLoader, string);
            return string;
        }
        return System.getProperty("java.rmi.server.codebase");
    }

    static {
        defaultAnnotation = System.getProperty("java.rmi.server.defaultAnnotation");
        try {
            if (defaultAnnotation != null) {
                defaultCodebase = new URL(defaultAnnotation);
            }
        }
        catch (Exception exception) {
            defaultCodebase = null;
        }
        if (defaultCodebase != null) {
            defaultClassLoader = new MyClassLoader(new URL[]{defaultCodebase}, null, defaultAnnotation);
            cacheLoaders.put(new CacheKey(defaultAnnotation, Thread.currentThread().getContextClassLoader()), defaultClassLoader);
        }
    }

    private static class CacheKey {
        private String mCodeBase;
        private ClassLoader mContextClassLoader;

        public CacheKey(String string, ClassLoader classLoader) {
            this.mCodeBase = string;
            this.mContextClassLoader = classLoader;
        }

        public boolean equals(Object object) {
            if (object instanceof CacheKey) {
                CacheKey cacheKey = (CacheKey)object;
                return this.equals(this.mCodeBase, cacheKey.mCodeBase) && this.equals(this.mContextClassLoader, cacheKey.mContextClassLoader);
            }
            return false;
        }

        private boolean equals(Object object, Object object2) {
            if (object != null) {
                return object.equals(object2);
            }
            return object2 == null;
        }

        public int hashCode() {
            return (this.mCodeBase != null ? this.mCodeBase.hashCode() : 0) ^ (this.mContextClassLoader != null ? this.mContextClassLoader.hashCode() : -1);
        }

        public String toString() {
            return "[" + this.mCodeBase + "," + this.mContextClassLoader + "]";
        }
    }

    private static class MyClassLoader
    extends URLClassLoader {
        private final String annotation;

        MyClassLoader(URL[] uRLArray, ClassLoader classLoader, String string) {
            super(uRLArray, classLoader);
            this.annotation = string;
        }

        MyClassLoader(URL[] uRLArray, ClassLoader classLoader) {
            super(uRLArray, classLoader);
            this.annotation = MyClassLoader.urlToAnnotation(uRLArray);
        }

        public static String urlToAnnotation(URL[] uRLArray) {
            if (uRLArray.length == 0) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer(64 * uRLArray.length);
            for (int i = 0; i < uRLArray.length; ++i) {
                stringBuffer.append(uRLArray[i].toExternalForm());
                stringBuffer.append(' ');
            }
            return stringBuffer.toString();
        }

        public final String getClassAnnotation() {
            return this.annotation;
        }
    }
}

