/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.local;

import gnu.java.net.local.LocalSocketAddress;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;

final class LocalSocketImpl
extends SocketImpl {
    private boolean created;
    private InputStream in;
    private OutputStream out;
    private int socket_fd;
    private LocalSocketAddress local;
    private LocalSocketAddress remote;

    LocalSocketImpl() {
        this(false);
    }

    LocalSocketImpl(boolean bl) {
        this.created = bl;
        this.socket_fd = -1;
        this.fd = new FileDescriptor();
    }

    public void setOption(int n, Object object) throws SocketException {
        throw new SocketException("local sockets do not support options");
    }

    public Object getOption(int n) throws SocketException {
        throw new SocketException("local sockets do not support options");
    }

    protected void create(boolean bl) throws IOException {
    }

    protected void listen(int n) throws IOException {
    }

    protected void accept(LocalSocketImpl localSocketImpl) throws IOException {
    }

    protected int available() throws IOException {
        return -1;
    }

    protected void close() throws IOException {
    }

    protected void sendUrgentData(int n) throws IOException {
    }

    protected void shutdownInput() throws IOException {
    }

    protected void shutdownOutput() throws IOException {
    }

    void unlink() throws IOException {
    }

    void localBind(LocalSocketAddress localSocketAddress) throws IOException {
    }

    void localConnect(LocalSocketAddress localSocketAddress) throws IOException {
    }

    int read(byte[] byArray, int n, int n2) throws IOException {
        return -1;
    }

    void write(byte[] byArray, int n, int n2) throws IOException {
    }

    void doCreate() throws IOException {
        if (!this.created) {
            this.create(true);
        }
    }

    LocalSocketAddress getLocalAddress() {
        return this.local;
    }

    LocalSocketAddress getRemoteAddress() {
        return this.remote;
    }

    protected InputStream getInputStream() {
        if (this.in == null) {
            this.in = new LocalInputStream(this, this);
        }
        return this.in;
    }

    protected OutputStream getOutputStream() {
        if (this.out == null) {
            this.out = new LocalOutputStream(this, this);
        }
        return this.out;
    }

    protected void accept(SocketImpl socketImpl) throws IOException {
        if (!(socketImpl instanceof LocalSocketImpl)) {
            throw new IllegalArgumentException("not a local socket");
        }
        this.accept((LocalSocketImpl)socketImpl);
    }

    protected void connect(String string, int n) throws IOException {
        throw new SocketException("this is a local socket");
    }

    protected void connect(InetAddress inetAddress, int n) throws IOException {
        throw new SocketException("this is a local socket");
    }

    protected void connect(SocketAddress socketAddress, int n) throws IOException {
        if (!(socketAddress instanceof LocalSocketAddress)) {
            throw new SocketException("address is not local");
        }
        this.localConnect((LocalSocketAddress)socketAddress);
    }

    protected void bind(InetAddress inetAddress, int n) throws IOException {
        throw new SocketException("this is a local socket");
    }

    protected void bind(SocketAddress socketAddress) throws IOException {
        if (!(socketAddress instanceof LocalSocketAddress)) {
            throw new SocketException("address is not local");
        }
        this.localBind((LocalSocketAddress)socketAddress);
    }

    class LocalOutputStream
    extends OutputStream {
        private /* synthetic */ LocalSocketImpl this$0;
        private final LocalSocketImpl impl;

        LocalOutputStream(LocalSocketImpl localSocketImpl, LocalSocketImpl localSocketImpl2) {
            this.this$0 = localSocketImpl;
            this.impl = localSocketImpl2;
        }

        public void close() throws IOException {
            this.impl.close();
        }

        public void flush() throws IOException {
        }

        public void write(int n) throws IOException {
            byte[] byArray = new byte[]{(byte)n};
            this.write(byArray);
        }

        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.impl.write(byArray, n, n2);
        }
    }

    class LocalInputStream
    extends InputStream {
        private /* synthetic */ LocalSocketImpl this$0;
        private final LocalSocketImpl impl;

        LocalInputStream(LocalSocketImpl localSocketImpl, LocalSocketImpl localSocketImpl2) {
            this.this$0 = localSocketImpl;
            this.impl = localSocketImpl2;
        }

        public int available() throws IOException {
            return this.impl.available();
        }

        public boolean markSupported() {
            return false;
        }

        public void mark(int n) {
        }

        public void reset() throws IOException {
            throw new IOException("mark/reset not supported");
        }

        public void close() throws IOException {
            this.impl.close();
        }

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            int n = this.read(byArray);
            if (n != -1) {
                return byArray[0] & 0xFF;
            }
            return -1;
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = this.impl.read(byArray, n, n2);
            if (n3 == 0) {
                return -1;
            }
            return n3;
        }
    }
}

