/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.beans.encoder;

import gnu.java.beans.encoder.Context;
import gnu.java.beans.encoder.GenericScannerState;
import gnu.java.beans.encoder.IgnoringScannerState;
import gnu.java.beans.encoder.ObjectId;
import gnu.java.beans.encoder.Root;
import gnu.java.beans.encoder.ScannerState;
import gnu.java.beans.encoder.StAXWriter;
import gnu.java.beans.encoder.Writer;
import java.beans.Expression;
import java.beans.Statement;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Stack;

public class ScanEngine {
    boolean DEBUG;
    HashMap states;
    Stack parents;
    ScannerState current;
    Root root;
    Writer writer;
    IdentityHashMap objects;
    private static final /* synthetic */ boolean $assertionsDisabled;

    private /* synthetic */ void finit$() {
        this.DEBUG = false;
        this.states = new HashMap();
        this.parents = new Stack();
        this.objects = new IdentityHashMap();
    }

    public ScanEngine(OutputStream outputStream) {
        this.finit$();
        this.writer = new StAXWriter(outputStream);
        this.root = new Root();
        this.current = new GenericScannerState(this.root);
        GenericScannerState genericScannerState = this.current;
        this.register("default", new IgnoringScannerState());
        this.register("start", genericScannerState);
        this.register("ignoreAll", new IgnoringScannerState()).setDefaultSuccessor("ignoreAll");
        genericScannerState.putSuccessor(14, "simple");
        genericScannerState.putSuccessor(13, "simple");
        genericScannerState.putSuccessor(12, "simple");
        this.register("simple", new GenericScannerState(this.root)).setDefaultSuccessor("ignoreAll");
        genericScannerState.putSuccessor(3, "classRes0");
        this.register("classRes0", new GenericScannerState(this.root)).setDefaultSuccessor("ignoreAll");
        genericScannerState.putSuccessor(4, "newObj0");
        ScannerState scannerState = this.register("newObj0", new GenericScannerState(this.root));
        scannerState.setDefaultSuccessor("ignoreAll");
        scannerState.putSuccessor(0, "start");
        genericScannerState.putSuccessor(5, "newPrimitive0");
        this.register("newPrimitive0", new GenericScannerState(this.root)).setDefaultSuccessor("ignoreAll");
        genericScannerState.putSuccessor(6, "newObjectArray");
        scannerState = this.register("newObjectArray", new GenericScannerState(this.root));
        scannerState.putSuccessor(9, "newOArrayGet");
        scannerState.putSuccessor(8, "ignoreAll");
        scannerState.putSuccessor(3, "ignoreAll");
        scannerState.putSuccessor(5, "ignoreAll");
        scannerState = new GenericScannerState(this.root);
        this.register("newOArrayGet", scannerState);
        scannerState.putSuccessor(5, "newOArrayGet_ignoreFirstInteger");
        scannerState.putSuccessor(14, "simple");
        scannerState.putSuccessor(13, "simple");
        scannerState.putSuccessor(12, "simple");
        scannerState.putSuccessor(3, "classRes0");
        scannerState.putSuccessor(4, "newObj0");
        scannerState.putSuccessor(7, "newPrimitiveArray");
        scannerState.putSuccessor(6, "newObjectArray");
        scannerState = this.register("newOArrayGet_ignoreFirstInteger", new GenericScannerState(this.root, 1));
        scannerState.putSuccessor(3, "ignoreAll");
        scannerState.putSuccessor(5, "ignoreAll");
        scannerState.putSuccessor(14, "ignoreAll");
        scannerState.putSuccessor(13, "ignoreAll");
        scannerState.setDefaultSuccessor("start");
        genericScannerState.putSuccessor(7, "newPrimitiveArray");
        scannerState = this.register("newPrimitiveArray", new GenericScannerState(this.root));
        scannerState.putSuccessor(9, "ignoreAll");
        scannerState.putSuccessor(8, "newPArraySet");
        scannerState.putSuccessor(3, "ignoreAll");
        scannerState.putSuccessor(5, "ignoreAll");
        scannerState = this.register("newPArraySet", new GenericScannerState(this.root));
        scannerState.putSuccessor(5, "newPArraySet_ignoreFirstInteger");
        scannerState.putSuccessor(14, "ignoreAll");
        scannerState.putSuccessor(13, "ignoreAll");
        scannerState.putSuccessor(12, "ignoreAll");
        scannerState.putSuccessor(3, "ingoreAll");
        scannerState.putSuccessor(4, "ignoreAll");
        scannerState.putSuccessor(7, "ignoreAll");
        scannerState.putSuccessor(6, "ignoreAll");
        scannerState = this.register("newPArraySet_ignoreFirstInteger", new GenericScannerState(this.root, 1));
        scannerState.putSuccessor(3, "ignoreAll");
        scannerState.putSuccessor(5, "ignoreAll");
        scannerState.putSuccessor(14, "ignoreAll");
        scannerState.putSuccessor(13, "ignoreAll");
        scannerState.setDefaultSuccessor("start");
    }

    private ScannerState register(String string, ScannerState scannerState) {
        scannerState.init(string);
        this.states.put(string, scannerState);
        return scannerState;
    }

    private ObjectId retrieveId(Object object) {
        Class clazz = object.getClass();
        ObjectId objectId = null;
        if (clazz != ScanEngine.class$("java.lang.String") && clazz.getSuperclass() != ScanEngine.class$("java.lang.Number") && clazz != ScanEngine.class$("java.lang.Boolean") && (objectId = (ObjectId)this.objects.get(object)) == null) {
            objectId = new ObjectId(clazz);
            this.objects.put(object, objectId);
        }
        return objectId;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void writeExpression(Expression expression) {
        String string = expression.getMethodName();
        Object[] objectArray = expression.getArguments();
        Object object = expression.getTarget();
        Object object2 = null;
        try {
            object2 = expression.getValue();
        }
        catch (Exception exception) {
            throw (InternalError)new InternalError("The Expression's value should be available at this point.").initCause(exception);
        }
        Class clazz = object2.getClass();
        if (object == ScanEngine.class$("java.lang.reflect.Array")) {
            if (string.equals("newInstance")) {
                ObjectId objectId = this.retrieveId(object2);
                Class clazz2 = (Class)objectArray[0];
                if (clazz2.isPrimitive() || clazz2 == ScanEngine.class$("java.lang.Boolean") || clazz2 == ScanEngine.class$("java.lang.Byte") || clazz2 == ScanEngine.class$("java.lang.Short") || clazz2 == ScanEngine.class$("java.lang.Integer") || clazz2 == ScanEngine.class$("java.lang.Long") || clazz2 == ScanEngine.class$("java.lang.Float") || clazz2 == ScanEngine.class$("java.lang.Double")) {
                    this.primitiveArrayInstantiation(clazz2.getName(), objectArray[1].toString(), objectId);
                } else {
                    this.objectArrayInstantiation(clazz2.getName(), objectArray[1].toString(), objectId);
                }
                return;
            }
            if (string.equals("get")) {
                this.arrayGet(objectArray[1].toString());
                ObjectId objectId = (ObjectId)this.objects.get(object2);
                if (objectId != null && clazz != ScanEngine.class$("java.lang.Class")) {
                    this.objectReference(objectId);
                    this.end();
                }
                return;
            }
            if (string.equals("set")) {
                this.arraySet(objectArray[1].toString());
                return;
            }
        }
        ObjectId objectId = this.retrieveId(object2);
        if (object instanceof Class) {
            if (string.equals("new")) {
                Class clazz3 = (Class)object;
                if (clazz == ScanEngine.class$("java.lang.Boolean")) {
                    this.primitiveInstantiation("boolean", objectArray[0].toString());
                } else if (clazz == ScanEngine.class$("java.lang.Byte")) {
                    this.primitiveInstantiation("byte", objectArray[0].toString());
                } else if (clazz == ScanEngine.class$("java.lang.Short")) {
                    this.primitiveInstantiation("short", objectArray[0].toString());
                } else if (clazz == ScanEngine.class$("java.lang.Integer")) {
                    this.primitiveInstantiation("int", objectArray[0].toString());
                } else if (clazz == ScanEngine.class$("java.lang.Long")) {
                    this.primitiveInstantiation("long", objectArray[0].toString());
                } else if (clazz == ScanEngine.class$("java.lang.Float")) {
                    this.primitiveInstantiation("float", objectArray[0].toString());
                } else if (clazz == ScanEngine.class$("java.lang.Double")) {
                    this.primitiveInstantiation("double", objectArray[0].toString());
                } else {
                    this.objectInstantiation(clazz3.getName(), objectId);
                }
                return;
            }
            if (object2 instanceof Class) {
                String string2 = ((Class)object2).getName();
                if (string.equals("forName")) {
                    this.classResolution(string2);
                    return;
                }
                if (string.equals("getField")) {
                    this.staticFieldAccess(string2, objectArray[0].toString());
                    return;
                }
                this.staticMethodInvocation(string2, string);
                return;
            }
        } else if (object instanceof List) {
            if (string.equals("get")) {
                this.listGet();
                return;
            }
            if (string.equals("set")) {
                this.listSet();
                return;
            }
        }
        this.methodInvocation(string);
    }

    public void end() {
        this.current.end();
        if (this.DEBUG) {
            System.err.print("back from " + this.current.getName());
        }
        ScannerState scannerState = this.current;
        this.current = (ScannerState)this.parents.pop();
        if (this.DEBUG) {
            System.err.println(" to " + this.current.getName());
        }
    }

    public void revoke() {
        ScannerState scannerState = this.current;
        this.current = (ScannerState)this.parents.pop();
        this.root.deleteLast();
    }

    public void writeStatement(Statement statement) {
        String string = statement.getMethodName();
        Object object = statement.getTarget();
        Object[] objectArray = statement.getArguments();
        if (object == ScanEngine.class$("java.lang.reflect.Array") && string.equals("set")) {
            this.arraySet(objectArray[1].toString());
            return;
        }
        if (object instanceof List && string.equals("set")) {
            this.listSet();
            return;
        }
        this.methodInvocation(string);
    }

    public boolean writeObject(Object object) {
        ObjectId objectId = null;
        if (object == null) {
            this.nullObject();
            this.end();
        } else if (object.getClass() == ScanEngine.class$("java.lang.String")) {
            this.stringReference((String)object);
            this.end();
        } else {
            objectId = (ObjectId)this.objects.get(object);
            if (objectId != null) {
                if (object.getClass() == ScanEngine.class$("java.lang.Class")) {
                    this.classResolution(((Class)object).getName());
                    this.end();
                    return false;
                }
                this.objectReference(objectId);
                this.end();
                return false;
            }
        }
        return true;
    }

    public void flush() {
        this.objects.clear();
        this.root.traverse(this.writer);
    }

    public void close() {
        this.flush();
        this.root.close(this.writer);
    }

    private void transition(int n) {
        this.parents.push(this.current);
        String string = this.current.getSuccessor(n);
        if (this.DEBUG) {
            System.err.println("from state: " + this.current.getName() + "\n\troute: " + ScannerState.transitionNames[n] + "\n\t\tto state: " + string);
        }
        ScannerState scannerState = (ScannerState)this.states.get(string);
        scannerState.enter(new Context(this.current.getName(), this.current.getCalls()));
        if (!$assertionsDisabled && scannerState == null) {
            throw new AssertionError((Object)("State '" + string + "' was not defined."));
        }
        this.current = scannerState;
    }

    void methodInvocation(String string) {
        this.transition(0);
        this.current.methodInvocation(string);
    }

    void staticMethodInvocation(String string, String string2) {
        this.transition(1);
        this.current.staticMethodInvocation(string, string2);
    }

    void staticFieldAccess(String string, String string2) {
        this.transition(2);
        this.current.staticFieldAccess(string, string2);
    }

    void classResolution(String string) {
        this.transition(3);
        this.current.classResolution(string);
    }

    void objectInstantiation(String string, ObjectId objectId) {
        this.transition(4);
        this.current.objectInstantiation(string, objectId);
    }

    void primitiveInstantiation(String string, String string2) {
        this.transition(5);
        this.current.primitiveInstantiation(string, string2);
    }

    void objectArrayInstantiation(String string, String string2, ObjectId objectId) {
        this.transition(6);
        this.current.objectArrayInstantiation(string, string2, objectId);
    }

    void primitiveArrayInstantiation(String string, String string2, ObjectId objectId) {
        this.transition(7);
        this.current.objectArrayInstantiation(string, string2, objectId);
    }

    void arraySet(String string) {
        this.transition(8);
        this.current.arraySet(string);
    }

    void arrayGet(String string) {
        this.transition(9);
        this.current.arrayGet(string);
    }

    void listSet() {
        this.transition(10);
        this.current.listSet();
    }

    void listGet() {
        this.transition(11);
        this.current.listGet();
    }

    void nullObject() {
        this.transition(12);
        this.current.nullObject();
    }

    void stringReference(String string) {
        this.transition(13);
        this.current.stringReference(string);
    }

    void objectReference(ObjectId objectId) {
        this.transition(14);
        this.current.objectReference(objectId);
    }

    static {
        $assertionsDisabled = ScanEngine.class$("gnu.java.beans.encoder.ScanEngine").desiredAssertionStatus() ^ true;
    }
}

