/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.font.opentype.truetype;

import java.awt.FontFormatException;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;

final class GlyphMeasurer {
    private final ShortBuffer horizontalGlyphMetrics;
    private final ShortBuffer verticalGlyphMetrics;
    private final int numLongHorizontalMetricsEntries;
    private final int numLongVerticalMetricsEntries;
    private final int horizontalAscent;
    private final int verticalAscent;
    private final int horizontalDescent;
    private final int verticalDescent;
    private final int horizontalLineGap;

    GlyphMeasurer(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, ByteBuffer byteBuffer3, ByteBuffer byteBuffer4) throws FontFormatException {
        if (byteBuffer.getInt(0) != 65536 || byteBuffer.getInt(30) != 0) {
            throw new FontFormatException("unsupported hhea format");
        }
        this.horizontalAscent = byteBuffer.getShort(4);
        this.horizontalDescent = byteBuffer.getShort(6);
        this.horizontalLineGap = byteBuffer.getShort(8);
        this.numLongHorizontalMetricsEntries = byteBuffer.getChar(34);
        this.horizontalGlyphMetrics = byteBuffer2.asShortBuffer();
        if (byteBuffer3 != null) {
            this.verticalAscent = byteBuffer3.getShort(4);
            this.verticalDescent = byteBuffer3.getShort(6);
            this.numLongVerticalMetricsEntries = byteBuffer3.getChar(34);
            this.verticalGlyphMetrics = byteBuffer4.asShortBuffer();
        } else {
            this.verticalAscent = byteBuffer.getChar(10) / 2;
            this.verticalDescent = -this.verticalAscent;
            this.numLongVerticalMetricsEntries = 0;
            this.verticalGlyphMetrics = null;
        }
    }

    public int getAscent(boolean bl) {
        if (bl) {
            return this.horizontalAscent;
        }
        return this.verticalAscent;
    }

    public int getDescent(boolean bl) {
        if (bl) {
            return this.horizontalDescent;
        }
        return this.verticalDescent;
    }

    public int getLineGap(boolean bl) {
        return this.horizontalLineGap;
    }

    public int getAdvanceWidth(int n, boolean bl) {
        if (!bl) {
            return 0;
        }
        n = Math.min(n, this.numLongHorizontalMetricsEntries - 1);
        return this.horizontalGlyphMetrics.get(n << 1);
    }

    public int getAdvanceHeight(int n, boolean bl) {
        if (bl) {
            return 0;
        }
        if (this.verticalGlyphMetrics == null) {
            return this.horizontalAscent - this.horizontalDescent + this.horizontalLineGap;
        }
        n = Math.min(n, this.numLongVerticalMetricsEntries - 1);
        return this.verticalGlyphMetrics.get(n << 1);
    }
}

